/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class ConditionBuilder
extends ExpressionFactory {
    private static Map<String, Comparison.Comparator> s_op_map = new HashMap<String, Comparison.Comparator>();

    @Override
    public SQLFragment createFragment(ExpressionContext context, ParseNode node) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (!helper.isRule(node, "condition")) {
            return null;
        }
        Comparison retval = null;
        List<ParseNode> kids = helper.getOrderedChildren(node);
        SQLFragment creating = context.getCreating();
        Object queryContext = context.getQueryContext();
        if (helper.isRule(node, "null_condition")) {
            int notIndex = helper.getKeywordIndex(kids, "not");
            Comparison.Comparator type = notIndex == -1 ? Comparison.Comparator.NULL : Comparison.Comparator.NOT_NULL;
            SQLFragment operand = context.createFragment(kids.get(0), creating, queryContext);
            retval = new Comparison(operand, type, null);
        } else if (helper.isRule(node, "is_JSON_condition")) {
            int nodes;
            Comparison.Comparator type;
            int notIndex = helper.getKeywordIndex(kids, "not");
            if (notIndex == -1) {
                type = Comparison.Comparator.JSON;
                nodes = 2;
            } else {
                type = Comparison.Comparator.NOT_JSON;
                nodes = 3;
            }
            SQLFragment operand = context.createFragment(kids.get(0), creating, queryContext);
            SimpleSQLFragment extras = null;
            if (kids.size() > nodes + 1) {
                StringBuilder buff = new StringBuilder();
                for (int i = nodes + 1; i < kids.size(); ++i) {
                    ParseNode n = kids.get(i);
                    if (n == null) continue;
                    if (buff.length() > 0) {
                        buff.append(' ');
                    }
                    buff.append(helper.getContent(n));
                }
                if (buff.length() > 0) {
                    extras = new SimpleSQLFragment(buff.toString());
                }
            }
            retval = new Comparison(operand, type, extras);
        } else if (helper.isRule(node, "regexp_like_condition")) {
            SQLFragment[] argsL = context.getArgList(retval, node);
            retval = new Comparison(Comparison.Comparator.REGEXP_LIKE, argsL);
        } else if (helper.isRule(node, "like_condition")) {
            SQLFragment lhs = context.createFragment(kids.get(0), creating, queryContext);
            SQLFragment rhs = context.createFragment(kids.get(kids.size() - 1), creating, queryContext);
            int notIndex = helper.getKeywordIndex(kids, "not");
            Comparison.Comparator type = notIndex == -1 ? Comparison.Comparator.LIKE : Comparison.Comparator.NOT_LIKE;
            retval = new Comparison(lhs, type, rhs);
        } else if (helper.isRule(node, "comparison_condition", "simple_comparison_condition")) {
            if (helper.isRule(node, "group_comparison_condition") && (kids.size() == 6 || kids.size() == 7)) {
                Comparison.Comparator operation;
                String op = helper.getContent(kids.get(1)) + helper.getContent(kids.get(2));
                int rhs_index = 4;
                if (kids.size() == 7) {
                    op = op + helper.getContent(kids.get(3));
                    rhs_index = 5;
                }
                if ((operation = this.getOperation(op)) != null) {
                    SQLFragment lhs = context.createFragment(kids.get(0), creating);
                    List<SQLFragment> exprlist = this.getExpressionList(kids.get(rhs_index), context);
                    ExpressionList rhs = new ExpressionList(exprlist.toArray(new SQLFragment[exprlist.size()]));
                    retval = new Comparison(lhs, operation, (SQLFragment)rhs);
                }
            } else if (helper.isRule(node, "comparison_condition", "simple_comparison_condition") && (kids.size() == 4 || kids.size() == 3)) {
                SQLFragment lhs = context.createFragment(kids.get(0), creating);
                boolean priorOnLeft = this.hasPrior(kids.get(0), context);
                int rhs_index = 2;
                String op = helper.getContent(kids.get(1));
                if (kids.size() == 4) {
                    op = op + helper.getContent(kids.get(2));
                    rhs_index = 3;
                }
                SQLFragment rhs = context.createFragment(kids.get(rhs_index), creating);
                boolean priorOnRight = this.hasPrior(kids.get(rhs_index), context);
                Comparison.Comparator type = this.getOperation(op);
                if (type != null) {
                    retval = new Comparison(lhs, type, rhs);
                    retval.setPriorOnLeft(priorOnLeft);
                    retval.setPriorOnRight(priorOnRight);
                }
            }
        } else if (helper.isRule(node, "condition")) {
            if (helper.isRule(node, "in_condition")) {
                SQLFragment lhs;
                SQLFragment[] args = null;
                if (helper.isKeyword(kids.get(0), "(")) {
                    SQLFragment[] lhsSet = this.getExpressionList(kids, 0, helper.getKeywordIndex(kids, ")"), context);
                    lhs = new ExpressionList(lhsSet);
                } else {
                    lhs = context.createFragment(kids.get(0), creating);
                }
                boolean isNot = helper.getKeywordIndex(kids, "not") != -1;
                int inIndex = helper.getKeywordIndex(kids, "IN");
                int lparenIndex = inIndex + 1;
                int rparenIndex = kids.size() - 1;
                SQLFragment[] rhsSet = this.getExpressionList(kids, lparenIndex, rparenIndex, context);
                if (rhsSet.length == 1 && rhsSet[0] instanceof ExpressionList) {
                    rhsSet = ((ExpressionList)rhsSet[0]).getArguments();
                }
                args = new SQLFragment[1 + rhsSet.length];
                args[0] = lhs;
                for (int i = 0; i < rhsSet.length; ++i) {
                    args[i + 1] = rhsSet[i];
                }
                SetOperation.Operator in = isNot ? SetOperation.Operator.NOT_IN : SetOperation.Operator.IN;
                retval = new SetOperation(in, args);
            } else if (helper.isRule(node, "exists_condition")) {
                boolean isNot = "not".equals(context.getQueryContext());
                int existsIndex = helper.getKeywordIndex(kids, "EXISTS");
                SQLFragment arg = context.createFragment(kids.get(existsIndex + 2), creating);
                Comparison.Comparator exists = isNot ? Comparison.Comparator.NOT_EXISTS : Comparison.Comparator.EXISTS;
                retval = new Comparison(arg, exists);
            } else if (kids.size() == 2 && helper.isKeyword(kids.get(0), "not")) {
                retval = context.createFragment(kids.get(1), creating, "not");
            }
        }
        return retval;
    }

    private boolean hasPrior(ParseNode n, ExpressionContext context) {
        boolean retval = false;
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<ParseNode> kids = helper.getOrderedChildren(n);
        if (helper.isRule(n, "compound_expression") && kids.size() == 2 && helper.isKeyword(kids.get(0), "PRIOR")) {
            retval = true;
        }
        return retval;
    }

    private Comparison.Comparator getOperation(String op) {
        Comparison.Comparator retval = Comparison.getComparator((String)(op = op.toUpperCase()));
        if (retval == null) {
            retval = s_op_map.get(op);
        }
        return retval;
    }

    private SQLFragment[] getExpressionList(List<ParseNode> parenlist, int lparenIndex, int rparenIndex, ExpressionContext context) throws SQLQueryException {
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        List<Object> exprlist = new ArrayList();
        SQLFragment[] retval = null;
        if (rparenIndex == lparenIndex + 2 && helper.isRule(parenlist.get(lparenIndex + 1), "\"expr_list\"")) {
            exprlist = this.getExpressionList(parenlist.get(lparenIndex + 1), context);
        } else {
            for (int i = lparenIndex + 1; i < rparenIndex; ++i) {
                if (helper.isKeyword(parenlist.get(i), ",")) continue;
                List<SQLFragment> subexprlist = this.getExpressionList(parenlist.get(i), context);
                ExpressionList expr = new ExpressionList(subexprlist.toArray(new SQLFragment[subexprlist.size()]));
                exprlist.add(expr);
            }
        }
        retval = exprlist.toArray(new SQLFragment[exprlist.size()]);
        return retval;
    }

    private List<SQLFragment> getExpressionList(ParseNode p, ExpressionContext context) throws SQLQueryException {
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        OracleSQLQueryBuilderHelper helper = context.getHelper();
        if (helper.isRule(p, "expr", "query_block")) {
            SQLFragment expr = context.createFragment(p, context.getCreating());
            retval.add(expr);
        } else if (helper.isRule(p, "expression_list", "\"expr_list\"")) {
            List<ParseNode> kids = helper.getOrderedChildren(p);
            for (ParseNode kid : kids) {
                retval.addAll(this.getExpressionList(kid, context));
            }
        }
        return retval;
    }

    static {
        s_op_map.put("!=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("^=", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("<>", Comparison.Comparator.NOT_EQUAL);
        s_op_map.put("!=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("^=ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("<>ANY", Comparison.Comparator.NOT_EQUAL_ANY);
        s_op_map.put("!=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("^=ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("<>ALL", Comparison.Comparator.NOT_EQUAL_ALL);
        s_op_map.put("!=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("^=SOME", Comparison.Comparator.NOT_EQUAL_SOME);
        s_op_map.put("<>SOME", Comparison.Comparator.NOT_EQUAL_SOME);
    }
}

