/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;

class OMBIndexPartitionDefPropsBuilder
extends OMBPropsStatementBuilder {
    public OMBIndexPartitionDefPropsBuilder(Object forIndexPartition) {
        this.setContextObject(forIndexPartition);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        this.registerPropertyMapping("valuesLessThan", new OMBIndexPartitionValuePropResolver((IndexPartition)this.getContextObject()));
    }

    public final class OMBIndexPartitionValuePropResolver
    extends OMBPropertyResolver {
        IndexPartition m_partition = null;
        final String COMMA = ",";

        public OMBIndexPartitionValuePropResolver(IndexPartition partition) {
            this.m_partition = partition;
        }

        @Override
        public String resolvePropertyValue() {
            if (this.m_partition.getValuesLessThan() != null) {
                StringBuffer valuesBuff = new StringBuffer();
                boolean firstTimeAround = true;
                for (int i = 0; i < this.m_partition.getValuesLessThan().length; ++i) {
                    if (!firstTimeAround) {
                        valuesBuff.append(",");
                    }
                    valuesBuff.append(this.m_partition.getValuesLessThan()[i]);
                    firstTimeAround = false;
                }
                if (valuesBuff.length() == 0) {
                    return null;
                }
                return valuesBuff.toString();
            }
            return null;
        }

        @Override
        public String resolvePropertyName() {
            return "VALUES_LESS_THAN";
        }
    }
}

