/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.owb;

import java.util.HashMap;
import java.util.HashSet;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.owb.OMBPropertyResolver;
import oracle.javatools.db.ora.owb.OMBPropertyValidator;
import oracle.javatools.db.ora.owb.OMBPropsStatementBuilder;
import oracle.javatools.db.property.PropertyHelper;

class OMBColumnPropsBuilder
extends OMBPropsStatementBuilder {
    private Column m_col;

    public OMBColumnPropsBuilder(Object forColumn) {
        this.m_col = (Column)forColumn;
        this.setContextObject(forColumn);
        this.registerPropertyMappings();
        this.buildSetProperties();
    }

    @Override
    public void registerPropertyMappings() {
        DBObjectID dbObjId;
        DataTypeUsage dtu;
        this.m_col = (Column)this.getContextObject();
        this.registerPropertyMapping("dataTypeUsage/dataTypeID/name", "DATATYPE");
        this.registerPropertyMapping("default", new OMBColDefaultValuePropResolver(this.m_col));
        PropertyHelper ph = new PropertyHelper();
        Object tabType = ph.getPropertyValue((Object)this.m_col.getParent(), "properties/TableType");
        if (tabType == null || tabType != Table.TableType.EXTERNAL) {
            this.registerPropertyMapping("notNull", "NOT_NULL");
            HashMap<String, String> notNullSubVals = new HashMap<String, String>();
            notNullSubVals.put("true", "1");
            notNullSubVals.put("false", "0");
            this.registerSubstitutionValues("NOT_NULL", notNullSubVals);
        }
        if ((dtu = this.m_col.getDataTypeUsage()) != null && (dbObjId = dtu.getDataTypeID()) instanceof DataTypeID) {
            DataTypeID dtID = (DataTypeID)dbObjId;
            if (dtID.getTypeName().equals("TIMESTAMP")) {
                this.registerPropertyMapping("dataTypeUsage/attributeValues/scale", "FRACTIONAL_SECONDS_PRECISION");
            } else {
                this.registerPropertyMapping("dataTypeUsage/attributeValues/scale", "SCALE");
            }
        }
        this.registerPropertyMapping("dataTypeUsage/attributeValues/precision", "PRECISION");
        this.registerPropertyMapping("dataTypeUsage/attributeValues/size", "LENGTH");
        this.registerPropertyValidator("DATATYPE", new OMBDatatypePropValidator());
    }

    public final class OMBDatatypePropValidator
    extends OMBPropertyValidator {
        HashSet<String> m_validDatatypes = new HashSet();

        void setValidDataTypes() {
            this.m_validDatatypes.add("BINARY_DOUBLE");
            this.m_validDatatypes.add("BINARY_FLOAT");
            this.m_validDatatypes.add("BLOB");
            this.m_validDatatypes.add("CHAR");
            this.m_validDatatypes.add("CLOB");
            this.m_validDatatypes.add("DATE");
            this.m_validDatatypes.add("FLOAT");
            this.m_validDatatypes.add("INTEGER");
            this.m_validDatatypes.add("INTERVAL DAY");
            this.m_validDatatypes.add("INTERVAL YEAR");
            this.m_validDatatypes.add("NCHAR");
            this.m_validDatatypes.add("NCLOB");
            this.m_validDatatypes.add("NUMBER");
            this.m_validDatatypes.add("NVARCHAR2");
            this.m_validDatatypes.add("RAW");
            this.m_validDatatypes.add("SYS.ANYDATA");
            this.m_validDatatypes.add("SYS.LCR$_ROW_RECORD");
            this.m_validDatatypes.add("SYS.XMLFORMAT");
            this.m_validDatatypes.add("TIMESTAMP");
            this.m_validDatatypes.add("VARCHAR");
            this.m_validDatatypes.add("VARCHAR2");
            this.m_validDatatypes.add("XMLTYPE");
        }

        @Override
        public void validateProperty(String propName, String propValue) {
            this.setValidDataTypes();
            if (!this.m_validDatatypes.contains(propValue)) {
                DBLog.getLogger((Object)this).warning("Column datatype " + propValue + " is not supported in OMB Script");
            }
        }
    }

    public final class OMBColDefaultValuePropResolver
    extends OMBPropertyResolver {
        Column m_col = null;

        public OMBColDefaultValuePropResolver(Column col) {
            this.m_col = col;
        }

        @Override
        public String resolvePropertyValue() {
            String defaultVal = (String)this.m_col.getDefault();
            return defaultVal.trim().replaceAll("'", "''");
        }

        @Override
        public String resolvePropertyName() {
            return "DEFAULT_VALUE";
        }
    }
}

