/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.Trigger;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class OracleDDLSupport {
    private static final String BASE = "/oracle/javatools/db/ora/ddl/";
    private static final String ORACLE_DDL_COMMON = "/oracle/javatools/db/ora/ddl/OracleCommonDDL.properties";
    private static final String ORACLE_DDL_BASE = "/oracle/javatools/db/ora/ddl/OracleBaseDDL.properties";
    private static final String ORACLE_LITE_DDL = "/oracle/javatools/db/ora/ddl/OracleLiteDDL.properties";
    private static final String ORACLE_10g_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gDDL.properties";
    private static final String ORACLE_10gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2DDL.properties";
    private static final String ORACLE_10gR2XE_DDL = "/oracle/javatools/db/ora/ddl/Oracle10gR2XEDDL.properties";
    private static final String ORACLE_9iR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle9iDDL.properties";
    private static final String ORACLE_11g_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gDDL.properties";
    private static final String ORACLE_11gR2_DDL = "/oracle/javatools/db/ora/ddl/Oracle11gR2DDL.properties";
    private static final String ORACLE_12c_DDL = "/oracle/javatools/db/ora/ddl/Oracle12cDDL.properties";
    private static final String ORACLE_12cR102_DDL = "/oracle/javatools/db/ora/ddl/Oracle12cR102DDL.properties";
    private String m_simpleDrop;
    private final Map<String, TokenGenerator> m_globals = new TreeMap<String, TokenGenerator>();

    private OracleDDLSupport() {
        this.m_globals.put("islobcol", new IsLOBColumnGenerator());
        this.m_globals.put("fkInRefPartition", new IsFKInRefPartition());
        this.m_globals.put("varraydef", new VarrayDefinitionGenerator());
        this.m_globals.put("lobdef", new LOBDefinitionGenerator());
        this.m_globals.put("lobcoldef", new PartitionLOBGenerator());
        this.m_globals.put("alterlobcoldef", new PartitionAlterLOBGenerator());
        this.m_globals.put("altermovelobcoldef", new PartitionAlterMoveLOBGenerator());
        this.m_globals.put("hastablespaces", new HasTablespacesGenerator());
        this.m_globals.put("hasPartitions", new HasPartitionsGenerator());
        this.m_globals.put("needOSPAlter", new NeedOSPAlterTokenGenerator());
        this.m_globals.put("needOSPMove", new NeedOSPMoveTokenGenerator());
        this.m_globals.put("needIPMod", new NeedIndexPartitionModTokenGenerator());
        this.m_globals.put("refreshDateExpressions", new RefreshDateExpressionsGenerator());
        this.m_globals.put("changedValues", new PartitionValuesChangedTokenGenerator());
        this.m_globals.put("handleWiths", new MatViewLogWithsGenerator());
        this.m_globals.put("handleAddWiths", new MatViewLogAddWithsGenerator());
        this.m_globals.put("handleTrgEvents", new TriggerEventsListGenerator());
        this.m_globals.put("handleTrgBaseObject", new TriggerBaseObjectGenerator());
        this.m_globals.put("getSyntaxFromSource", new SyntaxFromSourceGenerator());
        this.m_globals.put("codeExists", new CodeExistsTokenGenerator());
        this.m_globals.put("refOldAsExists", new TrgOldAsExistsTokenGenerator());
        this.m_globals.put("refNewAsExists", new TrgNewAsExistsTokenGenerator());
        this.m_globals.put("hostExists", new DBLinkHostExistsTokenGenerator());
        this.m_globals.put("schemaText", new XMLSchemaTextTokenGenerator());
        this.m_globals.put("needsRebuildIndexes", new NeedsRebuildIndexesModTokenGenerator());
        this.m_globals.put("needDropAndRecreateConstraint", new DropAndRecreateConTokenGenerator());
        this.m_globals.put("filePath", new FileSpecPathGenerator());
        this.m_globals.put("originalFilePath", new OldFileSpecPathGenerator());
        this.m_globals.put("PlSqlReference", new PlSqlReferenceGenerator());
        this.m_globals.put("renameNewIPIfChanged", new RenameNewIPIfChangedTokenGenerator());
        this.m_globals.put("addStorageToNewIP", new AddStorageToNewIPTokenGenerator());
        this.m_globals.put("needsTbspAlterForNewIP", new NeedsTbspAlterForNewIPTokenGenerator());
        this.m_globals.put("usingIndexName", new ConstraintIndexGenerator("usingIndexName"));
        this.m_globals.put("usingIndexInline", new ConstraintIndexGenerator("usingIndexInline"));
        this.m_globals.put("inConstraintDefintion", new ConstraintIndexGenerator("inConstraintDefintion"));
        this.m_globals.put("pkInCreateTable", new ConstraintIndexGenerator("pkInCreateTable"));
        this.m_globals.put("indexForConstraint", new ConstraintIndexGenerator("indexForConstraint"));
        this.m_globals.put("needToCreateOracleLiteIndex", new OracleLiteUniqueKeyIndexTokenGenerator());
        this.m_globals.put("mvConstraintsNeedsUsing", new MVConstraintsNeedsUsingTokenGenerator());
        this.m_globals.put("password", new PasswordGenerator("password"));
        this.m_globals.put("authentificationPassword", new PasswordGenerator("authentificationPassword"));
        this.m_globals.put("viewColumnsIfNeeded", new ViewColumnGenerator());
        this.m_globals.put("allAlterStatements", new AllAlterStatementsGenerator());
        this.m_globals.put("alterStatementDetail", new AlterStatementDetailGenerator());
    }

    String[] getBundles(Class<? extends OracleDatabase> clz, int version) {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(ORACLE_DDL_COMMON);
        if (OracleLite.class.isAssignableFrom(clz)) {
            retval.add(ORACLE_LITE_DDL);
        } else {
            retval.add(ORACLE_DDL_BASE);
            if (version >= 92) {
                retval.add(ORACLE_9iR2_DDL);
                if (version >= 100) {
                    retval.add(ORACLE_10g_DDL);
                    if (version >= 102) {
                        retval.add(ORACLE_10gR2_DDL);
                        if (version >= 110) {
                            retval.add(ORACLE_11g_DDL);
                            if (version >= 112) {
                                retval.add(ORACLE_11gR2_DDL);
                                if (version >= 120) {
                                    retval.add(ORACLE_12c_DDL);
                                    if (version >= 12102) {
                                        retval.add(ORACLE_12cR102_DDL);
                                    }
                                }
                            }
                        }
                    }
                    if (version == 101 || version == 111) {
                        retval.add(ORACLE_10gR2XE_DDL);
                    }
                }
            }
        }
        return retval.toArray(new String[retval.size()]);
    }

    public void includeOracleSyntax(TokenDDLGenerator gen, String type, boolean includeAlter) {
        DatabaseDescriptor dd = DatabaseFactory.getDatabaseDescriptor(Oracle11g.class);
        gen.includeSyntax(dd, type, includeAlter);
    }

    public String getSimpleDropDDL() {
        if (this.m_simpleDrop == null) {
            InputStream is = null;
            try {
                is = this.getClass().getResourceAsStream(ORACLE_DDL_COMMON);
                Properties props = new Properties();
                props.load(is);
                this.m_simpleDrop = props.getProperty("SIMPLE_DROP");
            }
            catch (IOException ioe) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Couldn't open ddl properties: " + ioe.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.m_simpleDrop;
    }

    public Map<String, TokenGenerator> getGlobalTokenGenerators() {
        return Collections.unmodifiableMap(this.m_globals);
    }

    public static OracleDDLSupport getInstance() {
        DBCore core = DBCore.getInstance();
        OracleDDLSupport retval = (OracleDDLSupport)core.get(OracleDDLSupport.class);
        if (retval == null) {
            retval = new OracleDDLSupport();
            core.put((Object)retval);
        }
        return retval;
    }

    public static class PropertyFilter
    implements DifferenceFilter {
        HashSet<String> m_propsToFilter = new HashSet();

        public void addFilterProp(String prop) {
            this.m_propsToFilter.add(prop);
        }

        public boolean isFilteredProperty(Difference diff, String prop) {
            if (prop.indexOf("/") != -1) {
                prop = prop.substring(prop.indexOf("/") + 1);
            }
            return this.m_propsToFilter.contains(prop);
        }
    }

    private static class AlterStatementDetailGenerator
    extends TokenGenerator {
        public static final String TOKEN = "alterStatementDetail";

        private AlterStatementDetailGenerator() {
        }

        public void generateToken(TokenContext context) {
            Object obj = context.getObject();
            if (obj instanceof Tuple) {
                PlSqlSearch search;
                Object first = ((Tuple)obj).getFirst();
                Object second = ((Tuple)obj).getSecond();
                if (first instanceof PlSqlToken && second instanceof PlSqlToken && (search = new PlSqlSearch("alter type ?. <stmt {?}...>")).matches((PlSqlToken)first, (PlSqlToken)second)) {
                    context.append((Object)search.getNamedMatch("stmt"));
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    private static class AllAlterStatementsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "allAlterStatements";

        private AllAlterStatementsGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            Tuple[] ret = null;
            if (context.getObject() instanceof Type) {
                List alters = null;
                try {
                    PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)context.getObject()), (DBObjectProvider)context.getProvider());
                    if (parser != null) {
                        alters = parser.getAlterStatements();
                    }
                }
                catch (CancelledException e) {
                    alters = null;
                    DBLog.getLogger((Object)((Object)this)).fine(e.getMessage());
                }
                if (alters != null && !alters.isEmpty()) {
                    ret = alters.toArray(new Tuple[alters.size()]);
                }
            }
            return ret;
        }
    }

    private static class ViewColumnGenerator
    extends TokenGenerator {
        public static final String TOKEN = "viewColumnsIfNeeded";

        private ViewColumnGenerator() {
        }

        public void generateToken(TokenContext context) {
            DBObjectProvider pro = context.getProvider();
            Object obj = context.getObject();
            if (pro != null && obj instanceof SQLQueryOwner && obj instanceof Relation) {
                Constraint[] cons;
                Relation origRel;
                SQLQueryBuilder b;
                Relation rel = (Relation)obj;
                SQLQuery query = ((SQLQueryOwner)rel).getSQLQuery();
                if (query != null && (b = SQLQueryBuilderFactory.findOrCreateBuilder((SQLQuery)query, (DBObjectProvider)pro)) instanceof AbstractSQLQueryBuilder) {
                    AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b;
                    try {
                        List qcis = builder.getQueryColumnInfos();
                        boolean addColumnListClause = false;
                        for (AbstractSQLQueryBuilder.QueryColumnInfo qci : qcis) {
                            if (qci.getName() != null || "*".equals(qci.getExpression())) continue;
                            addColumnListClause = true;
                        }
                        StringBuilder sb = new StringBuilder();
                        if (addColumnListClause) {
                            int colCount = 0;
                            for (Column col : rel.getColumns()) {
                                if (colCount == 0) {
                                    sb.append("( ");
                                } else {
                                    sb.append("\n, ");
                                }
                                ++colCount;
                                String name = col.getName();
                                if (name == null) {
                                    addColumnListClause = false;
                                    break;
                                }
                                sb.append(name);
                            }
                            if (colCount > 0) {
                                sb.append("\n)\n");
                            }
                        }
                        if (addColumnListClause) {
                            context.append((Object)sb.toString());
                        }
                    }
                    catch (SQLQueryException qcis) {
                        // empty catch block
                    }
                }
                if (rel.getID() instanceof TemporaryObjectID && (origRel = (Relation)TemporaryObjectID.findOriginalObject((TemporaryObjectID)((TemporaryObjectID)rel.getID()))) instanceof SQLQueryOwner && (cons = origRel.getConstraints()) != null && cons.length > 0) {
                    SQLQuery origQuery = ((SQLQueryOwner)origRel).getSQLQuery();
                    if (ModelUtil.areDifferent((Object)query.getSQLText(), (Object)origQuery.getSQLText())) {
                        rel.getColumns();
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("columns");
        }
    }

    private static class OracleLiteUniqueKeyIndexTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "needToCreateOracleLiteIndex";

        private OracleLiteUniqueKeyIndexTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            Index index;
            DBObjectProvider pro = context.getProvider();
            if (!"Oracle Lite".equals(pro.getDescriptor().getDatabaseType())) {
                throw new IllegalStateException("Token needToCreateOracleLiteIndex referenced in a non-Oracle Lite context.");
            }
            UniqueConstraint uk = null;
            boolean ret = true;
            if (context.getObject() instanceof Index) {
                Constraint con;
                index = (Index)context.getObject();
                Table table = index.getTable();
                if (table != null && (con = (Constraint)DBUtil.findChildByName((DBObject)table, (String)"constraints", (String)index.getName(), (DBObjectProvider)pro)) instanceof UniqueConstraint) {
                    uk = (UniqueConstraint)con;
                }
            } else {
                index = null;
                ret = false;
            }
            if (index != null) {
                Difference indexDiff = context.findUpdateDifference((DBObject)index);
                Difference ukDiff = context.findUpdateDifference(uk);
                if (indexDiff != null && ukDiff == null) {
                    uk = null;
                }
                if (ConstraintIndexHelper.isSystemGenerated(index) || ConstraintIndexHelper.indexDefaultForConstraint(index, uk, pro)) {
                    ret = false;
                }
            }
            return ret;
        }
    }

    private static class ConstraintIndexGenerator
    extends TokenGenerator {
        public static final String TOKEN1 = "usingIndexName";
        public static final String TOKEN2 = "usingIndexInline";
        public static final String TOKEN3 = "inConstraintDefintion";
        public static final String TOKEN4 = "pkInCreateTable";
        public static final String TOKEN5 = "indexForConstraint";
        final String m_mode;

        public ConstraintIndexGenerator(String mode) {
            this.m_mode = mode;
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            Index index;
            boolean otherwise;
            boolean pkOnly;
            boolean isSystem;
            boolean isDefault;
            boolean isNull;
            if (TOKEN1.equals(this.m_mode)) {
                isNull = false;
                isDefault = false;
                isSystem = false;
                pkOnly = false;
                otherwise = true;
            } else if (TOKEN2.equals(this.m_mode)) {
                isNull = false;
                isDefault = false;
                isSystem = true;
                pkOnly = false;
                otherwise = false;
            } else if (TOKEN3.equals(this.m_mode)) {
                isNull = true;
                isDefault = true;
                isSystem = true;
                pkOnly = false;
                otherwise = false;
            } else if (TOKEN4.equals(this.m_mode)) {
                isNull = true;
                isDefault = true;
                isSystem = true;
                pkOnly = true;
                otherwise = false;
            } else if (TOKEN5.equals(this.m_mode)) {
                isNull = false;
                isDefault = false;
                isSystem = false;
                pkOnly = false;
                otherwise = false;
            } else {
                throw new IllegalStateException("Unknown mode " + this.m_mode);
            }
            UniqueConstraint uk = null;
            if (context.getObject() instanceof Index) {
                index = (Index)context.getObject();
                Table table = index.getTable();
                if (table != null) {
                    for (Constraint c : table.getConstraints()) {
                        if (!(c instanceof UniqueConstraint)) continue;
                        UniqueConstraint con = (UniqueConstraint)c;
                        DBObjectID indexId = con.getIndexID();
                        if (index.getID() == null || !index.getID().equals(indexId)) continue;
                        uk = con;
                        break;
                    }
                }
            } else if (context.getObject() instanceof UniqueConstraint) {
                Table t;
                DBObject found;
                Index idx = null;
                uk = (UniqueConstraint)context.getObject();
                DBObjectID id = uk.getIndexID();
                if (id != null && uk.getParent() instanceof Table && (found = (t = (Table)uk.getParent()).findOwnedObject(id)) instanceof Index) {
                    idx = (Index)found;
                }
                index = idx;
            } else {
                return false;
            }
            Difference indexDiff = context.findUpdateDifference((DBObject)index);
            Difference ukDiff = context.findUpdateDifference((DBObject)uk);
            if (indexDiff != null && ukDiff == null) {
                uk = null;
            }
            if (TOKEN5.equals(this.m_mode)) {
                return uk != null && index != null && index.getIndexType() == Index.IndexType.UNIQUE && ConstraintIndexHelper.isSystemGenerated(index);
            }
            if (!pkOnly || uk.getClass() == PKConstraint.class) {
                if (index == null) {
                    return isNull;
                }
                if (uk != null) {
                    Table table = index.getTable();
                    if (uk.getClass() == PKConstraint.class && table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
                        return isDefault;
                    }
                    if (ConstraintIndexHelper.indexDefaultForConstraint(index, uk, context.getProvider())) {
                        return isDefault;
                    }
                    if (ConstraintIndexHelper.isSystemGenerated(index)) {
                        return isSystem;
                    }
                }
            }
            return otherwise;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("indexID");
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String type, DBObjectProvider pro) {
            return this.createPropertyMap(Collections.singleton("indexID"), null, null);
        }
    }

    private static final class IsFKInRefPartition
    extends TokenGenerator {
        public static final String TOKEN = "fkInRefPartition";

        private IsFKInRefPartition() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            boolean retval = false;
            Object obj = context.getObject();
            if (obj instanceof FKConstraint) {
                FKConstraint fk = (FKConstraint)obj;
                Relation rel = fk.getRelation();
                OracleTablePartitions otp = (OracleTablePartitions)rel.getProperty("OracleTablePartitions");
                DBObjectID refConId = null;
                if (otp != null && otp.getPartitionType() == OracleTablePartitions.PartitionType.REFERENCE && (refConId = otp.getReferenceConstraintID()) != null && refConId.equals(fk.getID())) {
                    retval = true;
                }
            }
            return retval;
        }
    }

    private static class PlSqlReferenceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "PlSqlReference";

        private PlSqlReferenceGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof PlSqlReference) {
                PlSqlReference ref = (PlSqlReference)context.getObject();
                DBObjectProvider pro = context.getProvider();
                try {
                    DBUtil.ensureDerivedPropertiesBuilt((DBObject)ref, (DBObjectProvider)pro);
                }
                catch (DBException e) {
                    DBLog.getLogger(OracleDDLSupport.class).warning("Failed to build derived props: " + e.getMessage());
                }
                Schema s = null;
                for (PlSqlReference o = ref; o != null; o = o.getParent()) {
                    if (!(o instanceof SchemaObject)) continue;
                    s = ((SchemaObject)o).getSchema();
                    break;
                }
                context.append((Object)DataTypeHelper.getTypeStringFromRef((PlSqlReference)ref, s, (DBObjectProvider)pro));
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }
    }

    private static class OldFileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "originalFilePath";

        private OldFileSpecPathGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof FileSpecification) {
                Difference diff = context.getDifference();
                FileSpecification file = (FileSpecification)diff.getOriginalObject();
                String separator = "/";
                if (file.getDirectory() != null && file.getDirectory().indexOf("\\") != -1) {
                    separator = "\\";
                }
                if (file.getDirectory() != null) {
                    context.append((Object)(file.getDirectory() + separator));
                }
                context.append((Object)file.getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "directory");
        }
    }

    private static class FileSpecPathGenerator
    extends TokenGenerator {
        public static final String TOKEN = "filePath";

        private FileSpecPathGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof FileSpecification) {
                FileSpecification file = (FileSpecification)context.getObject();
                String separator = "/";
                if (file.getDirectory() != null && file.getDirectory().indexOf("\\") != -1) {
                    separator = "\\";
                }
                if (ModelUtil.hasLength((String)file.getDirectory())) {
                    context.append((Object)(file.getDirectory() + separator));
                }
                context.append((Object)file.getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return null;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "directory");
        }
    }

    private static final class XMLSchemaTextTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schemaText";

        private XMLSchemaTextTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
            XMLSchema xs;
            if (context.getObject() instanceof XMLSchema && (xs = (XMLSchema)context.getObject()).getSource() != null && xs.getSource().length() > 0) {
                context.append((Object)xs.getSource().replaceAll("'", "''"));
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("source");
        }
    }

    private static final class NeedsTbspAlterForNewIPTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "needsTbspAlterForNewIP";

        private NeedsTbspAlterForNewIPTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            boolean retval = false;
            if (context.getObject() instanceof IndexPartition) {
                IndexPartition ip = (IndexPartition)context.getObject();
                OracleStorageProperties attributes = ip.getSegmentAttributes();
                retval = attributes != null && attributes.getTablespaceID() != null;
            }
            return retval;
        }
    }

    private static final class AddStorageToNewIPTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "addStorageToNewIP";

        private AddStorageToNewIPTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
            IndexPartition ip;
            String tokenValue;
            if (context.getObject() instanceof IndexPartition && ModelUtil.hasLength((String)(tokenValue = this.buildAlterStatement(ip = (IndexPartition)context.getObject())))) {
                context.append((Object)tokenValue);
            }
        }

        public Object evaluateToken(TokenContext context) {
            boolean eval = false;
            if (context.getObject() instanceof IndexPartition) {
                IndexPartition ip = (IndexPartition)context.getObject();
                String tokenValue = this.buildAlterStatement(ip);
                eval = ModelUtil.hasLength((String)tokenValue);
            }
            return eval;
        }

        private void addAlter(StringBuffer sb, String propertyName, Object propertyValue, Object defaultValue, boolean inStorageClause) {
            if (propertyValue != defaultValue) {
                if (inStorageClause) {
                    if (sb.indexOf("STORAGE") == -1) {
                        sb.append("\nSTORAGE\n(");
                    }
                    sb.append("\n  ");
                } else {
                    sb.append("\n");
                }
                sb.append(propertyName);
                sb.append(" ");
                sb.append(propertyValue);
            }
        }

        private String buildAlterStatement(IndexPartition ip) {
            OracleStorageProperties attributes = ip.getSegmentAttributes();
            Boolean keyCompress = ip.getUseKeyCompression();
            StringBuffer sb = new StringBuffer();
            if (attributes != null) {
                this.addAlter(sb, "INITRANS", attributes.getInitrans(), null, false);
                this.addAlter(sb, "PCTUSED", attributes.getPercentUsed(), null, false);
                this.addAlter(sb, "INITIAL", attributes.getInitialExtent(), null, true);
                this.addAlter(sb, "NEXT", attributes.getNextExtent(), null, true);
                this.addAlter(sb, "MINEXTENTS", attributes.getMinExtent(), null, true);
                this.addAlter(sb, "MAXEXTENTS", attributes.getMaxExtent(), null, true);
                this.addAlter(sb, "PCTINCREASE", attributes.getPercentIncrease(), null, true);
                this.addAlter(sb, "FREELISTS", attributes.getFreelists(), null, true);
                this.addAlter(sb, "FREELIST GROUPS", attributes.getFreelistGroups(), null, true);
                this.addAlter(sb, "BUFFER_POOL", attributes.getBufferMode(), null, true);
                if (sb.indexOf("STORAGE") != -1) {
                    sb.append("\n)");
                }
            }
            if (keyCompress != null) {
                if (keyCompress == Boolean.TRUE) {
                    sb.append("\nCOMPRESS");
                } else {
                    sb.append("\nNOCOMPRESS");
                }
            }
            return sb.toString();
        }
    }

    private static final class RenameNewIPIfChangedTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "renameNewIPIfChanged";

        private RenameNewIPIfChangedTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof IndexPartition) {
                IndexPartition ip = (IndexPartition)context.getObject();
                OracleIndexPartitions oip = (OracleIndexPartitions)ip.getParent();
                Index owningIndex = (Index)DBUtil.findParentOfType((DBObject)ip, Index.class);
                TablePartition tp = LocalIndexPartitionHelper.getBaseTablePartition(ip);
                if (tp != null && !ip.getName().equals(tp.getName())) {
                    StringBuffer sb = new StringBuffer("ALTER INDEX ");
                    Schema defSchema = context.getDefaultSchema();
                    Schema idxSchema = owningIndex.getSchema();
                    if (context.getOptions().isPrefixSchemaName() || defSchema != null && !DBUtil.areNamesAndTypesEqual((DBObject)defSchema, (DBObject)idxSchema)) {
                        sb.append(context.getExternalName(idxSchema.getName()));
                        sb.append(".");
                    }
                    sb.append(context.getExternalName(owningIndex.getName()));
                    sb.append(" \nRENAME");
                    sb.append(oip.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION ? " SUBPARTITION " : " PARTITION ");
                    sb.append(context.getExternalName(tp.getName()));
                    sb.append(" TO ");
                    sb.append(context.getExternalName(ip.getName()));
                    context.append((Object)sb.toString());
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }
    }

    private static final class DBLinkHostExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hostExists";

        private DBLinkHostExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof DatabaseLink) {
                DatabaseLink dblink = (DatabaseLink)context.getObject();
                String host = dblink.getHost();
                return host != null && !host.equals("");
            }
            return false;
        }
    }

    private static final class TrgNewAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refNewAsExists";

        private TrgNewAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String newAs = trg.getReferencingNewAs();
                return newAs != null && !newAs.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("referencingNewAs".toString());
        }
    }

    private static final class TrgOldAsExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refOldAsExists";

        private TrgOldAsExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String oldAs = trg.getReferencingOldAs();
                return oldAs != null && !oldAs.equals("");
            }
            return false;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("referencingOldAs".toString());
        }
    }

    private static final class DropAndRecreateConTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needDropAndRecreateConstraint";

        private DropAndRecreateConTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Constraint) {
                Difference rs = context.getDifference();
                PropertyFilter df = new PropertyFilter();
                df.addFilterProp("enabled");
                df.addFilterProp("indexID");
                df.addFilterProp("name");
                df.addFilterProp("indexID");
                Difference filtered = rs.getFilteredDifference(new DifferenceFilter[]{df});
                return !filtered.isSame();
            }
            return false;
        }
    }

    private static final class CodeExistsTokenGenerator
    extends TokenGenerator {
        public static final String TOKEN = "codeExists";

        private CodeExistsTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                String code = trg.getCode();
                return code != null && !code.equals("");
            }
            return false;
        }
    }

    private static final class SyntaxFromSourceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "getSyntaxFromSource";
        public static final String ALTER = "ALTER";

        private SyntaxFromSourceGenerator() {
        }

        public void generateToken(TokenContext context) {
            String source;
            if (context.getObject() instanceof PlSqlSourceObject && ModelUtil.hasLength((String)(source = this.getSource(context)))) {
                PlSqlSearch search;
                Trigger t;
                PlSqlSourceObject pls = (PlSqlSourceObject)context.getObject();
                String syntaxFromSource = null;
                try {
                    PlSqlToken start;
                    PlSqlParser parser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)pls, (DBObjectProvider)context.getProvider());
                    if (parser != null && (start = parser.getNameToken()) != null) {
                        start = (PlSqlToken)start.getNextToken();
                        int endOffset = parser.getEndOffsetOfObject();
                        PlSqlToken end = parser.getTokenAtOffset(endOffset);
                        syntaxFromSource = start.getSource(false, (Token)end);
                    }
                }
                catch (CancelledException ce) {
                    DBLog.getLogger((Object)((Object)this)).warning("Parsing cancelled while building ddl. " + ce.getMessage());
                    syntaxFromSource = null;
                }
                if (syntaxFromSource == null) {
                    PlSqlUtil.TypeAndNameInfo info = PlSqlUtil.getTypeAndNameFromSource(source, context.getProvider().getDescriptor());
                    syntaxFromSource = source.substring(info.getNameEnd() + 1);
                }
                if (syntaxFromSource.startsWith(" ")) {
                    syntaxFromSource = syntaxFromSource.substring(1);
                }
                if (context.getOptions().isPrefixSchemaName() && context.getObject() instanceof Trigger && ((t = (Trigger)context.getObject()).getBaseType() == Trigger.BaseType.TABLE || t.getBaseType() == Trigger.BaseType.VIEW) && (search = new PlSqlSearch("on <baseObj ?.>")).isWithin(syntaxFromSource)) {
                    PlSqlToken startTk = search.getNamedMatchStartToken("baseObj");
                    PlSqlToken endTk = search.getNamedMatchEndToken("baseObj");
                    if (startTk.getStart() == endTk.getStart()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(syntaxFromSource.substring(0, startTk.getStart()));
                        sb.append("\"");
                        sb.append(t.getSchema().getName());
                        sb.append("\".");
                        sb.append(syntaxFromSource.substring(startTk.getStart()));
                        syntaxFromSource = sb.toString();
                    }
                }
                context.append((Object)syntaxFromSource);
            }
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof PlSqlSourceObject) {
                String source = this.getSource(context);
                return source != null && !source.equals("");
            }
            return false;
        }

        private String getSource(TokenContext context) {
            String source = null;
            PlSqlSourceObject pls = (PlSqlSourceObject)context.getObject();
            source = pls.getSource();
            return source;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Collections.singleton("source");
        }
    }

    private static final class TriggerBaseObjectGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgBaseObject";

        private TriggerBaseObjectGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof Trigger) {
                Trigger trg = (Trigger)context.getObject();
                DBObjectProvider pro = context.getProvider();
                context.append((Object)"ON ");
                if (trg.getBaseType() == Trigger.BaseType.DATABASE) {
                    context.append((Object)"DATABASE");
                } else {
                    DBObjectID bid = trg.getBaseObjectID();
                    String baseName = DBUtil.getDBObjectName((DBObjectID)bid);
                    if (trg.getBaseType() == Trigger.BaseType.SCHEMA) {
                        context.append((Object)pro.getExternalName(baseName));
                        context.append((Object)".SCHEMA");
                    } else {
                        String baseSchemaName;
                        String contextSchemaName = null;
                        if (pro instanceof Database) {
                            try {
                                contextSchemaName = ((Database)pro).getUserName();
                            }
                            catch (DBException e) {
                                contextSchemaName = null;
                            }
                        }
                        if (contextSchemaName == null) {
                            contextSchemaName = trg.getSchema().getName();
                        }
                        if (ModelUtil.areDifferent((Object)contextSchemaName, (Object)(baseSchemaName = DBUtil.getSchemaName((DBObjectID)bid)))) {
                            context.append((Object)pro.getExternalName(baseSchemaName));
                            context.append((Object)".");
                        }
                        context.append((Object)pro.getExternalName(baseName));
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("baseObjectID");
        }
    }

    private static final class TriggerEventsListGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleTrgEvents";

        private TriggerEventsListGenerator() {
        }

        public void generateToken(TokenContext context) {
            Trigger trg;
            boolean isFirst = true;
            if (context.getObject() instanceof Trigger && (trg = (Trigger)context.getObject()).getEvents() != null && trg.getEvents().length > 0) {
                for (String event : trg.getEvents()) {
                    if (!isFirst) {
                        context.append((Object)" OR ");
                    }
                    context.append((Object)event);
                    DBObjectID[] colIDs = trg.getColumnIDs();
                    if ("UPDATE".equals(event) && colIDs != null) {
                        for (int i = 0; i < colIDs.length; ++i) {
                            context.append((Object)(i == 0 ? " OF " : ","));
                            context.append((Object)context.getProvider().getExternalName(DBUtil.getDBObjectName((DBObjectID)colIDs[i])));
                        }
                    }
                    isFirst = false;
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("events".toString(), "columnIDs".toString());
        }
    }

    private static final class MatViewLogAddWithsGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "handleAddWiths";
        private Collection<String> m_props = new TreeSet<String>();

        private MatViewLogAddWithsGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedViewLog) {
                HashSet<String> withVals = new HashSet<String>();
                StringBuffer colBuff = new StringBuffer();
                String newValues = null;
                if (this.propHasChangedToValue(context, "objectIdLogged".toString(), true)) {
                    withVals.add("OBJECT ID");
                }
                if (this.propHasChangedToValue(context, "primaryKeyLogged".toString(), true)) {
                    withVals.add("PRIMARY KEY");
                }
                if (this.propHasChangedToValue(context, "rowidLogged".toString(), true)) {
                    withVals.add("ROWID");
                }
                if (this.propHasChangedToValue(context, "sequenceLogged".toString(), true)) {
                    withVals.add("SEQUENCE");
                }
                if (this.propHasChangedToValue(context, "newValues".toString(), true)) {
                    newValues = " INCLUDING NEW VALUES";
                } else if (this.propHasChangedToValue(context, "newValues".toString(), false)) {
                    newValues = " EXCLUDING NEW VALUES";
                }
                if (!withVals.isEmpty() || colBuff.length() > 0 || newValues != null) {
                    boolean notFirst = false;
                    context.append((Object)"\nADD ");
                    for (String withStatement : withVals) {
                        if (notFirst) {
                            context.append((Object)", ");
                        }
                        context.append((Object)withStatement);
                        notFirst = true;
                    }
                    context.append((Object)colBuff);
                    if (newValues != null) {
                        context.append((Object)newValues);
                    }
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.createPropertyMap(this.m_props, null, null);
        }
    }

    private static final class MatViewLogWithsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "handleWiths";
        private Collection<String> m_props = null;

        private MatViewLogWithsGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedViewLog) {
                boolean notFirst;
                DBObjectID[] colIDs;
                MaterializedViewLog mvl = (MaterializedViewLog)context.getObject();
                HashSet<String> withVals = new HashSet<String>();
                StringBuffer colBuff = new StringBuffer();
                if (Boolean.TRUE.equals(mvl.getObjectIdLogged())) {
                    withVals.add("OBJECT ID");
                }
                if (Boolean.TRUE.equals(mvl.getPrimaryKeyLogged())) {
                    withVals.add("PRIMARY KEY");
                }
                if (Boolean.TRUE.equals(mvl.getRowidLogged())) {
                    withVals.add("ROWID");
                }
                if (Boolean.TRUE.equals(mvl.getSequenceLogged())) {
                    withVals.add("SEQUENCE");
                }
                if ((colIDs = mvl.getColumnIDs()) != null && colIDs.length > 0) {
                    colBuff.append("(");
                    notFirst = false;
                    for (int i = 0; i < colIDs.length; ++i) {
                        DBObjectID id = colIDs[i];
                        String objName = DBUtil.getDBObjectName((DBObjectID)id);
                        if (notFirst) {
                            colBuff.append(", ");
                        }
                        colBuff.append(objName);
                        notFirst = true;
                    }
                    colBuff.append(")");
                }
                if (!withVals.isEmpty() || colBuff.length() > 0) {
                    notFirst = false;
                    context.append((Object)"\nWITH ");
                    for (String withStatement : withVals) {
                        if (notFirst) {
                            context.append((Object)", ");
                        }
                        context.append((Object)withStatement);
                        notFirst = true;
                    }
                    context.append((Object)colBuff);
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet<String>();
                this.m_props.add("objectIdLogged".toString());
                this.m_props.add("primaryKeyLogged".toString());
                this.m_props.add("rowidLogged".toString());
                this.m_props.add("sequenceLogged".toString());
                this.m_props.add("columnIDs".toString());
                this.m_props.add("newValues".toString());
            }
            return this.m_props;
        }
    }

    private static final class PartitionValuesChangedTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "changedValues";

        private PartitionValuesChangedTokenGenerator() {
        }

        private boolean valuesHaveChanged(TokenContext context) {
            PropertyHelper ph = new PropertyHelper();
            Difference rs = context.getDifference();
            Object newVal = ph.getPropertyValue(context.getObject(), "values");
            Object oldVal = ph.getPropertyValue(rs.getOriginalObject(), "values");
            if (newVal != null && oldVal != null) {
                return !newVal.equals(oldVal);
            }
            return oldVal == null && newVal != null || oldVal != null && newVal == null;
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.valuesHaveChanged(context);
        }
    }

    private static final class PasswordGenerator
    extends TokenGenerator {
        public static final String TOKEN = "password";
        public static final String TOKEN2 = "authentificationPassword";
        private final String m_key;

        public PasswordGenerator(String key) {
            this.m_key = key;
        }

        public void generateToken(TokenContext context) {
            String password;
            String username;
            DatabaseLink link = (DatabaseLink)context.getObject();
            if (TOKEN.equals(this.m_key)) {
                username = link.getUsername();
                password = link.getPassword();
            } else {
                username = link.getAuthentificationUsername();
                password = link.getAuthentificationPassword();
            }
            if (ModelUtil.hasLength((String)password)) {
                context.append((Object)password);
            } else if (context.getProvider() instanceof Database) {
                context.append((Object)"\"***\"");
            } else {
                StringBuilder sb = new StringBuilder("&");
                if (username != null) {
                    sb.append(username);
                    sb.append("_");
                }
                sb.append("PASSWORD");
                context.append((Object)sb.toString().toUpperCase().replace(" ", "_"));
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList(TOKEN, TOKEN2);
        }
    }

    private static final class RefreshDateExpressionsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "refreshDateExpressions";

        private RefreshDateExpressionsGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedView) {
                MaterializedView mv = (MaterializedView)context.getObject();
                StringBuilder sb = new StringBuilder();
                if (ModelUtil.hasLength((String)mv.getFirstRefresh())) {
                    sb.append("START WITH ");
                    sb.append(mv.getFirstRefresh());
                    sb.append(" ");
                }
                if (ModelUtil.hasLength((String)mv.getInterval())) {
                    sb.append("NEXT ");
                    sb.append(mv.getInterval());
                    sb.append(" ");
                }
                context.append((Object)sb.toString());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("firstRefresh", "interval", "lastRefreshDate", "lastRefreshType", "nextRefreshDate", "staleness");
        }
    }

    private static final class MVConstraintsNeedsUsingTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "mvConstraintsNeedsUsing";

        private MVConstraintsNeedsUsingTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof MaterializedView) {
                boolean create;
                MaterializedView mv = (MaterializedView)context.getObject();
                boolean bl = create = context.getDifference() == null || context.getDifference().getOriginalObject() == null;
                if (create && (mv.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.LOCAL || mv.getRollbackSegmentType() == MaterializedView.RollbackSegmentType.MASTER)) {
                    return false;
                }
                if (!create && (this.propHasChanged(context, "rollbackSegmentType") || this.propHasChanged(context, "rollbackSegmentName"))) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private static final class NeedsRebuildIndexesModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needsRebuildIndexes";

        private NeedsRebuildIndexesModTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "logging"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "initrans"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"segmentAttributes", "bufferMode"})) || this.propHasChanged(context, "percentFree") || this.propHasChanged(context, "percentUsed") || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}));
        }
    }

    private static final class NeedIndexPartitionModTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needIPMod";

        private NeedIndexPartitionModTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return this.propHasChanged(context, "segmentAttributes/logging") || this.propHasChanged(context, "segmentAttributes/initrans") || this.propHasChanged(context, "segmentAttributes/initialExtent") || this.propHasChanged(context, "segmentAttributes/nextExtent") || this.propHasChanged(context, "segmentAttributes/minExtent") || this.propHasChanged(context, "segmentAttributes/maxExtent") || this.propHasChanged(context, "segmentAttributes/percentIncrease") || this.propHasChanged(context, "segmentAttributes/freelists") || this.propHasChanged(context, "useKeyCompression") || this.propHasChanged(context, "segmentAttributes/freelistGroups");
        }
    }

    private static final class NeedOSPMoveTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPMove";
        private TreeSet<String> m_props;

        private NeedOSPMoveTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            boolean needsMove;
            boolean bl = needsMove = this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "tablespaceID"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "initialExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "nextExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "maxExtent"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "percentIncrease"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "freelists"})) || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "freelistGroups"}));
            if (context.getObject() instanceof Table) {
                PropertyHelper ph = new PropertyHelper();
                Object tableType = ph.getPropertyValue(context.getObject(), "TableType");
                return needsMove || this.propHasChanged(context, Property.createPath((String[])new String[]{"OracleStorageProperties", "percentFree"})) && tableType.toString().equals(Table.TableType.INDEX_ORGANIZED);
            }
            return needsMove;
        }

        public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String type, DBObjectProvider pro) {
            if (this.m_props == null) {
                this.m_props = new TreeSet();
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "initialExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "nextExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "maxExtent"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "percentIncrease"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "freelists"}));
                this.m_props.add(Property.createPath((String[])new String[]{"OracleStorageProperties", "freelistGroups"}));
            }
            return this.createPropertyMap(this.m_props, null, null);
        }
    }

    private static final class NeedOSPAlterTokenGenerator
    extends AlterTokenGenerator {
        public static final String TOKEN = "needOSPAlter";

        private NeedOSPAlterTokenGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Table) {
                PropertyHelper ph = new PropertyHelper();
                Object tableType = ph.getPropertyValue(context.getObject(), "TableType");
                return this.propHasChanged(context, "OracleStorageProperties/logging") || this.propHasChanged(context, "OracleStorageProperties/percentUsed") || this.propHasChanged(context, "OracleStorageProperties/initrans") || this.propHasChanged(context, "OracleStorageProperties/maxtrans") || this.propHasChanged(context, "OracleStorageProperties/bufferMode") || this.propHasChanged(context, "OracleStorageProperties/percentFree") && !tableType.toString().equals("INDEX_ORGANIZED");
            }
            if (context.getObject() instanceof Index && ((Index)context.getObject()).getIndexType() != Index.IndexType.DOMAIN) {
                return this.propHasChanged(context, "OracleStorageProperties/logging") || this.propHasChanged(context, "OracleStorageProperties/percentUsed") || this.propHasChanged(context, "OracleStorageProperties/initrans") || this.propHasChanged(context, "OracleStorageProperties/maxtrans") || this.propHasChanged(context, "OracleStorageProperties/bufferMode") || this.propHasChanged(context, "OracleStorageProperties/percentFree");
            }
            return false;
        }
    }

    private static final class HasPartitionsGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hasPartitions";

        private HasPartitionsGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof Table) {
                OracleTablePartitions otp = (OracleTablePartitions)((Table)context.getObject()).getProperty("OracleTablePartitions");
                return otp != null && otp.getPartitions().length > 0;
            }
            return false;
        }
    }

    private static final class HasTablespacesGenerator
    extends TokenGenerator {
        public static final String TOKEN = "hastablespaces";

        private HasTablespacesGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            if (context.getObject() instanceof OracleTablePartitions) {
                OracleTablePartitions otp = (OracleTablePartitions)context.getObject();
                return otp != null && otp.getHashQuantityTablespaceIds().length > 0;
            }
            return false;
        }
    }

    private static final class IsLOBColumnGenerator
    extends TokenGenerator {
        public static final String TOKEN = "islobcol";

        private IsLOBColumnGenerator() {
        }

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            boolean retval = false;
            Object obj = context.getObject();
            if (obj instanceof LOBDescriptor) {
                DBObjectID[] cols;
                for (DBObjectID colID : cols = ((LOBDescriptor)obj).getColumns()) {
                    if (!LOBDescriptor.isLOBColumn((DBObjectID)colID, (DBObject)((LOBDescriptor)obj))) continue;
                    retval = true;
                }
            }
            return retval;
        }
    }

    private static final class PartitionAlterMoveLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "altermovelobcoldef";

        private PartitionAlterMoveLOBGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof LOBDescriptor) {
                DBObjectID[] cols;
                LOBDescriptor lob = (LOBDescriptor)context.getObject();
                for (DBObjectID colID : cols = lob.getColumns()) {
                    this.addLOBDefinition(context, null, !LOBDescriptor.isLOBColumn((DBObjectID)colID, (DBObject)lob), false, DBUtil.getDBObjectName((DBObjectID)colID));
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            LOBDescriptor lob = (LOBDescriptor)context.getObject();
            DBObjectID[] cols = lob.getColumns();
            return cols != null && cols.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("columns");
        }
    }

    private static final class PartitionAlterLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "alterlobcoldef";

        private PartitionAlterLOBGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof LOBDescriptor) {
                DBObjectID[] cols;
                LOBDescriptor lob = (LOBDescriptor)context.getObject();
                for (DBObjectID colID : cols = lob.getColumns()) {
                    this.alterLOBDefinition(context, DBUtil.getDBObjectName((DBObjectID)colID), null, !LOBDescriptor.isLOBColumn((DBObjectID)colID, (DBObject)lob), false);
                }
            }
        }

        public Object evaluateToken(TokenContext context) {
            LOBDescriptor lob = (LOBDescriptor)context.getObject();
            DBObjectID[] cols = lob.getColumns();
            return cols != null && cols.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("columns");
        }
    }

    private static final class PartitionLOBGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobcoldef";

        private PartitionLOBGenerator() {
        }

        public void generateToken(TokenContext context) {
            if (context.getObject() instanceof LOBDescriptor) {
                LOBDescriptor lob = (LOBDescriptor)context.getObject();
                DBObjectID[] cols = lob.getColumns();
                boolean useVarraySyntax = false;
                String[] colNames = new String[cols.length];
                for (int i = 0; i < cols.length; ++i) {
                    colNames[i] = DBUtil.getDBObjectName((DBObjectID)cols[i]);
                    if (useVarraySyntax || LOBDescriptor.isLOBColumn((DBObjectID)cols[i], (DBObject)lob)) continue;
                    useVarraySyntax = true;
                }
                this.addLOBDefinition(context, lob.getLOBSegName(), useVarraySyntax, true, colNames);
            }
        }

        public Object evaluateToken(TokenContext context) {
            LOBDescriptor lob = (LOBDescriptor)context.getObject();
            DBObjectID[] cols = lob.getColumns();
            return cols != null && cols.length > 0;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("LOBSegName", "columns");
        }
    }

    private static final class LOBDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "lobdef";

        private LOBDefinitionGenerator() {
        }

        public void generateToken(TokenContext context) {
            OracleColumnProperties ocp;
            LOBDescriptor lob;
            DBObjectID[] cols;
            if (context.getObject() instanceof OracleColumnProperties && ((cols = (lob = (ocp = (OracleColumnProperties)context.getObject()).getLOBProperties()).getColumns()) == null || cols.length == 0)) {
                this.addLOBDefinition(context, lob.getLOBSegName(), false, false, ocp.getParent().getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("LOBProperties".toString());
        }
    }

    private static final class VarrayDefinitionGenerator
    extends LOBTokenGenerator {
        public static final String TOKEN = "varraydef";

        private VarrayDefinitionGenerator() {
        }

        public void generateToken(TokenContext context) {
            OracleColumnProperties ocp;
            LOBDescriptor lob;
            DBObjectID[] cols;
            if (context.getObject() instanceof OracleColumnProperties && ((cols = (lob = (ocp = (OracleColumnProperties)context.getObject()).getVAProperties()).getColumns()) == null || cols.length == 0)) {
                this.addLOBDefinition(context, lob.getLOBSegName(), true, false, ocp.getParent().getName());
            }
        }

        public Object evaluateToken(TokenContext context) {
            return true;
        }

        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("VAProperties".toString());
        }
    }

    private static abstract class AlterTokenGenerator
    extends TokenGenerator {
        private AlterTokenGenerator() {
        }

        protected boolean propHasChanged(TokenContext context, String propPath) {
            Difference propDiff = null;
            try {
                PropertyHelper ph = new PropertyHelper();
                Difference rs = context.getDifference();
                if (rs == null) {
                    return false;
                }
                propDiff = ph.getChildDifference(rs, propPath, true);
            }
            catch (MissingPropertyException e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.FINER, e.getMessage());
            }
            return propDiff != null;
        }

        protected boolean propHasChangedToValue(TokenContext context, String propPath, Object value) {
            PropertyHelper ph = new PropertyHelper();
            Difference rs = context.getDifference();
            Object newVal = ph.getPropertyValue(rs.getUpdatedObject(), propPath);
            return this.propHasChanged(context, propPath) && newVal.equals(value);
        }
    }

    private static abstract class LOBTokenGenerator
    extends TokenGenerator {
        private LOBTokenGenerator() {
        }

        void addLOBDefinition(TokenContext context, String segName, boolean isVarray, boolean addIncr, String ... colNames) {
            if (isVarray) {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"VARRAY ");
            } else {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"LOB (");
            }
            boolean first = true;
            for (String colName : colNames) {
                if (!first) {
                    context.append((Object)", ");
                }
                first = false;
                context.append((Object)context.getExternalName(colName));
            }
            if (!isVarray) {
                context.append((Object)")");
            }
            context.append((Object)" STORE AS ");
            if (isVarray) {
                context.append((Object)"LOB ");
            }
            if (segName != null) {
                context.append((Object)context.getExternalName(segName));
            }
        }

        void alterLOBDefinition(TokenContext context, String colName, String segName, boolean isVarray, boolean addIncr) {
            if (isVarray) {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"VARRAY ");
            } else {
                context.append((Object)"\n");
                if (addIncr) {
                    context.append((Object)"  ");
                }
                context.append((Object)"LOB (");
            }
            context.append((Object)context.getExternalName(colName));
            if (!isVarray) {
                context.append((Object)")");
            } else {
                context.append((Object)" STORE AS LOB ");
            }
        }
    }
}

