/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterBuilder;
import oracle.javatools.db.ora.bigdata.BigDataField;
import oracle.javatools.db.ora.bigdata.BigDataFields;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class BigDataFieldsBuilder
extends BigDataAccessParameterBuilder.ValueBuilder {
    private static final String COMMENT = "COMMENT";

    @Override
    public void buildFragment(BigDataAccessParameter param) throws DBException {
        String value = this.stripAndTrimParentheses(param.getParameterValue());
        if (ModelUtil.hasLength((String)value)) {
            int length = value.length();
            ArrayList<BigDataField> fields = new ArrayList<BigDataField>();
            String[] bits = new String[3];
            int bitIndex = 0;
            StringBuilder bit = new StringBuilder();
            boolean foundComment = false;
            for (int i = 0; i < length; ++i) {
                Integer bitIndexToFinish = null;
                boolean finishField = false;
                char c = value.charAt(i);
                if (c == ',') {
                    finishField = true;
                    bitIndexToFinish = bitIndex;
                } else if (Character.isWhitespace(c)) {
                    if (bit.length() > 0) {
                        bitIndexToFinish = bitIndex;
                        ++bitIndex;
                    }
                } else if (c == '<') {
                    int nest = 0;
                    int end = -1;
                    for (int i2 = i + 1; i2 < length; ++i2) {
                        char c2 = value.charAt(i2);
                        if (c2 == '>') {
                            if (nest-- > 0) continue;
                            end = i2;
                            break;
                        }
                        if (c2 != '<') continue;
                        ++nest;
                    }
                    if (end <= 0) {
                        throw new DBException((DBObject)param, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_UNMATCHED", (Object[])new Object[]{Character.valueOf('<')}));
                    }
                    bit.append(value.substring(i, end + 1));
                    i = end;
                } else if (c == '\"') {
                    int end = this.findMatchingDoubleQuote(param, value, i);
                    bit.append(value.substring(i, end + 1));
                    i = end;
                } else if (c == '\'') {
                    int end = this.findMatchingSingleQuote(param, value, i);
                    bit.append(value.substring(i, end + 1));
                    i = end;
                } else if ((c == 'c' || c == 'C') && (i <= 0 || Character.isWhitespace(value.charAt(i - 1))) && value.regionMatches(true, i, COMMENT, 0, 7)) {
                    if (bitIndex == 0) {
                        throw new DBException((DBObject)param, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_EXPECTED_NAME", (Object[])new Object[]{COMMENT}));
                    }
                    i += 7;
                    bitIndex = 2;
                    foundComment = true;
                } else {
                    bit.append(c);
                }
                if (i == length - 1) {
                    bitIndexToFinish = bitIndex;
                    finishField = true;
                }
                if (bitIndexToFinish != null) {
                    if (bit.length() > 0) {
                        if (bitIndexToFinish > 2 || bitIndexToFinish == 2 && !foundComment) {
                            throw new DBException((DBObject)param, APIBundle.format((String)"EXTERNAL_TABLE_BD_FIELDS_EXPECTED_OTHER", (Object[])new Object[]{bit.toString(), "," + (foundComment ? "" : " COMMENT")}));
                        }
                        bits[bitIndexToFinish.intValue()] = bit.toString();
                    }
                    bit = new StringBuilder();
                }
                if (!finishField) continue;
                BigDataField field = new BigDataField();
                field.setName(bits[0]);
                field.setFieldDataType(bits[1]);
                field.setProperty("Comment", (Object)bits[2]);
                fields.add(field);
                bits = new String[3];
                bitIndex = 0;
                foundComment = false;
            }
            if (!fields.isEmpty()) {
                BigDataFields frag = new BigDataFields();
                frag.setBigDataFields(fields.toArray(new BigDataField[fields.size()]));
                param.setParameterValueFragment((SQLFragment)frag);
            }
        }
    }
}

