/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;

public class OracleSynonymBuilder
extends OracleDBObjectBuilder<Synonym> {
    OracleSynonymBuilder(BaseOracleDatabase db) {
        super(db, "SYNONYM");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public Synonym createObject(String name, Schema schema, DBObjectID id) {
        Synonym syn = (Synonym)super.createObject(name, schema, id);
        syn.setPublic(this.getDatabase().isPublicSchema(schema));
        return syn;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"reference"})
    public void fillInObject(final Synonym synonym) throws DBException {
        if (synonym.getSchema() != null) {
            synonym.setPublic(this.getDatabase().isPublicSchema(synonym.getSchema()));
        }
        final QueryWrapper wrap = this.getQueryWrapper(synonym);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String refSchemaName = rs.getString(1);
                        String refObjectName = rs.getString(2);
                        String refDatabaseLink = rs.getString(3);
                        String refIDType = rs.getString(4);
                        String refObjectType = null;
                        BigDecimal refObjectID = null;
                        if (refIDType != null) {
                            int i = refIDType.indexOf(95);
                            if (i > 0) {
                                try {
                                    refObjectID = new BigDecimal(refIDType.substring(0, i));
                                    if (BigDecimal.ZERO.equals(refObjectID)) {
                                        refObjectID = null;
                                    }
                                    refObjectType = refIDType.substring(i + 1);
                                }
                                catch (NumberFormatException nfe) {
                                    OracleSynonymBuilder.this.getLogger().severe(nfe.getMessage());
                                }
                            } else {
                                OracleSynonymBuilder.this.getLogger().severe("Invalid ref details: " + refIDType);
                            }
                        }
                        OracleSynonymBuilder.this.populateSynonym(synonym, refSchemaName, refObjectName, refDatabaseLink, refObjectType, refObjectID);
                    }
                }
                catch (SQLException sqe) {
                    wrap.throwDBException((DBObject)synonym, sqe);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private void populateSynonym(Synonym synonym, String refSchemaName, String refObjectName, String refDatabaseLink, String refObjectType, Object refobjectID) throws DBException {
        ReferenceID refID;
        Schema refSchema;
        BaseOracleDatabase db = this.getDatabase();
        Schema schema = refSchemaName == null ? null : (refSchema = refDatabaseLink == null ? this.getSchema(refSchemaName) : new Schema(refSchemaName));
        if (refobjectID == null) {
            refID = new ReferenceID("UNSPECIFIED_TYPE", refSchema, refObjectName, refDatabaseLink);
            refID.setProvider((DBObjectProvider)db);
        } else {
            refID = db.createID(null, refSchema, refObjectName, refObjectType, refobjectID);
        }
        synonym.setReference((DBObjectID)refID);
    }

    private QueryWrapper getQueryWrapper(Synonym synonym) {
        if (this.getDatabase() instanceof OracleLite) {
            return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_OLITE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK, '0_TABLE'  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION ALL\n SELECT S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK, '0_VIEW'  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME", synonym.getSchema(), synonym, synonym.getSchema(), synonym);
        }
        return this.getDatabase().newQueryWrapper((SystemObject)synonym, "SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_QUERY*/\n    S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK,\n    DECODE( S.DB_LINK, NULL, ( SELECT OBJECT_ID || '_' || OBJECT_TYPE \n       FROM SYS.ALL_OBJECTS REF \n       WHERE REF.OWNER = S.TABLE_OWNER \n         AND REF.OBJECT_NAME = S.TABLE_NAME \n         AND OBJECT_TYPE NOT LIKE '% BODY' ), NULL) REF_ID_TYPE \n FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ", synonym.getSchema(), synonym);
    }
}

