/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.db.marshal.SingleElementHandler;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DBObjectXMLHandler
extends DBObjectHandler {
    private String m_namespace;

    public DBObjectXMLHandler(String namespace) {
        this.m_namespace = namespace;
    }

    public final String getNamespace() {
        return this.m_namespace;
    }

    public boolean canRead(Reader reader, DBObjectProvider pro) throws IOException {
        SingleElementHandler handler = new SingleElementHandler(null);
        DBObjectXMLHandler.read(reader, handler, true);
        return ModelUtil.areEqual((Object)this.getNamespace(), (Object)handler.getNamespace());
    }

    protected static final void read(Reader reader, DefaultHandler helper, boolean allowPartialParse) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(DBObjectXMLHandler.class.getClassLoader());
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            SAXParser parser = f.newSAXParser();
            parser.parse(new InputSource(reader), helper);
        }
        catch (PartialParseCompleteException e) {
            if (!allowPartialParse) {
                throw new IllegalStateException("parser quit after name and id but we didn't request that.");
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error parsing file: " + e.getMessage());
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Error parsing file: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            thread.setContextClassLoader(contextClassLoader);
        }
    }
}

