/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;

public abstract class DMDBuilder<T extends AbstractBuildableObject>
extends AbstractDBObjectBuilder<T> {
    private String m_catalog;

    protected DMDBuilder(JdbcDatabase db, String catalog, String type) {
        super((AbstractDBObjectProvider)db, type);
        this.m_catalog = catalog;
    }

    public JdbcDatabase getDatabase() {
        return (JdbcDatabase)this.getProvider();
    }

    public Connection getConnection() {
        return this.getDatabase().getConnection();
    }

    public boolean isUseSchema() {
        return this.getDatabase().isUseSchema();
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    protected String[] getCatalogAndSchema(Schema schema) {
        String schemaName;
        String cat;
        if (schema != null) {
            try {
                schema = this.getDatabase().getSchema(schema.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        String string = cat = schema == null ? null : (String)schema.getProperty("DMD_CATALOG_NAME");
        if (cat == null) {
            cat = this.getCatalog();
        }
        String string2 = schemaName = schema == null ? null : (String)schema.getProperty("DMD_SCHEMA_NAME");
        if (schemaName == null && this.isUseSchema()) {
            String string3 = schemaName = schema != null ? schema.getName() : null;
        }
        if ("<null>".equals(schemaName)) {
            schemaName = null;
        }
        return new String[]{cat, this.getNameForDriver(schemaName)};
    }

    protected String getNameForDriver(String name) {
        return this.getDatabase().getNameForDriver(name);
    }

    protected final void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void checkUnsupportedOperation(DBObject obj, SQLException sqe) throws DBException {
        if (!((AbstractDatabase)this.getProvider()).isUnsupportedOperation(sqe)) {
            throw new DBException(obj, (Throwable)sqe);
        }
    }
}

