/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartition;
import oracle.javatools.db.hive.HivePartitionProperties;
import oracle.javatools.db.hive.HivePartitionsBuilder;
import oracle.javatools.db.hive.HiveSkewProperties;
import oracle.javatools.db.hive.HiveStorageProperties;
import oracle.javatools.db.hive.TblProperty;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public class HiveTableBuilder
extends AbstractDBObjectBuilder<Table> {
    private static final String DEFAULT_COMMENT = "None";
    private static final String TABLE_TYPE_PROP = "Table Type:";
    private static final String TABLE_TYPE_EXTERNAL = "EXTERNAL_TABLE";
    private static final String INPUTFORMAT_PROP = "InputFormat:";
    private static final String OUTPUTFORMAT_PROP = "OutputFormat:";
    private static final String SERDE_PROP = "SerDe Library:";
    private static final String LOCATION_PROP = "Location:";
    private static final String NUM_BUCKETS_PROP = "Num Buckets:";
    private static final String BUCKET_COLS_PROP = "Bucket Columns:";
    private static final String BUCKET_SORT_COLS_PROP = "Sort Columns:";
    private static final String SKEW_COLS_PROP = "Skewed Columns:";
    private static final String SKEW_VALS_PROP = "Skewed Values:";
    private static final String SKEW_STORED_AS_DIRS = "Stored As SubDirectories:";
    private static final String YES = "Yes";
    private static final String TBLPROPERTIES_PROP = "Table Parameters:";
    private static final String PARTPROPS_PROP = "Partition Parameters:";
    private static final String TBLPROP_COMMENT = "comment";
    private static final String TBLPROP_STORAGE_HANDLER = "storage_handler";
    private static final String SERDEPROPERTIES_PROP = "Storage Desc Params:";
    static final Map<String, String> s_propertyMap;
    private static final Collection<String> s_mapHeaders;
    private static Pattern s_orderPattern;

    public HiveTableBuilder(HiveDatabaseImpl db) {
        super((AbstractDBObjectProvider)db, "TABLE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columns", "TableType", "Comment", "HivePartitionProperties", "HiveBucketProperties", "HiveStorageProperties", "HiveSkewProperties", "TBLPROPERTIES"})
    public void buildUsingDescribe(Table tab) throws DBException {
        Map<String, String> serdeMap;
        Map<String, String> tblprops;
        HiveDatabaseImpl db = (HiveDatabaseImpl)this.getProvider();
        DescribeBuilder describe = new DescribeBuilder(db);
        describe.describe("describe formatted " + DBUtil.getFullyQualifiedName((DBObject)tab, (boolean)true), tab);
        Map<String, Column> colMap = describe.getColumnMap();
        Map<String, String> metadata = describe.getMetadata();
        tab.setColumns(colMap.values().toArray(new Column[colMap.size()]));
        Table.TableType ttype = TABLE_TYPE_EXTERNAL.equals(metadata.get(TABLE_TYPE_PROP)) ? Table.TableType.EXTERNAL : Table.TableType.NORMAL;
        tab.setProperty("TableType", (Object)ttype);
        HiveStorageProperties htp = new HiveStorageProperties();
        tab.setProperty("HiveStorageProperties", (Object)htp);
        describe.extractProperties(s_propertyMap, (DBObject)htp);
        HiveBucketProperties hbp = new HiveBucketProperties();
        if (describe.extractColumnList(BUCKET_COLS_PROP, (DBObject)hbp, "bucketColumns")) {
            describe.extractInteger(NUM_BUCKETS_PROP, (DBObject)hbp, "numberOfBuckets", false);
            describe.extractSortColList(BUCKET_SORT_COLS_PROP, (DBObject)hbp, "bucketSortColumns");
            tab.setProperty("HiveBucketProperties", (Object)hbp);
        }
        describe.extractSkew((DBObject)tab);
        List<DBObjectID> partedCols = describe.getPartitionColumns();
        if (!partedCols.isEmpty()) {
            HivePartitionProperties parts = new HivePartitionProperties();
            parts.setPartitionColumns(partedCols.toArray(new DBObjectID[partedCols.size()]));
            db.setHiveBuilder(parts, new HivePartitionsBuilder(db));
            tab.setProperty("HivePartitionProperties", (Object)parts);
        }
        if ((tblprops = describe.getPropertyMap(TBLPROPERTIES_PROP)) != null) {
            String handler;
            String comment = tblprops.remove(TBLPROP_COMMENT);
            if (ModelUtil.hasLength((String)comment)) {
                tab.setProperty("Comment", (Object)comment);
                HiveTableBuilder.fixComment((DBObject)tab);
            }
            if (ModelUtil.hasLength((String)(handler = tblprops.get(TBLPROP_STORAGE_HANDLER)))) {
                htp.setStorageHandlerClass(handler);
            }
            tab.setProperty("TBLPROPERTIES", (Object)describe.createPropertiesModel(tblprops));
        }
        if ((serdeMap = describe.getPropertyMap(SERDEPROPERTIES_PROP)) != null) {
            htp.setSerDeProperties(describe.createPropertiesModel(serdeMap));
        }
    }

    private boolean hasProperty(DBObject obj, String ... props) {
        boolean retval = false;
        for (String prop : props) {
            if (obj.getProperty(prop) == null) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private static void fixComment(DBObject obj) {
        String NOT_NEWLINE = "\\n";
        String comment = (String)obj.getProperty("Comment");
        if (comment != null && comment.contains("\\n")) {
            comment = comment.replace("\\n", "\n");
            obj.setProperty("Comment", (Object)comment);
        }
    }

    static {
        s_mapHeaders = Arrays.asList(TBLPROPERTIES_PROP, SERDEPROPERTIES_PROP, PARTPROPS_PROP);
        s_propertyMap = new HashMap<String, String>();
        s_propertyMap.put(LOCATION_PROP, "hdfsLocation");
        s_propertyMap.put(INPUTFORMAT_PROP, "inputFormatClass");
        s_propertyMap.put(OUTPUTFORMAT_PROP, "outputFormatClass");
        s_propertyMap.put(SERDE_PROP, "serDeClass");
    }

    static class DescribeBuilder {
        private final HiveDatabaseImpl m_db;
        private final Map<String, Column> m_colMap = new LinkedHashMap<String, Column>();
        private final List<DBObjectID> m_partedCols = new ArrayList<DBObjectID>();
        private final Map<String, String> m_metadata = new HashMap<String, String>();
        private final Map<String, Map<String, String>> m_propertyMaps = new HashMap<String, Map<String, String>>();

        DescribeBuilder(HiveDatabaseImpl db) {
            this.m_db = db;
        }

        private Logger getLogger() {
            return DBLog.getLogger((Object)this);
        }

        Map<String, Column> getColumnMap() {
            return this.m_colMap;
        }

        List<DBObjectID> getPartitionColumns() {
            return this.m_partedCols;
        }

        Map<String, String> getPropertyMap(String header) {
            return this.m_propertyMaps.get(header);
        }

        Map<String, String> getMetadata() {
            return this.m_metadata;
        }

        public void describe(String describeQuery, final Table tab) throws DBException {
            final ArrayList colList = new ArrayList();
            QueryWrapper wrap = new QueryWrapper((Database)this.m_db, describeQuery);
            wrap.executeQuery(new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException, SQLException {
                    Boolean colsDone = null;
                    boolean partCols = false;
                    String currentHeader = null;
                    while (rs.next()) {
                        String col3;
                        String name = this.getTrimmedString(rs, 1);
                        if (name != null && name.equals("# col_name")) {
                            if (Boolean.TRUE.equals(colsDone)) {
                                partCols = true;
                            }
                            colsDone = false;
                            continue;
                        }
                        if (colsDone == null) continue;
                        if (ModelUtil.hasLength((String)name)) {
                            if (name.startsWith("# ")) {
                                colsDone = true;
                                currentHeader = null;
                                continue;
                            }
                            if (colsDone.booleanValue()) {
                                if (s_mapHeaders.contains(name)) {
                                    currentHeader = name;
                                    continue;
                                }
                                m_metadata.put(name, this.getTrimmedString(rs, 2));
                                continue;
                            }
                            Column col = new Column(name);
                            col.setID((DBObjectID)new NameBasedID("COLUMN", name, tab.getID()));
                            String dtuString = this.getTrimmedString(rs, 2);
                            colList.add(new Tuple((Object)col, (Object)dtuString));
                            String comment = rs.getString(3);
                            if (!rs.wasNull() && ModelUtil.hasLength((String)comment) && !HiveTableBuilder.DEFAULT_COMMENT.equals(comment)) {
                                col.setProperty("Comment", (Object)comment);
                            }
                            if (!partCols) continue;
                            m_partedCols.add(col.getID());
                            continue;
                        }
                        if (currentHeader != null) {
                            String col2 = this.getTrimmedString(rs, 2);
                            if (!ModelUtil.hasLength((String)col2)) continue;
                            LinkedHashMap<String, String> m = (LinkedHashMap<String, String>)m_propertyMaps.get(currentHeader);
                            if (m == null) {
                                m = new LinkedHashMap<String, String>();
                                m_propertyMaps.put(currentHeader, m);
                            }
                            m.put(col2, this.getTrimmedString(rs, 3));
                            continue;
                        }
                        if (!Boolean.FALSE.equals(colsDone) || colList.isEmpty() || !ModelUtil.hasLength((String)(col3 = rs.getString(3)))) continue;
                        Tuple t = (Tuple)colList.get(colList.size() - 1);
                        Column c = (Column)t.object1();
                        String comment = (String)c.getProperty("Comment");
                        comment = comment + "\n" + col3;
                        c.setProperty("Comment", (Object)comment);
                    }
                }
            });
            for (Tuple tuple : colList) {
                Column col = (Column)tuple.object1();
                DataTypeUsage dtu = DataTypeHelper.getDataTypeUsageForString((DBObjectProvider)this.m_db, (Schema)tab.getSchema(), (String)((String)tuple.object2()));
                col.setDataTypeUsage(dtu);
                HiveTableBuilder.fixComment((DBObject)col);
                this.m_colMap.put(col.getName(), col);
            }
        }

        private String getTrimmedString(ResultSet rs, int index) throws SQLException {
            String retval = rs.getString(index);
            return retval == null ? null : retval.trim();
        }

        void extractProperties(Map<String, String> mappings, DBObject htp) {
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String val = this.m_metadata.get(entry.getKey());
                if (val == null) continue;
                htp.setProperty(entry.getValue(), (Object)val);
            }
        }

        void extractInteger(String key, DBObject obj, String prop, boolean allowNegative) {
            Integer val = null;
            String s = this.m_metadata.get(key);
            if (s != null && ModelUtil.hasLength((String)(s = s.trim()))) {
                try {
                    val = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    this.getLogger().warning("Invalid number " + s + " for " + prop);
                }
            }
            if (val != null && (allowNegative || val >= 0)) {
                obj.setProperty(prop, (Object)val);
            }
        }

        boolean extractColumnList(String key, DBObject obj, String prop) {
            boolean retval = false;
            String colList = this.m_metadata.get(key);
            if (ModelUtil.hasLength((String)colList)) {
                colList = this.stripSquareBrackets(colList);
                String[] names = colList.split(",");
                ArrayList<DBObjectID> ids = new ArrayList<DBObjectID>();
                for (String name : names) {
                    DBObjectID id = this.getColumnID(name.trim());
                    if (id == null) continue;
                    ids.add(id);
                }
                if (!ids.isEmpty()) {
                    obj.setProperty(prop, (Object)ids.toArray(new DBObjectID[ids.size()]));
                    retval = true;
                }
            }
            return retval;
        }

        private String stripSquareBrackets(String string) {
            String retval = string;
            int length = retval.length();
            if (retval.charAt(0) == '[' && retval.charAt(length - 1) == ']') {
                retval = retval.substring(1, length - 1);
            }
            return retval;
        }

        private DBObjectID getColumnID(String name) {
            DBObjectID retval = null;
            if (ModelUtil.hasLength((String)name)) {
                Column c = this.m_colMap.get(name);
                if (c == null) {
                    this.getLogger().warning("Column " + name + " not found");
                } else {
                    retval = c.getID();
                }
            }
            return retval;
        }

        void extractSortColList(String key, DBObject obj, String prop) {
            ArrayList<IndexObject> clause = new ArrayList<IndexObject>();
            String orderList = this.m_metadata.get(key);
            if (ModelUtil.hasLength((String)orderList)) {
                try {
                    if (s_orderPattern == null) {
                        s_orderPattern = Pattern.compile("Order\\(col:(?<col>[^\\\\s,]+), order:(?<ord>[0|1])\\)");
                    }
                    Matcher m = s_orderPattern.matcher(orderList);
                    while (m.find()) {
                        String name = m.group("col");
                        String ord = m.group("ord");
                        IndexObject io = (IndexObject)this.m_db.getObjectFactory().newObject(IndexObject.class);
                        io.setExpressionSource(name);
                        DBObjectID colID = this.getColumnID(name);
                        if (colID != null) {
                            ColumnUsage cu = new ColumnUsage(colID);
                            io.setExpression((SQLFragment)cu);
                        }
                        io.setOrderType("0".equals(ord) ? IndexObject.OrderType.DESC : IndexObject.OrderType.ASC);
                        clause.add(io);
                    }
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Parsing Order list failed", e);
                }
            }
            if (!clause.isEmpty()) {
                obj.setProperty(prop, (Object)clause.toArray(new IndexObject[clause.size()]));
            }
        }

        void extractSkew(DBObject par) {
            HiveSkewProperties skew = new HiveSkewProperties();
            if (this.extractColumnList(HiveTableBuilder.SKEW_COLS_PROP, (DBObject)skew, "skewedColumns")) {
                par.setProperty("HiveSkewProperties", (Object)skew);
                this.extractSkewValues(HiveTableBuilder.SKEW_VALS_PROP, (DBObject)skew, "skewedValues");
                if (HiveTableBuilder.YES.equalsIgnoreCase(this.m_metadata.get(HiveTableBuilder.SKEW_STORED_AS_DIRS))) {
                    skew.setStoredAsDirectories(Boolean.valueOf(true));
                }
            }
        }

        private void extractSkewValues(String key, DBObject obj, String prop) {
            String valString = this.m_metadata.get(key);
            if (ModelUtil.hasLength((String)valString)) {
                String[] partToks;
                ArrayList<HivePartition> parts = new ArrayList<HivePartition>();
                valString = this.stripSquareBrackets(valString);
                valString = this.stripSquareBrackets(valString);
                for (String values : partToks = valString.split(Pattern.quote("], ["))) {
                    parts.add(new HivePartition(values.split(", ")));
                }
                if (!parts.isEmpty()) {
                    obj.setProperty(prop, (Object)parts.toArray(new HivePartition[parts.size()]));
                }
            }
        }

        TblProperty[] createPropertiesModel(Map<String, String> map) throws DBException {
            TblProperty[] retval = new TblProperty[map.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                retval[i++] = new TblProperty(entry.getKey(), entry.getValue());
            }
            return retval;
        }
    }
}

