/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveBucketProperties;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;

public class HiveBucketPropertiesValidator
extends AbstractChildDBObjectValidator<HiveBucketProperties> {
    public HiveBucketPropertiesValidator(DBObjectProvider pro) {
        super(pro);
    }

    protected boolean canHaveEmptyName() {
        return true;
    }

    @DBObjectValidator.PropertyValidator(value={"bucketColumns"}, level=ValidationLevel.FULL)
    public void validateBucketColumns(HiveBucketProperties orig, HiveBucketProperties props) throws ValidationException {
        HiveBucketPropertiesValidator.validateColumnsExist(props.getBucketColumns(), (DBObject)props);
    }

    @DBObjectValidator.PropertyValidator(value={"numberOfBuckets"}, level=ValidationLevel.FULL)
    @DBObjectValidator.PropertyDependency(value={"bucketColumns"})
    public void validateBucketNum(HiveBucketProperties orig, HiveBucketProperties props) throws ValidationException {
        Integer num;
        DBObjectID[] cols = props.getBucketColumns();
        if (cols != null && cols.length > 0 && ((num = props.getNumberOfBuckets()) == null || num <= 0)) {
            throw new ValidationException((DBObject)props, HiveBundle.get("INVALID_BUCKET_NUM_MISSING"));
        }
    }

    @DBObjectValidator.PropertyValidator(value={"bucketSortColumns"}, level=ValidationLevel.FULL)
    public void validateBucketSortColumns(HiveBucketProperties orig, HiveBucketProperties props) throws ValidationException {
        IndexObject[] sortExps;
        for (IndexObject io : sortExps = props.getBucketSortColumns()) {
            boolean valid;
            String exp = io.getExpressionSource();
            if (ModelUtil.hasLength((String)exp)) {
                Object expressionFragment = null;
                try {
                    this.getProvider().getObjectFactory().ensureDerivedPropertyBuilder((DBObject)io);
                    DBUtil.ensureObjectBuilt((DBObject)io, (String[])new String[]{"expression"});
                    valid = true;
                }
                catch (DBException e) {
                    valid = false;
                }
            } else {
                valid = false;
            }
            if (valid) continue;
            throw new ValidationException((DBObject)props, HiveBundle.format("INVALID_BUCKET_SORT", exp));
        }
    }

    static void validateColumnsExist(DBObjectID[] colIDs, DBObject props) throws ValidationException {
        Table tab;
        if (colIDs != null && colIDs.length > 0 && (tab = (Table)DBUtil.findParentOfType((DBObject)props, Table.class)) != null) {
            for (DBObjectID colID : colIDs) {
                Column col = (Column)tab.findOwnedObject(colID);
                if (col != null) continue;
                throw new ValidationException(props, HiveBundle.format("INVALID_COL", DBUtil.getDBObjectName((DBObjectID)colID)));
            }
        }
    }
}

