/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

abstract class AbstractPropertyFilter
implements DifferenceFilter {
    AbstractPropertyFilter() {
    }

    public final boolean isFilteredProperty(Difference propertyDiff, String prop) {
        boolean result = false;
        if (ModelUtil.hasLength((String)prop)) {
            DBObject original = null;
            DBObject updated = null;
            StringBuilder path = new StringBuilder();
            Difference diff = propertyDiff;
            while (diff != null) {
                Difference parent;
                if (path.length() > 0 && DBObject.class.isAssignableFrom(diff.getDifferenceClass())) {
                    Object uo = diff.getUpdatedObject();
                    Object oo = diff.getOriginalObject();
                    if (uo instanceof DBObject || uo == null && oo instanceof DBObject) {
                        original = (DBObject)oo;
                        updated = (DBObject)uo;
                        if (this.useRelativePropertyPath()) break;
                    }
                }
                if ((parent = diff.getParent()) != null && !parent.isList()) {
                    if (path.length() > 0) {
                        path.insert(0, "/");
                    }
                    path.insert(0, diff.getPropertyName());
                }
                diff = parent;
            }
            String redactedProp = path.toString();
            DBObject obj = this.getAnObject(original, updated);
            if (obj != null && redactedProp.length() > 0 && !this.ignoreProperty(obj, redactedProp)) {
                result = this.isFilteredProperty(propertyDiff, original, updated, redactedProp);
            }
        }
        return result;
    }

    protected boolean ignoreProperty(DBObject obj, String redactedProp) {
        boolean retval = false;
        retval = this.useRelativePropertyPath() ? obj instanceof DataTypeUsage && redactedProp.startsWith("attributeValues") : redactedProp.contains(Property.createPath((String[])new String[]{"dataTypeUsage", "attributeValues"}));
        return retval;
    }

    protected boolean useRelativePropertyPath() {
        return true;
    }

    protected final DBObject getAnObject(DBObject obj, DBObject obj2) {
        return obj == null ? obj2 : obj;
    }

    protected abstract boolean isFilteredProperty(Difference var1, DBObject var2, DBObject var3, String var4);
}

