/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;

public class DB2DictionaryQueries
extends DictionaryQueries {
    private static final String CURR_USER_QUERY = "select strip(user,T) from sysibm.sysdummy1";
    public static final String CURR_SCHEMA_QUERY = "select strip(current_schema,T) from sysibm.sysdummy1";
    private static final String SCHEMAS_QUERY = "select strip(schemaname,T), 'SCHEMA' from syscat.schemata where strip(schemaname,T) like ?";
    public static final String UNIQUE_KEYS_QUERY = "select constname, tabname from SYSCAT.TABCONST where type = 'U' and tabname = ? ";
    public static final String CHECK_CONSTRAINT_QUERY = "select constname, text from SYSCAT.CHECKS where tabschema = ? and tabname = ? ";
    public static final String KEY_COL_QUERY = "select colname from syscat.keycoluse where constname = ?  and tabname = ?  and tabschema = ?  order by colseq";
    public static final String FOREIGN_KEY_QUERY = "select ky.PKTABLE_CAT, ky.PKTABLE_SCHEM, ky.PKTABLE_NAME, ky.PKCOLUMN_NAME, ky.FKTABLE_CAT, ky.FKTABLE_SCHEM, ky.FKTABLE_NAME, ky.FKCOLUMN_NAME, ky.KEY_SEQ, ky.UPDATE_RULE, ky.DELETE_RULE, ky.FK_NAME, ky.PK_NAME, ky.DEFERRABILITY from sysibm.sqlforeignkeys ky where ky.FKTABLE_SCHEM = ? and ky.FKTABLE_NAME = ? and ky.PKTABLE_NAME in ( select tb.table_name from sysibm.sqltables tb where tb.table_type = 'TABLE' and  tb.table_schem = ky.PKTABLE_SCHEM )";
    private static final String LIST_TABLES_QUERY = "select TABLE_NAME, TABLE_TYPE from SYSIBM.SQLTABLES where TABLE_SCHEM = ? and TABLE_NAME like ? and TABLE_TYPE IN (<types>)";
    public static final String VIEW_SQL_QUERY = " SELECT text, viewcheck  FROM syscat.views  WHERE strip(viewschema,T) = ? AND viewname = ? ";
    public static final String ALIAS_REF_QUERY = " SELECT base_tabname, strip(base_tabschema,T)  FROM syscat.tables  WHERE type = 'A' AND strip(tabschema,T) = ? AND tabname = ? ";
    private DB2UniversalDatabase m_db;
    private int m_type;

    public DB2DictionaryQueries(DB2UniversalDatabase db) {
        this.m_db = db;
        this.m_type = db.getDatabaseVersion();
    }

    public String getStandardListQuery(String[] types) {
        String query = LIST_TABLES_QUERY;
        return this.addTypeBinds(query, types.length);
    }

    private String addTypeBinds(String query, int numbinds) {
        StringBuffer binds = new StringBuffer();
        for (int i = 0; i < numbinds; ++i) {
            binds.append("?");
            if (i + 1 >= numbinds) continue;
            binds.append(", ");
        }
        return query.replace("<types>", binds.toString());
    }

    public DictionaryQueries.Params[] getStandardListQueryParams() {
        return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF, DictionaryQueries.Params.ALL_TYPES};
    }

    public boolean isCustomListQuery(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        return "SCHEMA".equals(type);
    }

    public String getCustomListQuery(String type, boolean defaultSchema, DBObjectCriteria criteria) throws IllegalStateException {
        if (!type.equals("SCHEMA")) {
            throw new IllegalStateException("Custom query requested for unsupported type : " + type);
        }
        String query = SCHEMAS_QUERY;
        return query;
    }

    public DictionaryQueries.Params[] getCustomListQueryParams(String type, boolean defaultSchema, DBObjectCriteria criteria) {
        if ("SCHEMA".equals(type)) {
            return new DictionaryQueries.Params[]{DictionaryQueries.Params.NAMEREF};
        }
        return new DictionaryQueries.Params[]{DictionaryQueries.Params.SCHEMA, DictionaryQueries.Params.NAMEREF};
    }

    public String getUserNameQuery() {
        return CURR_USER_QUERY;
    }
}

