/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.util.ModelUtil;

public class MnemonicBuilder {
    public static void build(String validChars, List<String> labels, List<Character> results) {
        int status = MnemonicBuilder.buildImpl(validChars, labels, results, false);
    }

    public static int buildStatus(String validChars, List<String> labels, List<Character> results) {
        return MnemonicBuilder.buildImpl(validChars, labels, results, true);
    }

    private static int buildImpl(String validChars, List<String> labels, List<Character> results, boolean getStatus) {
        results.clear();
        for (int i = 0; i < labels.size(); ++i) {
            results.add(null);
        }
        MnemonicBuilder.firstPass(validChars, labels, results);
        MnemonicBuilder.secondPass(validChars, labels, results);
        if (getStatus) {
            return MnemonicBuilder.getStatus(validChars, labels, results);
        }
        return 0;
    }

    private static void firstPass(String validChars, List<String> labels, List<Character> results) {
        String validCharsNow = validChars;
        block0: for (int i = 0; i < labels.size(); ++i) {
            String label = labels.get(i);
            for (Character c : MnemonicBuilder.getChars(validCharsNow, label)) {
                Integer score = MnemonicBuilder.getScore(label, c);
                boolean beaten = false;
                for (int j = 0; j < labels.size(); ++j) {
                    String label2;
                    Integer score2;
                    if (j == i || results.get(j) != null || (score2 = MnemonicBuilder.getScore(label2 = labels.get(j), c)) >= score) continue;
                    beaten = true;
                    break;
                }
                if (beaten) continue;
                results.set(i, c);
                validCharsNow = validCharsNow.replace(c.toString(), "");
                continue block0;
            }
        }
    }

    private static void secondPass(String validChars, List<String> labels, List<Character> results) {
        block0: for (int i = 0; i < labels.size(); ++i) {
            if (results.get(i) != null) continue;
            for (Character c : MnemonicBuilder.getChars(validChars, labels.get(i))) {
                int idx = MnemonicBuilder.getIndexUsingChar(results, c);
                boolean done = false;
                if (idx != -1) {
                    String label = labels.get(idx);
                    for (Character c2 : MnemonicBuilder.getChars(validChars, label)) {
                        int idx2 = MnemonicBuilder.getIndexUsingChar(results, c2);
                        if (idx2 != -1) continue;
                        results.set(i, c);
                        results.set(idx, c2);
                        done = true;
                        break;
                    }
                }
                if (!done) continue;
                continue block0;
            }
        }
    }

    private static List<Character> getChars(String validChars, String label) {
        ArrayList<Character> res = new ArrayList<Character>();
        if (ModelUtil.hasLength((String)label)) {
            int i;
            String upperLabel = label.toUpperCase();
            Character c = new Character(upperLabel.charAt(0));
            if (validChars.indexOf(c.toString()) >= 0) {
                res.add(c);
            }
            Character lastChar = c;
            for (i = 1; i < label.length(); ++i) {
                c = new Character(upperLabel.charAt(i));
                if (validChars.indexOf(c.toString()) >= 0 && !res.contains(c) && !Character.isWhitespace(c.charValue()) && Character.isWhitespace(lastChar.charValue())) {
                    res.add(c);
                }
                lastChar = c;
            }
            for (i = 1; i < label.length(); ++i) {
                c = new Character(upperLabel.charAt(i));
                if (validChars.indexOf(c.toString()) < 0 || res.contains(c) || Character.isWhitespace(c.charValue())) continue;
                res.add(c);
            }
        }
        return res;
    }

    private static Integer getScore(String label, Character c) {
        Integer res = 10;
        if (ModelUtil.hasLength((String)label)) {
            String upperLabel = label.toUpperCase();
            int idx = upperLabel.indexOf(c.charValue());
            if (idx == 0) {
                res = 1;
            } else if (idx != -1) {
                res = 3;
                Character lastChar = new Character(upperLabel.charAt(0));
                for (int i = 1; i < upperLabel.length(); ++i) {
                    Character ch = new Character(upperLabel.charAt(i));
                    if (ch.equals(c) && Character.isWhitespace(lastChar.charValue())) {
                        res = 2;
                        break;
                    }
                    lastChar = ch;
                }
            }
        }
        return res;
    }

    private static int getIndexUsingChar(List<Character> results, Character chr) {
        for (int i = 0; i < results.size(); ++i) {
            if (!chr.equals(results.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static int getStatus(String validChars, List<String> labels, List<Character> results) {
        int status = 0;
        int numOfSetLabels = 0;
        for (int i = 0; i < results.size(); ++i) {
            if (results.get(i) == null) continue;
            ++numOfSetLabels;
        }
        if (numOfSetLabels < labels.size()) {
            HashSet<Character> charsInAllLabels = new HashSet<Character>();
            for (int i = 0; i < labels.size(); ++i) {
                String label = labels.get(i);
                charsInAllLabels.addAll(MnemonicBuilder.getChars(validChars, label));
            }
            status = charsInAllLabels.size() - numOfSetLabels;
        }
        return status;
    }
}

