/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorIterator;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroupState;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

final class WindowFlatWindows
extends JPanel
implements ListSelectionListener,
KeyListener {
    private static final boolean DISMISS_WITHOUT_WINDOWS = true;
    private List _duplicates;
    private JList _lWindows;
    private JButton _jbActivate;
    private JButton _jbClose;
    private DismissableJEWTDialog _container;

    public static boolean runDialog(Frame frame) {
        WindowFlatWindows panel = new WindowFlatWindows();
        HelpSystem hs = HelpSystem.getHelpSystem();
        DismissableJEWTDialog dlg = new DismissableJEWTDialog(frame);
        if (hs != null) {
            hs.registerTopic(panel, "f1_idedwindows_html");
        }
        panel._container = dlg;
        dlg.setInitialFocus(panel._lWindows);
        dlg.setContent(panel);
        dlg.setResizable(true);
        return WizardLauncher.runDialog((JDialog)((Object)dlg));
    }

    private WindowFlatWindows() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        BorderLayout layout = new BorderLayout(0, 2);
        this.setLayout(layout);
        this.setSize(new Dimension(400, 300));
        JLabel lblWindows = new JLabel();
        this._jbActivate = new JButton();
        this._jbClose = new JButton();
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._jbActivate);
        controlBar.add((Component)this._jbClose);
        DefaultListModel lm = new DefaultListModel();
        this._lWindows = new JList(lm);
        ComponentWithTitlebar titledComponent = new ComponentWithTitlebar((JComponent)new JScrollPane(this._lWindows), lblWindows, controlBar);
        this.add((Component)titledComponent, "Center");
        this._lWindows.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                MyModelElement myModelElement = (MyModelElement)value;
                String text = myModelElement.getText();
                this.setText(text);
                TabGroupState tgs = myModelElement.getTabGroupState();
                Node node = tgs.getContext().getNode();
                this.setIcon(node.getIcon());
                return this;
            }
        });
        this._lWindows.addKeyListener(this);
        this._lWindows.addListSelectionListener(this);
        this.fillEditors();
        if (!lm.isEmpty()) {
            this._lWindows.setSelectedIndex(0);
        }
        this.enableButtons();
        ResourceUtils.resLabel((JLabel)lblWindows, (Component)this._lWindows, (String)DialogsArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this._jbActivate, (String)DialogsArb.getString(12));
        ResourceUtils.resButton((AbstractButton)this._jbClose, (String)DialogsArb.getString(13));
        final ActionListener alActivateAndGo = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowFlatWindows.this.whenActivate();
                WindowFlatWindows.this._container.dismiss();
            }
        };
        this._jbActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowFlatWindows.this.whenActivate();
            }
        });
        this._jbClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowFlatWindows.this.whenClose();
            }
        });
        this._lWindows.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    alActivateAndGo.actionPerformed(null);
                }
            }
        });
        this._lWindows.setSelectionMode(2);
    }

    private void fillEditors() {
        EditorIterator iterator = new EditorIterator(3);
        ArrayList editors = Collections.list(iterator);
        Collections.sort(editors, new Comparator(){

            public int compare(Object o1, Object o2) {
                TabGroupState ts1 = (TabGroupState)o1;
                TabGroupState ts2 = (TabGroupState)o2;
                Context context1 = ts1.getContext();
                Context context2 = ts2.getContext();
                Node node1 = context1.getNode();
                Node node2 = context2.getNode();
                return String.CASE_INSENSITIVE_ORDER.compare(node1.getShortLabel(), node2.getShortLabel());
            }
        });
        this._duplicates = WindowFlatWindows.getDuplicates(editors);
        DefaultListModel lm = (DefaultListModel)this._lWindows.getModel();
        ListSelectionModel lsm = this._lWindows.getSelectionModel();
        List<Object> oldSel = Arrays.asList(this._lWindows.getSelectedValues());
        lm.clear();
        int n = editors.size();
        lm.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            TabGroupState tgs = (TabGroupState)editors.get(i);
            MyModelElement myModelElement = new MyModelElement(tgs);
            lm.addElement(myModelElement);
            if (!oldSel.contains(myModelElement)) continue;
            lsm.addSelectionInterval(i, i);
        }
        this.enableButtons();
    }

    private static List getDuplicates(List editors) {
        ArrayList<TabGroupState> l = null;
        int n = editors.size();
        for (int i = 0; i < n; ++i) {
            TabGroupState tabGroupState = (TabGroupState)editors.get(i);
            String sLabel = tabGroupState.getContext().getNode().getShortLabel();
            boolean bDup = false;
            for (int j = i + 1; j < n; ++j) {
                TabGroupState tabGroupState2 = (TabGroupState)editors.get(j);
                Node node2 = tabGroupState2.getContext().getNode();
                if (!sLabel.equals(node2.getShortLabel())) continue;
                if (l == null) {
                    l = new ArrayList<TabGroupState>();
                }
                l.add(tabGroupState2);
                bDup = true;
            }
            if (!bDup) continue;
            l.add(tabGroupState);
        }
        return l == null ? Collections.EMPTY_LIST : l;
    }

    private void whenActivate() {
        Object[] sel = this._lWindows.getSelectedValues();
        if (sel.length > 0) {
            EditorPathImpl editorPath;
            MyModelElement myModelElement = (MyModelElement)sel[sel.length - 1];
            TabGroupState tabGroupState = myModelElement.getTabGroupState();
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(tabGroupState))) {
                editorManager.activateEditor(editorPath);
            }
        }
    }

    private void whenClose() {
        DefaultListModel lm = (DefaultListModel)this._lWindows.getModel();
        Object[] sel = this._lWindows.getSelectedValues();
        int n = sel.length;
        if (n > 0) {
            MyModelElement myModelElement = (MyModelElement)sel[0];
            int selAfterClose = this.getIndexOf(myModelElement);
            TabGroupState[] tabGroupStates = new TabGroupState[n];
            for (int i = 0; i < n; ++i) {
                MyModelElement sel_i = (MyModelElement)sel[i];
                tabGroupStates[i] = sel_i.getTabGroupState();
            }
            EditorManagerImpl em = (EditorManagerImpl)EditorManager.getEditorManager();
            em.closeEditors(tabGroupStates);
            this.fillEditors();
            int newWindowCount = lm.getSize();
            if (newWindowCount > 0) {
                if ((selAfterClose = Math.min(selAfterClose, newWindowCount - 1)) >= 0) {
                    this._lWindows.setSelectedIndex(selAfterClose);
                }
            } else {
                this._container.dismiss();
            }
        }
    }

    private int getIndexOf(MyModelElement myModelElement) {
        ListModel model = this._lWindows.getModel();
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            if (!myModelElement.equals(model.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void enableButtons() {
        int[] sel = this._lWindows.getSelectedIndices();
        switch (sel.length) {
            case 0: {
                this._jbActivate.setEnabled(false);
                this._jbClose.setEnabled(false);
                break;
            }
            case 1: {
                this._jbActivate.setEnabled(true);
                this._jbClose.setEnabled(true);
                break;
            }
            default: {
                this._jbActivate.setEnabled(false);
                this._jbClose.setEnabled(true);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isConsumed() && e.getKeyCode() == 10) {
            this.whenActivate();
            this._container.dismiss();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class MyModelElement {
        private TabGroupState _tabGroupState;

        public MyModelElement(TabGroupState tabGroupState) {
            this._tabGroupState = tabGroupState;
        }

        public boolean equals(Object obj) {
            MyModelElement other = (MyModelElement)obj;
            return this._tabGroupState.equals(other._tabGroupState);
        }

        public int hashCode() {
            return this._tabGroupState.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        public TabGroupState getTabGroupState() {
            return this._tabGroupState;
        }

        String getText() {
            Node node = this._tabGroupState.getContext().getNode();
            String text = node.getShortLabel();
            if (WindowFlatWindows.this._duplicates.contains(this._tabGroupState)) {
                text = text + "(" + node.getLongLabel() + ")";
            }
            return text;
        }
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame owner) {
            super(owner, DialogsArb.getString(10), 5);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }
    }
}

