/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.util;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresetKeystrokeContextUtil {
    private static String PRESET_TAG = "preset";
    private static String CONTEXT_TAG = "context";
    private static String NAME_TAG = "name";
    private static String MAP_TAG = "map";
    private static String ACTION_TAG = "action";

    private PresetKeystrokeContextUtil() {
    }

    public static void usage() {
        System.out.println("Preset keystroke loader version 9i");
        System.out.println("Usage:  PresetKeystrokeContextUtil <???.kdf file> <preset entry xml file>");
        System.out.println("");
        System.exit(0);
    }

    private static Document getDocument(URL url) throws Exception {
        XMLDocument doc;
        try {
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(false);
            parser.parse(url);
            doc = parser.getDocument();
        }
        catch (Exception e) {
            System.out.println("Unable to parse or locate " + url.getPath());
            throw e;
        }
        return doc;
    }

    private static Element getContextNamed(NodeList contexts, String name) {
        if (name != null) {
            int length = contexts.getLength();
            for (int i = 0; i < length; ++i) {
                String contextName = PresetKeystrokeContextUtil.getName((Element)contexts.item(i));
                if (contextName == null || !contextName.equals(name)) continue;
                return (Element)contexts.item(i);
            }
        }
        return null;
    }

    private static Element getMapForAction(NodeList maps, String action) {
        if (action != null) {
            int length = maps.getLength();
            for (int i = 0; i < length; ++i) {
                String mapAction = PresetKeystrokeContextUtil.getAction((Element)maps.item(i));
                if (mapAction == null || !mapAction.equals(action)) continue;
                return (Element)maps.item(i);
            }
        }
        return null;
    }

    private static String getAction(Element node) {
        return node.getAttribute(ACTION_TAG);
    }

    private static String getName(Element node) {
        return node.getAttribute(NAME_TAG);
    }

    private static void loadAndMergeItems(URL toURL, URL addURL) throws Exception {
        Document toDocument = PresetKeystrokeContextUtil.getDocument(toURL);
        Document addDocument = PresetKeystrokeContextUtil.getDocument(addURL);
        NodeList addContextNL = addDocument.getElementsByTagName(CONTEXT_TAG);
        if (addContextNL == null) {
            System.out.println("No context element in " + addURL.getPath());
            return;
        }
        NodeList toContextNL = toDocument.getElementsByTagName(CONTEXT_TAG);
        int contextLength = addContextNL.getLength();
        for (int i = 0; i < contextLength; ++i) {
            Element addMap;
            int j;
            Element addContext = (Element)addContextNL.item(i);
            String addContextName = PresetKeystrokeContextUtil.getName(addContext);
            Element toContext = PresetKeystrokeContextUtil.getContextNamed(toContextNL, addContextName);
            if (toContext == null) {
                Node kid = ((XMLDocument)toDocument).adoptNode((Node)addContext);
                NodeList toPresets = toDocument.getElementsByTagName(PRESET_TAG);
                toPresets.item(0).appendChild(kid);
                continue;
            }
            NodeList toMapNL = toContext.getElementsByTagName(MAP_TAG);
            NodeList addMapNL = addContext.getElementsByTagName(MAP_TAG);
            int addLength = addMapNL.getLength();
            if (addLength <= 0) continue;
            if (toMapNL.getLength() > 0) {
                for (j = 0; j < addLength; ++j) {
                    addMap = (Element)addMapNL.item(j);
                    Element toMap = PresetKeystrokeContextUtil.getMapForAction(toMapNL, PresetKeystrokeContextUtil.getAction(addMap));
                    if (toMap != null) continue;
                    Node kid = ((XMLDocument)toDocument).adoptNode((Node)addMap);
                    toContext.appendChild(kid);
                }
                continue;
            }
            for (j = 0; j < addLength; ++j) {
                addMap = (Element)addMapNL.item(j);
                Node kid = ((XMLDocument)toDocument).adoptNode((Node)addMap);
                toContext.appendChild(kid);
            }
        }
        ((XMLDocument)toDocument).print(new PrintWriter(URLFileSystem.openOutputStream((URL)toURL)));
    }

    private static URL getFileURL(String filePath) {
        URL url = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException muEx) {
                System.err.println("ERROR: URL [" + url.toString() + "] is not valid");
            }
        } else {
            System.err.println("ERROR: File [" + filePath + "] does not exist");
        }
        return url;
    }

    private static void abort(String errorText) {
        System.err.println("ERROR: " + errorText);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            PresetKeystrokeContextUtil.usage();
        }
        URL kdfURL = PresetKeystrokeContextUtil.getFileURL(args[0]);
        URL contextURL = PresetKeystrokeContextUtil.getFileURL(args[1]);
        if (contextURL == null || kdfURL == null) {
            PresetKeystrokeContextUtil.abort("Invalid Command Line Arguments Given");
            PresetKeystrokeContextUtil.usage();
        }
        try {
            PresetKeystrokeContextUtil.loadAndMergeItems(kdfURL, contextURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

