/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.shell;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.config.FileAssociations;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.ShellArb;

public final class ConfigureFileAssociationsDialog
extends JPanel {
    private JLabel lblTitle = new JLabel();
    private JCheckBox[] chkArray = null;
    private JLabel lblHelp = new JLabel();
    private GridBagLayout mainLayout = new GridBagLayout();
    public boolean ok = false;

    public ConfigureFileAssociationsDialog(String productName, ArrayList<String> fileTypes, ArrayList<String> labels) {
        try {
            if (productName == null || fileTypes == null || fileTypes.size() == 0) {
                return;
            }
            this.jbInit(productName, labels);
            this.loadData(fileTypes);
            HelpUtils.setHelpID((JComponent)this, (String)"f1_idedconfigurefiletypeassociations_html");
            JEWTDialog dlg = null;
            dlg = OnePageWizardDialogFactory.createJEWTDialog(this, this.chkArray[0], ShellArb.format(0, productName), 7);
            dlg.setResizable(true);
            Dimension dim = this.getPreferredSize();
            dim.width = Math.min(600, dim.width);
            this.setPreferredSize(dim);
            this.ok = WizardLauncher.runDialog((JDialog)dlg);
            if (this.ok) {
                this.saveData(fileTypes);
            }
            dlg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readAssociations(ArrayList<String> fileTypes) {
        for (int i = 0; i < fileTypes.size(); ++i) {
            if (!FileAssociations.isAssociated(fileTypes.get(i))) continue;
            this.chkArray[i].setSelected(true);
        }
    }

    private void loadData(ArrayList<String> fileTypes) {
        for (int i = 0; i < fileTypes.size(); ++i) {
            this.chkArray[i].setSelected(false);
        }
        this.readAssociations(fileTypes);
    }

    private void saveData(ArrayList<String> fileTypes) {
        HashMap<String, Boolean> associations = new HashMap<String, Boolean>();
        for (int i = 0; i < fileTypes.size(); ++i) {
            if (!this.chkArray[i].isSelected()) continue;
            associations.put(fileTypes.get(i), true);
        }
        FileAssociations.setAssociations(associations);
    }

    private void jbInit(String productName, ArrayList<String> labels) throws Exception {
        int i;
        ResourceUtils.resLabel((JLabel)this.lblTitle, null, (String)ShellArb.format(2, productName));
        ResourceUtils.resLabel((JLabel)this.lblHelp, null, (String)ShellArb.getString(3));
        this.chkArray = new JCheckBox[labels.size()];
        for (i = 0; i < labels.size(); ++i) {
            this.chkArray[i] = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.chkArray[i], (String)labels.get(i));
        }
        this.setLayout(this.mainLayout);
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        for (i = 0; i < this.chkArray.length; ++i) {
            double weight = i + 1 >= this.chkArray.length ? 1.0 : 0.0;
            this.add((Component)this.chkArray[i], new GridBagConstraints(0, i + 2, 1, 1, weight, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

