/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ideimpl.navigator.delete.model.IdeModelVisitor;

public class DeleteFileVisitor
extends IdeModelVisitor {
    private List<URL> m_undeleted = new ArrayList<URL>();

    @Override
    public void visitFile(File f) {
        if (f.exists()) {
            URL url = URLFactory.newFileURL((File)f);
            if (URLFileSystem.delete((URL)url)) {
                Assert.println((String)("Deleted " + url));
            } else {
                Assert.println((String)("Failed to delete " + url));
                this.m_undeleted.add(url);
            }
        }
    }

    @Override
    public void visitProject(Project p) {
        if (URLFileSystem.delete((URL)URLFileSystem.getParent((URL)p.getURL()))) {
            Assert.println((String)("Failed to delete the parent folder of " + p.getURL()));
        }
    }

    @Override
    public void visitWorkspace(Workspace w) {
        if (URLFileSystem.delete((URL)URLFileSystem.getParent((URL)w.getURL()))) {
            Assert.println((String)("Failed to delete the parent folder of " + w.getURL()));
        }
    }

    public List<URL> getUndeleted() {
        return this.m_undeleted;
    }

    void addUndeleted(URL url) {
        this.m_undeleted.add(url);
    }
}

