/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.ideimpl.model.SharedProjectPropertiesHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public final class SharedPropertiesManagerImpl
extends SharedPropertiesManager {
    @Override
    public PropertyStorage getPropertyStorage(Project project, String propertyDataKey) {
        Workspace workspace = project.getWorkspace();
        if (workspace == null) {
            throw new IllegalStateException("Project.getWorkspace() returned null");
        }
        return this.getPropertyStorage(project, workspace, propertyDataKey);
    }

    @Override
    public PropertyStorage getPropertyStorage(Project project, Workspace workspace, String propertyDataKey) {
        if (this.propertiesAreShareable(propertyDataKey) && InheritedProperties.getInstance(project).inheritsProperties(propertyDataKey)) {
            WorkspaceLevelProjectProperties workspaceProperties = WorkspaceLevelProjectProperties.getInstance(workspace.getSharedPropertiesOnly());
            return new PropertyData(workspaceProperties.getProperties());
        }
        return new PropertyData(project.getProperties());
    }

    @Override
    public boolean propertiesAreShareable(String propertyDataKey) {
        return SharedProjectPropertiesHook.shareable(propertyDataKey);
    }

    @Override
    public boolean isUsingSharedProperties(Project project, String propertyDataKey) {
        return this.propertiesAreShareable(propertyDataKey) && InheritedProperties.getInstance(project).inheritsProperties(propertyDataKey);
    }

    @Override
    public void setUsesSharedProperties(Project project, String propertyDataKey, boolean usesShared) {
        if (this.propertiesAreShareable(propertyDataKey)) {
            InheritedProperties.getInstance(project).setinheritsProperties(propertyDataKey, usesShared);
        } else {
            Assert.printStackTrace((String)(propertyDataKey + " is not shareable. To make properties shareable, the root data key must be registered with the shared-project-properties hook"));
        }
    }

    public HashStructure getWorkspaceLevelProjectProperties(Workspace workspace) {
        return WorkspaceLevelProjectProperties.getInstance(workspace.getSharedPropertiesOnly()).getProperties();
    }

    private static class PropertyData
    implements PropertyStorage {
        final HashStructure _hash;

        public PropertyData(HashStructure hash) {
            this._hash = hash;
        }

        public HashStructure getProperties() {
            return this._hash;
        }
    }

    private static class InheritedProperties
    extends HashStructureAdapter {
        private static final String DATA_KEY = "use-workspace-shared-properties";

        private InheritedProperties(HashStructure hash) {
            super(hash);
        }

        static InheritedProperties getInstance(Project project) {
            return new InheritedProperties(project.getSharedPropertiesOnly());
        }

        boolean inheritsProperties(String propertyDataKey) {
            if (!this._hash.containsKey(DATA_KEY)) {
                return false;
            }
            HashStructure inheritedPropertiesHash = this._hash.getHashStructure(DATA_KEY);
            return inheritedPropertiesHash.getBoolean(propertyDataKey, false);
        }

        void setinheritsProperties(String propertyDataKey, boolean useShared) {
            if (useShared) {
                HashStructure inheritedPropertiesHash = this._hash.getOrCreateHashStructure(DATA_KEY);
                inheritedPropertiesHash.putBoolean(propertyDataKey, useShared);
            } else if (this._hash.containsKey(DATA_KEY)) {
                HashStructure inheritedPropertiesHash = this._hash.getHashStructure(DATA_KEY);
                inheritedPropertiesHash.remove(propertyDataKey);
            }
        }
    }

    private static class WorkspaceLevelProjectProperties
    extends HashStructureAdapter {
        private static final String WORKSPACE_LEVEL_PROPERTIES_KEY = "shared-project-properties";

        public static WorkspaceLevelProjectProperties getInstance(HashStructure hash) {
            return new WorkspaceLevelProjectProperties(hash.getOrCreateHashStructure(WORKSPACE_LEVEL_PROPERTIES_KEY));
        }

        private WorkspaceLevelProjectProperties(HashStructure hash) {
            super(hash);
        }

        HashStructure getProperties() {
            return this.getHashStructure();
        }
    }
}

