/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.HookProcessingUtils;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.util.MetaClass;
import oracle.ide.model.HSAdapterDelegate;
import oracle.ide.model.HSAdapterDelegateMediator;

public class HSAdapterDelegateHookHandler
extends ExtensionHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "hash-structure-adapter-delegate");
    private static final ElementName INCLUDE_ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "include");

    public void start(ElementStartContext context) {
        String delegateClass = context.getAttributeValue("class");
        if (delegateClass == null) {
            context.getLogger().warning("'class' attribute is missing, ignoring hook registration of " + HOOK_NAME + " in extension " + context.getExtension().getID());
            return;
        }
        String technologyScope = context.getAttributeValue("technology-scope");
        if (technologyScope == null) {
            context.getLogger().warning("'technology-scope' attribute is missing in extension " + context.getExtension().getID());
            return;
        }
        context.registerChildVisitor(INCLUDE_ELEMENT_NAME, (ElementVisitor)new IncludeElementVisitor((MetaClass<? extends HSAdapterDelegate>)new MetaClass(ElementVisitor.getClassLoader((ElementContext)context), delegateClass), technologyScope));
    }

    private static class IncludeElementVisitor
    extends ElementVisitor {
        private static final String DATA_KEY = "data-key";
        private static final String DISABLED_TEXT = "disabled-text";
        private static final String DISABLED_ICON = "disabled-icon";
        private static final String TYPE = "type";
        private static final String PARENT_ELEMENT = "parent-element";
        private final MetaClass<? extends HSAdapterDelegate> m_metaClass;
        private final String m_techScope;

        IncludeElementVisitor(MetaClass<? extends HSAdapterDelegate> mc, String techScope) {
            this.m_metaClass = mc;
            this.m_techScope = techScope;
        }

        public void start(ElementStartContext context) {
            String hsDelegateType;
            String dataKey = context.getAttributeValue(DATA_KEY);
            if (dataKey == null) {
                context.getLogger().warning("'data-key' attribute is missing");
                return;
            }
            String disabledText = context.getAttributeValue(DISABLED_TEXT);
            if (disabledText == null) {
                context.getLogger().warning("'disabled-text' attribute is missing");
                return;
            }
            String parentElement = context.getAttributeValue(PARENT_ELEMENT);
            if (parentElement == null) {
                context.getLogger().warning("'parent-element' attribute is missing");
                return;
            }
            String disabledIconPath = context.getAttributeValue(DISABLED_ICON);
            URL disabledIconURL = null;
            if (disabledIconPath != null) {
                try {
                    disabledIconURL = HookProcessingUtils.resolvedValue2URL((String)disabledIconPath);
                    if (disabledIconURL == null) {
                        ClassLoader classloader = ExtensionVisitor.getClassLoader((ElementContext)context);
                        disabledIconURL = classloader.getResource(disabledIconPath);
                    }
                }
                catch (MalformedURLException e) {
                    context.getLogger().log(Level.SEVERE, "attribute 'disabled-icon'  which equals '" + disabledIconPath + "' could not resolve to a URL", e);
                }
            }
            HSAdapterDelegate.Type type = (hsDelegateType = context.getAttributeValue(TYPE)) != null ? (hsDelegateType.equalsIgnoreCase(HSAdapterDelegate.Type.DISABLE_ONLY.toString()) ? HSAdapterDelegate.Type.DISABLE_ONLY : HSAdapterDelegate.Type.DELEGATE) : HSAdapterDelegate.Type.DELEGATE;
            HSAdapterDelegateMediator.getMediator().registerDelegate(dataKey, disabledText, disabledIconURL, parentElement, this.m_metaClass, this.m_techScope, type);
        }
    }
}

