/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.command.Controller;
import javax.ide.extension.OnDemandElementVisitorListener;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.MenuHook;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;
import javax.ide.util.MissingIconException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.resource.IdeIcons;
import oracle.ideimpl.controller.IdeActionHook;
import oracle.ideimpl.jsr198.JSR198Action;
import oracle.ideimpl.jsr198.JavaxIdeController;
import oracle.ideimpl.jsr198.WrappedOracleAction;

public final class OracleActionRegistry
extends ActionRegistry {
    private static final Map TL_MENU_ID_MAP = new HashMap();
    private static final Map STANDARD_SECTIONS = new HashMap();
    private static final Map STANDARD_ITEMS = new HashMap();
    private static Map ACTION_ALIAS_MAP = null;
    private MenuActionRegHelper _regHelper;
    private HashMap<EphemeralMenu, JMenu> _ephemeralMenus = new HashMap();

    private void add(EphemeralMenu em, JMenu menu) {
        if (this._ephemeralMenus.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OracleActionRegistry.this._ephemeralMenus.clear();
                }
            });
        }
        this._ephemeralMenus.put(em, menu);
    }

    private JMenu get(EphemeralMenu key) {
        return this._ephemeralMenus.get(key);
    }

    protected void initialize() {
        this.registerActions();
    }

    public void initAfterMainWindowOpened() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.registerTopLevelMenus(this.getMenusAndClearModel());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OracleActionRegistry.this.registerTopLevelMenus(OracleActionRegistry.this.getMenusAndClearModel());
                }
            });
        }
        this.registerContextMenus();
        this.attachRegListeners();
    }

    private void attachRegListeners() {
        MenuHook menuHook = (MenuHook)javax.ide.extension.ExtensionRegistry.getExtensionRegistry().getHook(MenuHook.ELEMENT);
        menuHook.addMenuRegListener((OnDemandElementVisitorListener)this.getRegHelper());
        IdeActionHook actionHook = (IdeActionHook)ExtensionRegistry.getExtensionRegistry().getHook(IdeActionHook.ELEMENT);
        actionHook.addActionsRegListener(this.getRegHelper());
    }

    public void initAfterAddinsLoad() {
        this.registerControllerChains();
    }

    private Logger getExtensionLogger() {
        return ExtensionRegistry.getExtensionRegistry().getLogger();
    }

    private void registerContextMenus() {
        NavigatorManager m = NavigatorManager.getWorkspaceNavigatorManager();
        if (m != null) {
            m.getContextMenu().addContextMenuListener(new MyContextMenuListener("javax.ide.view.PROJECT_EXPLORER_POPUP_ID"));
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(new MyContextMenuListener("javax.ide.view.EDITOR_POPUP_ID"));
    }

    private MenuActionRegHelper getRegHelper() {
        if (this._regHelper == null) {
            this._regHelper = new MenuActionRegHelper();
        }
        return this._regHelper;
    }

    public void addToContextMenu(ContextMenu popup, String popupId, MenuModel model) {
        PopupMenu javaxPopup = (PopupMenu)model.getPopupMenus().get(popupId);
        if (javaxPopup != null) {
            this.addToMenu(new ContextMenuWrapper(popup), (SectionContainer)javaxPopup, false);
        }
    }

    public void addToJMenu(JMenu menu, String popupId, MenuModel model) {
        PopupMenu javaxPopup = (PopupMenu)model.getPopupMenus().get(popupId);
        if (javaxPopup != null) {
            this.addToMenu(new JMenuWrapper(menu), (SectionContainer)javaxPopup, false);
        }
    }

    private void registerControllerChains() {
        if (ACTION_ALIAS_MAP == null) {
            ACTION_ALIAS_MAP = new HashMap();
            ACTION_ALIAS_MAP.put("javax.ide.OPEN_ACTION_ID", Ide.findCmdName(9));
            ACTION_ALIAS_MAP.put("javax.ide.CUT_ACTION_ID", Ide.findCmdName(17));
            ACTION_ALIAS_MAP.put("javax.ide.COPY_ACTION_ID", Ide.findCmdName(18));
            ACTION_ALIAS_MAP.put("javax.ide.PASTE_ACTION_ID", Ide.findCmdName(19));
        }
        Map jsr198Actions = this.getModel().getActions();
        Set actionsWithControllers = this.getModel().getActionsWithControllers();
        for (String actionId : actionsWithControllers) {
            Integer oideActionId;
            List javaxIdeControllers = this.getModel().getControllers(actionId);
            if (jsr198Actions.get(actionId) != null) continue;
            String alias = (String)ACTION_ALIAS_MAP.get(actionId);
            if (alias != null) {
                actionId = alias;
            }
            if ((oideActionId = Ide.findCmdID(actionId)) == null) continue;
            final IdeAction oideAction = IdeAction.find(oideActionId);
            for (Controller javaxIdeController : javaxIdeControllers) {
                oideAction.addController(new JavaxIdeController(javaxIdeController){

                    @Override
                    protected IDEAction getJavaxIdeAction() {
                        return new WrappedOracleAction(oideAction.getCommandId());
                    }
                });
            }
        }
    }

    private void registerTopLevelMenus(List menus) {
        float weight = 0.0f;
        Iterator i = menus.iterator();
        while (i.hasNext()) {
            weight += 0.001f;
            Menu menu = (Menu)i.next();
            JMenu physicalMenu = this.getPhysicalMenu(menu);
            if (physicalMenu != null) {
                Float w = (Float)physicalMenu.getClientProperty("menu-weight");
                if (w == null) {
                    this.getExtensionLogger().warning("Found menu " + menu.getID() + " with no weight. Order may be wrong.");
                } else {
                    weight = w.floatValue();
                }
            } else {
                float menuWeight = menu.getWeight() != null ? menu.getWeight().floatValue() : Float.MAX_VALUE;
                float defaultSection = menu.getDefaultSection() != null ? menu.getDefaultSection().floatValue() : Float.MAX_VALUE;
                physicalMenu = Ide.getMenubar().createMenu(menu.getLabel(), new Integer(menu.getMnemonic()), menuWeight, defaultSection);
                MenuManager.putJMenu(menu.getID(), physicalMenu);
                if (menu.getLabel() != null) {
                    this.addMenuToMainMenubar(physicalMenu);
                } else {
                    this.getExtensionLogger().info(menu.getID() + " has no label and therefore will not be added to the menu bar.");
                    continue;
                }
            }
            this.addToMenu(new JMenuWrapper(physicalMenu), (SectionContainer)menu, true);
        }
    }

    private void addMenuToMainMenubar(JMenu physicalMenu) {
        if (SwingUtilities.isEventDispatchThread()) {
            Ide.getMenubar().add(physicalMenu);
        } else {
            final JMenu jmenu = physicalMenu;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Ide.getMenubar().add(jmenu);
                }
            });
        }
    }

    private void addToMenu(final PhysicalMenuWrapper physicalMenu, final SectionContainer modelMenu, final boolean destructive) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.addToMenuImpl(physicalMenu, modelMenu, destructive);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OracleActionRegistry.this.addToMenuImpl(physicalMenu, modelMenu, destructive);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMenuImpl(PhysicalMenuWrapper physicalMenu, SectionContainer modelMenu, boolean destructive) {
        List sections;
        Menubar menuMgr = Ide.getMenubar();
        float sectionWeight = physicalMenu.getAddinsSection();
        List list = sections = modelMenu.getSections();
        synchronized (list) {
            for (Section section : sections) {
                String menuId;
                String id;
                JMenu jMenu;
                Float f;
                float weight = 1000.0f;
                Float standardSection = (Float)STANDARD_SECTIONS.get(section.getID());
                if (standardSection != null) {
                    sectionWeight = standardSection.floatValue();
                    if ("javax.ide.NEW_SECTION_ID".equals(section.getID())) {
                        weight = MenuConstants.WEIGHT_FILE_OPEN - 0.05f;
                    }
                } else if (section.getWeight() != null) {
                    sectionWeight = section.getWeight().floatValue();
                } else if (section.getBefore() == null && section.getAfter() == null && (f = menuMgr.lookupMenuSection(modelMenu.getID(), section.getID())) != null) {
                    sectionWeight = f.floatValue();
                }
                if (section.isSortSectionAlphabetically()) {
                    JMenu jMenu2;
                    if (section.getWeight() == null) {
                        this.getExtensionLogger().warning("In order to sort a section alphabetically, a weight must be specified for the section.");
                    }
                    if ((jMenu2 = Menubar.getJMenu(modelMenu.getID())) != null) {
                        menuMgr.sortSectionByName(jMenu2, section.getWeight().floatValue());
                    }
                }
                if (destructive && section.isResolveMnemonics() && (jMenu = Menubar.getJMenu(id = TL_MENU_ID_MAP.containsKey(menuId = modelMenu.getID()) ? (String)TL_MENU_ID_MAP.get(menuId) : menuId)) != null) {
                    menuMgr.resolveMnemonicsForMenuItemsInSection(jMenu, section.getWeight().floatValue());
                }
                if (menuMgr.lookupMenuSection(modelMenu.getID(), section.getID()) == null) {
                    menuMgr.storeMenuSection(modelMenu.getID(), section.getID(), Float.valueOf(sectionWeight));
                }
                for (Object item : section.getContent()) {
                    if (item instanceof Item) {
                        String actionId = ((Item)item).getActionID();
                        Float standardWeight = (Float)STANDARD_ITEMS.get(actionId);
                        if (standardWeight != null) {
                            weight = standardWeight.floatValue();
                            continue;
                        }
                        Float w = ((Item)item).getWeight();
                        if (w != null) {
                            weight = w.floatValue();
                        } else if (IdeAction.DEBUG) {
                            this.getExtensionLogger().warning("ACTION DEBUG -- No weight specified for item: " + actionId);
                        }
                        Integer cmdId = Ide.findCmdID(actionId);
                        if (cmdId == null) {
                            this.getExtensionLogger().info("Cannot add " + actionId + " to menu; action has not been registered. " + "(Menu item may be added later if the action is registered by this extension.)");
                            continue;
                        }
                        IdeAction theAction = IdeAction.find(cmdId);
                        if (theAction == null) {
                            this.getExtensionLogger().severe("Unregistered action: " + actionId);
                            continue;
                        }
                        physicalMenu.add(menuMgr.createMenuItem(theAction, weight), sectionWeight);
                        continue;
                    }
                    if (!(item instanceof Menu)) continue;
                    Menu submenu = (Menu)item;
                    float f2 = weight = submenu.getWeight() != null ? submenu.getWeight().floatValue() : MenuConstants.increment(weight);
                    if (IdeAction.DEBUG && submenu.getWeight() == null) {
                        this.getExtensionLogger().warning("ACTION DEBUG -- No weight specified for submenu: " + submenu.getLabel());
                    }
                    float defaultSection = submenu.getDefaultSection() != null ? submenu.getDefaultSection().floatValue() : Float.MAX_VALUE;
                    EphemeralMenu key = new EphemeralMenu(physicalMenu, submenu.getID(), sectionWeight);
                    JMenu ephemeral = null;
                    JMenu menu = null;
                    Integer mnemonic = new Integer(submenu.getMnemonic());
                    menu = destructive ? Menubar.getJMenu(submenu.getID()) : (ephemeral = this.get(key));
                    if (menu == null) {
                        menu = menuMgr.createSubMenu(submenu.getLabel(), mnemonic, weight, defaultSection);
                        menu.setIcon(this.getIcon(submenu));
                        MenuManager.putJMenu(submenu.getID(), menu);
                        if (submenu.getLabel() == null) {
                            this.getExtensionLogger().info(submenu.getID() + " has no label and therefore will not be added to the menu bar.");
                        }
                        if (ephemeral == null) {
                            if (submenu.getLabel() != null) {
                                physicalMenu.add(menu, sectionWeight);
                            }
                            if (!destructive) {
                                this.add(key, menu);
                            }
                        }
                    } else {
                        String menuText;
                        Object clientProperty;
                        if (menu.getIcon() == null) {
                            menu.setIcon(this.getIcon(submenu));
                        }
                        if (menu.getClientProperty("menu-weight") == null) {
                            menu.putClientProperty("menu-weight", Float.valueOf(weight));
                        }
                        if (menu.getClientProperty("menu-addin-section-id") == null) {
                            menu.putClientProperty("menu-addin-section-id", Float.valueOf(defaultSection));
                        }
                        if ((clientProperty = menu.getClientProperty("menu-section-id")) instanceof Float && !Float.valueOf(Float.MAX_VALUE).equals(clientProperty)) {
                            sectionWeight = ((Float)clientProperty).floatValue();
                        }
                        if (submenu.getLabel() != null && ((menuText = menu.getText()) == null || menuText.trim().isEmpty())) {
                            menu.setText(StringUtils.stripMnemonic((String)submenu.getLabel()));
                            int keyCodeMnemonic = menuMgr.getKeyboardMnemonic(submenu.getLabel(), mnemonic);
                            if (keyCodeMnemonic != 0) {
                                menu.setMnemonic(keyCodeMnemonic);
                            }
                        }
                        if (menu.getParent() == null && menu.getText() != null && !menu.getText().trim().isEmpty()) {
                            physicalMenu.add(menu, sectionWeight);
                        }
                    }
                    this.addToMenu(new JMenuWrapper(menu), (SectionContainer)submenu, destructive);
                }
                sectionWeight = MenuConstants.increment(sectionWeight);
            }
        }
    }

    private Icon getIcon(Menu submenu) {
        Icon icon = IdeIcons.getIcon((int)23);
        if (submenu.getIcon() != null) {
            try {
                URL url = submenu.getIcon().getURL();
                icon = new ImageIcon(url);
            }
            catch (MissingIconException mie) {
                this.getExtensionLogger().warning(mie.getMessage());
            }
        }
        return icon;
    }

    private void reportRegistrationErrors(String extensionId, List menus) {
        for (Menu menu : menus) {
            this.reportContainerErrors((SectionContainer)menu, extensionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportContainerErrors(SectionContainer modelMenu, String extensionId) {
        List sections;
        List list = sections = modelMenu.getSections();
        synchronized (list) {
            for (Section section : sections) {
                for (Object item : section.getContent()) {
                    if (item instanceof Item) {
                        String actionId = ((Item)item).getActionID();
                        String message = Ide.findCmdID(actionId) == null ? extensionId + ": action id [" + actionId + "] not registered; cannot add action to menu " + modelMenu.getID() + "." : extensionId + ": action id [" + actionId + "] not added to menu " + modelMenu.getID() + ". Action may not be registered.";
                        this.getExtensionLogger().severe(message);
                        continue;
                    }
                    if (!(item instanceof Menu)) continue;
                    Menu submenu = (Menu)item;
                    this.reportContainerErrors((SectionContainer)submenu, extensionId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMenusAndClearModel() {
        Map pullDownMenus;
        ArrayList menus = new ArrayList();
        Map map = pullDownMenus = this.getModel().getMenuBars();
        synchronized (map) {
            MenuBar mainWindowMenu = (MenuBar)pullDownMenus.get("javax.ide.view.MAIN_WINDOW_MENUBAR_ID");
            if (mainWindowMenu != null) {
                List list = mainWindowMenu.getMenus();
                menus.addAll(list);
            }
            pullDownMenus.clear();
        }
        return menus;
    }

    private JMenu getPhysicalMenu(Menu menu) {
        String jsr198ID = menu.getID();
        String jdevID = (String)TL_MENU_ID_MAP.get(jsr198ID);
        if (jdevID == null) {
            jdevID = jsr198ID;
        }
        return MenuManager.getJMenu(jdevID);
    }

    private void registerActions() {
        Map actionMap = this.getModel().getActions();
        for (String id : actionMap.keySet()) {
            Integer cmd = Ide.findCmdID(id);
            if (cmd != null) {
                this.getExtensionLogger().warning("Action with id '" + id + "' is defined both in an extension manifest and " + "programmatically. The programmatic definition wins.");
                return;
            }
            int cmdId = Ide.findOrCreateCmdID(id);
            JSR198Action theAction = new JSR198Action((IDEAction)actionMap.get(id));
            Ide.getIdeActionMap().put(new Integer(cmdId), theAction);
        }
    }

    static {
        TL_MENU_ID_MAP.put("javax.ide.FILE_MENU_ID", "File");
        TL_MENU_ID_MAP.put("javax.ide.EDIT_MENU_ID", "Edit");
        TL_MENU_ID_MAP.put("javax.ide.VIEW_MENU_ID", "View");
        TL_MENU_ID_MAP.put("javax.ide.HELP_MENU_ID", "Help");
        TL_MENU_ID_MAP.put("javax.ide.WINDOW_MENU_ID", "Window");
        STANDARD_SECTIONS.put("javax.ide.OPEN_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.NEW_SECTION_ID", new Float(1.0f));
        STANDARD_SECTIONS.put("javax.ide.CLOSE_SECTION_ID", new Float(MenuConstants.SECTION_FILE_CLOSE));
        STANDARD_SECTIONS.put("javax.ide.PRINT_SECTION_ID", new Float(MenuConstants.SECTION_FILE_PRINT));
        STANDARD_SECTIONS.put("javax.ide.SAVE_SECTION_ID", new Float(MenuConstants.SECTION_FILE_SAVE));
        STANDARD_SECTIONS.put("javax.ide.COPY_PASTE_SECTION_ID", new Float(MenuConstants.SECTION_EDIT_CUT_COPY_PASTE));
        STANDARD_ITEMS.put("javax.ide.OPEN_ACTION_ID", new Float(MenuConstants.WEIGHT_FILE_OPEN));
        STANDARD_ITEMS.put("javax.ide.CUT_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_CUT));
        STANDARD_ITEMS.put("javax.ide.COPY_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_COPY));
        STANDARD_ITEMS.put("javax.ide.PASTE_ACTION_ID", new Float(MenuConstants.WEIGHT_EDIT_PASTE));
    }

    private class MenuActionRegHelper
    implements OnDemandElementVisitorListener {
        private String _extensionId;

        private MenuActionRegHelper() {
        }

        public void starting(String extensionId) {
            List menus;
            boolean extensionChanged;
            boolean bl = extensionChanged = this._extensionId != null && !this._extensionId.equals(extensionId);
            if (extensionChanged && !(menus = OracleActionRegistry.this.getMenusAndClearModel()).isEmpty()) {
                OracleActionRegistry.this.reportRegistrationErrors(this._extensionId, menus);
            }
            this._extensionId = extensionId;
        }

        public void ended(String extensionId) {
            List menus = OracleActionRegistry.this.getMenusAndClearModel();
            if (!menus.isEmpty()) {
                OracleActionRegistry.this.registerTopLevelMenus(menus);
            }
        }
    }

    private class ContextMenuWrapper
    implements PhysicalMenuWrapper {
        private final ContextMenu _contextMenu;

        ContextMenuWrapper(ContextMenu contextMenu) {
            this._contextMenu = contextMenu;
        }

        @Override
        public Object getPhysicalMenu() {
            return this._contextMenu;
        }

        @Override
        public void add(Component item, float sectionId) {
            this._contextMenu.add(item, sectionId);
        }

        @Override
        public float getAddinsSection() {
            return 1000.0f;
        }
    }

    private class JMenuWrapper
    implements PhysicalMenuWrapper {
        private final JMenu _menu;

        JMenuWrapper(JMenu menu) {
            this._menu = menu;
        }

        @Override
        public Object getPhysicalMenu() {
            return this._menu;
        }

        @Override
        public void add(final Component item, final float sectionId) {
            if (SwingUtilities.isEventDispatchThread()) {
                Ide.getMenubar().add(item, this._menu, sectionId);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Ide.getMenubar().add(item, JMenuWrapper.this._menu, sectionId);
                    }
                });
            }
        }

        @Override
        public float getAddinsSection() {
            Object section = this._menu.getClientProperty("menu-addin-section-id");
            if (section instanceof Float) {
                Float id = (Float)section;
                if (!Float.valueOf(Float.MAX_VALUE).equals(id)) {
                    return id.floatValue();
                }
            }
            return 1000.0f;
        }
    }

    private static interface PhysicalMenuWrapper {
        public void add(Component var1, float var2);

        public float getAddinsSection();

        public Object getPhysicalMenu();
    }

    private class MyContextMenuListener
    implements ContextMenuListener {
        private final String _popupId;

        public MyContextMenuListener(String popupId) {
            this._popupId = popupId;
        }

        @Override
        public void menuWillShow(ContextMenu popup) {
            OracleActionRegistry.this.addToContextMenu(popup, this._popupId, OracleActionRegistry.this.getModel());
        }

        @Override
        public void menuWillHide(ContextMenu popup) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class EphemeralMenu {
        private PhysicalMenuWrapper parent;
        private String menuID;
        private float sectionWeight;

        EphemeralMenu(PhysicalMenuWrapper parent, String menuID, float sectionWeight) {
            this.parent = parent;
            this.menuID = menuID;
            this.sectionWeight = sectionWeight;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EphemeralMenu)) {
                return false;
            }
            EphemeralMenu other = (EphemeralMenu)obj;
            return other.sectionWeight == this.sectionWeight && other.menuID.equals(this.menuID) && other.parent.getPhysicalMenu().equals(this.parent.getPhysicalMenu());
        }

        public int hashCode() {
            return this.menuID.hashCode() + (int)this.sectionWeight * 100 + this.parent.getPhysicalMenu().hashCode();
        }
    }
}

