/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class AboutPropertiesPage
extends AboutTablePage {
    private PropertiesLoadingThread _propertyLoader = null;

    public AboutPropertiesPage() {
        this.setName(IdeImplArb.getString(90));
    }

    private TableModel buildPlaceholderTableModel() {
        Vector<String> colNames = AboutPropertiesPage.createColumnNames();
        return AboutPropertiesPage.createTableModel(new Vector(), colNames);
    }

    @Override
    protected TableModel buildTableModel() {
        if (this.isTableModelAvailable()) {
            Vector data = new Vector(90);
            this.loadSystemProperties(data);
            AboutPropertiesPage.buildRuntimeMemoryValues(data);
            return AboutPropertiesPage.createTableModel(data, AboutPropertiesPage.createColumnNames());
        }
        this._propertyLoader = new PropertiesLoadingThread();
        this._propertyLoader.start();
        return this.buildPlaceholderTableModel();
    }

    private void loadSystemProperties(Vector data) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String propName = e.nextElement().toString();
            if (!this.isShown(propName)) continue;
            Vector<String> row = new Vector<String>(2);
            row.add(propName);
            String prop = System.getProperty(propName);
            if (propName.equals("line.separator") && prop != null) {
                StringBuffer newValue = new StringBuffer();
                block5: for (int i = 0; i < prop.length(); ++i) {
                    switch (prop.charAt(i)) {
                        case '\n': {
                            newValue.append("\\n");
                            continue block5;
                        }
                        case '\r': {
                            newValue.append("\\r");
                            continue block5;
                        }
                        default: {
                            newValue.append(prop.charAt(i));
                        }
                    }
                }
                prop = newValue.toString();
            }
            row.add(prop != null ? prop : IdeImplArb.getString(93));
            data.add(row);
        }
    }

    private static void buildRuntimeMemoryValues(Vector data) {
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < 3; ++i) {
            runtime.gc();
            runtime.runFinalization();
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        memoryBean.gc();
        MemoryUsage mUsage = memoryBean.getHeapMemoryUsage();
        AboutPropertiesPage.addData(data, "java.memory.heap.init", Long.toString(mUsage.getInit()));
        AboutPropertiesPage.addData(data, "java.memory.heap.max", Long.toString(mUsage.getMax()));
        AboutPropertiesPage.addData(data, "java.memory.heap.used", Long.toString(mUsage.getUsed()));
        mUsage = memoryBean.getNonHeapMemoryUsage();
        AboutPropertiesPage.addData(data, "java.memory.nonheap.init", Long.toString(mUsage.getInit()));
        AboutPropertiesPage.addData(data, "java.memory.nonheap.max", Long.toString(mUsage.getMax()));
        AboutPropertiesPage.addData(data, "java.memory.nonheap.used", Long.toString(mUsage.getUsed()));
    }

    private static void addData(Vector data, String name, Object value) {
        Vector<Object> row = new Vector<Object>(2);
        row.add(name);
        row.add(value);
        data.add(row);
    }

    private boolean isShown(String propertyName) {
        return !propertyName.toLowerCase().contains("password");
    }

    @Override
    protected boolean isTableModelAvailable() {
        return this._propertyLoader != null && this._propertyLoader.isModelComputed();
    }

    static Vector<String> createColumnNames() {
        Vector<String> colNames = new Vector<String>(2);
        colNames.add(IdeImplArb.getString(91));
        colNames.add(IdeImplArb.getString(92));
        return colNames;
    }

    static TableModel createTableModel(Vector data, Vector<String> colNames) {
        return new GenericBaseTableModel(data, colNames){

            public Comparator getColumnSortComparator(int column) {
                return String.CASE_INSENSITIVE_ORDER;
            }
        };
    }

    class PropertiesLoadingThread
    extends Thread {
        private boolean _modelComputed = false;
        private TableModel _dataModel = null;

        PropertiesLoadingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Vector data = new Vector(90);
            PropertiesLoadingThread propertiesLoadingThread = this;
            synchronized (propertiesLoadingThread) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AboutPropertiesPage.this.loadSystemProperties(data);
            AboutPropertiesPage.buildRuntimeMemoryValues(data);
            this._modelComputed = true;
            propertiesLoadingThread = this;
            synchronized (propertiesLoadingThread) {
                this._dataModel = AboutPropertiesPage.createTableModel(data, AboutPropertiesPage.createColumnNames());
            }
            AboutPropertiesPage.this.dataModelComputed(this._dataModel);
        }

        boolean isModelComputed() {
            return this._modelComputed;
        }

        TableModel getDataModel() {
            return this._dataModel;
        }
    }
}

