/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public final class ExtensionPreferences
extends HashStructureAdapter {
    @GuardedBy(value="ExtensionPreferences.class")
    private static ExtensionPreferences _prefs;
    private static final String DISABLED_EXTENSION_IDS = "disabledExtensions";
    private static final String RESET_FEATURE_LOADING_CACHE = "resetFeatueLoadingCache";
    private static final String FEATURES_TO_RELOAD_AT_STARTUP = "featuresToReloadAtStartup";
    private final URL _url;

    private ExtensionPreferences(HashStructure hs) {
        this(hs, null);
    }

    private ExtensionPreferences(HashStructure hs, URL url) {
        super(hs);
        this._url = url;
    }

    public Set<String> getDisabledIds() {
        ListStructure ls = this._hash.getListStructure(DISABLED_EXTENSION_IDS);
        if (ls == null) {
            return Collections.emptySet();
        }
        HashSet s = new HashSet();
        s.addAll(ls);
        return Collections.unmodifiableSet(s);
    }

    public void setDisabledIds(Set<String> disabledIds) {
        ListStructure ls = this._hash.getOrCreateListStructure(DISABLED_EXTENSION_IDS);
        ls.clear();
        ls.addAll(disabledIds);
    }

    public void resetFeatureLoadingCache() {
        this._hash.putBoolean(RESET_FEATURE_LOADING_CACHE, true);
    }

    public Set<String> getFeatureIdsToReloadAtStartup() {
        ListStructure ls = this._hash.getListStructure(FEATURES_TO_RELOAD_AT_STARTUP);
        if (ls == null) {
            return Collections.emptySet();
        }
        HashSet s = new HashSet();
        s.addAll(ls);
        return Collections.unmodifiableSet(s);
    }

    public void setFeatureIdsToReloadAtStartup(Set<String> featureIds) {
        ListStructure ls = this._hash.getOrCreateListStructure(FEATURES_TO_RELOAD_AT_STARTUP);
        ls.clear();
        ls.addAll(featureIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionPreferences getInstance() {
        Class<ExtensionPreferences> clazz = ExtensionPreferences.class;
        synchronized (ExtensionPreferences.class) {
            if (_prefs == null) {
                URL dir = URLFactory.newDirURL((String)Ide.getSystemDirectory());
                URL file = URLFactory.newURL((URL)dir, (String)"ide-extension-prefs.xml");
                HashStructure hash = HashStructure.newInstance();
                _prefs = new ExtensionPreferences(hash, file);
                try {
                    _prefs.open();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _prefs;
        }
    }

    private void open() throws IOException {
        HashStructureIO io = ExtensionPreferences.getIO();
        if (URLFileSystem.exists((URL)this._url)) {
            io.open(this._url, (Object)this._hash);
            this.maybeClearFeatureCache();
        }
    }

    private void maybeClearFeatureCache() {
        if (this._hash.containsKey(RESET_FEATURE_LOADING_CACHE)) {
            this._hash.remove(RESET_FEATURE_LOADING_CACHE);
            this._hash.remove(FEATURES_TO_RELOAD_AT_STARTUP);
        }
    }

    public void save() throws IOException {
        ExtensionPreferences.getIO().save(this._url, (Object)this._hash);
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:extension-preferences");
    }
}

