/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.config;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;

public final class ProductStartupFeatures {
    private static final String _STARTUP_FEATURE_SYSTEM_PROPERTY = "oracle.ide.startup.features";
    private static final String _LEGACY_PRODUCT_CORE_EXTENSIONS_PROPERTY = "oracle.ide.productcore.extensions";
    private static Logger _sLogger = null;

    public static Set<Feature> getStartupFeatures(FeatureRegistry registry) {
        String extensionsProperty;
        LinkedHashSet<Feature> startupFeatureSet = new LinkedHashSet<Feature>();
        ProductStartupFeatures._addFeature(registry, startupFeatureSet, "ide-core", true);
        ProductStartupFeatures._addFeature(registry, startupFeatureSet, "xml-core", false);
        String propertyValue = System.getProperty(_STARTUP_FEATURE_SYSTEM_PROPERTY);
        if (propertyValue != null) {
            String[] featureIds;
            for (String featureId : featureIds = propertyValue.split(",")) {
                if (featureId == null || (featureId = featureId.trim()).length() <= 0) continue;
                ProductStartupFeatures._addFeature(registry, startupFeatureSet, featureId, true);
            }
        }
        if ((extensionsProperty = System.getProperty(_LEGACY_PRODUCT_CORE_EXTENSIONS_PROPERTY)) != null) {
            String[] groups;
            ProductStartupFeatures._logDeprecationWarning(extensionsProperty);
            for (String group : groups = extensionsProperty.split("\\|")) {
                String[] groupIdAndPath = group.split("@");
                if (groupIdAndPath.length <= 1) continue;
                String groupId = groupIdAndPath[0];
                ProductStartupFeatures._addFeature(registry, startupFeatureSet, groupId, true);
            }
        }
        return startupFeatureSet;
    }

    private static void _addFeature(FeatureRegistry registry, Set<Feature> featureSet, String featureId, boolean logIfMissing) {
        Feature feature = registry.getFeature(featureId);
        if (feature != null) {
            featureSet.add(feature);
        } else if (logIfMissing) {
            ProductStartupFeatures._getLogger().log(Level.SEVERE, "Startup feature missing or invalid. The product was configured to load feature '" + featureId + "' on startup, but no feature with that id was found. Exiting because this is " + "a severe configuration error.");
            System.exit(1);
        }
    }

    private static void _logDeprecationWarning(String value) {
        StringBuffer message = new StringBuffer();
        message.append("Deprecated system property: ");
        message.append(_LEGACY_PRODUCT_CORE_EXTENSIONS_PROPERTY);
        message.append(" is being set to value: ");
        message.append(value);
        message.append(". Please use the replacement system property: ");
        message.append(_STARTUP_FEATURE_SYSTEM_PROPERTY);
        ProductStartupFeatures._getLogger().log(Level.WARNING, message.toString());
    }

    private static Logger _getLogger() {
        if (_sLogger == null) {
            _sLogger = Logger.getLogger(ProductStartupFeatures.class.getName());
        }
        return _sLogger;
    }

    private ProductStartupFeatures() {
    }
}

