/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.progress.ProgressManager;
import javax.ide.util.MetaClass;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.migration.MigrationManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.util.AddinPolicyUtils;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.AddinsHook;

public final class AddinManagerImpl
extends AddinManager {
    private final Map<String, Addin> _addinInstancesByClassName = new LinkedHashMap<String, Addin>();
    private List<AddinInfo> _addinInfos = null;
    private Properties _properties = null;
    private volatile boolean _isInitializingProductAndUserAddins = false;
    private static AddinManagerImpl _instance = new AddinManagerImpl();

    public static AddinManager createInstance() {
        return _instance;
    }

    @Override
    public final Properties getProductProperties() {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        return this._properties;
    }

    List<AddinInfo> getAddinInfos() {
        if (this._addinInfos == null) {
            this._addinInfos = new ArrayList<AddinInfo>();
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            AddinsHook hook = (AddinsHook)er.getHook(AddinsHook.ELEMENT);
            if (hook != null) {
                this._addinInfos.addAll(hook.getAddinInfos());
            }
        }
        return Collections.unmodifiableList(this._addinInfos);
    }

    @Override
    protected final synchronized void initProductAndUserAddins() {
        this.initProductAndUserAddins(null);
    }

    protected final synchronized void initProductAndUserAddins(TaskMonitor ts) {
        this._isInitializingProductAndUserAddins = true;
        try {
            AddinPolicyUtils.initializingAddins((boolean)true);
            this.initializeAddins(ts, null);
        }
        finally {
            this._isInitializingProductAndUserAddins = false;
            AddinPolicyUtils.initializingAddins((boolean)false);
        }
    }

    protected final boolean isInitializingProductAndUserAddins() {
        return this._isInitializingProductAndUserAddins;
    }

    @Override
    public synchronized void initAddinLoadset(String loadsetName) {
        this.initAddinLoadset(null, loadsetName);
    }

    public synchronized void initAddinLoadset(TaskMonitor ts, String loadsetName) {
        if (loadsetName == null) {
            throw new NullPointerException("loadsetName is null");
        }
        try {
            PerformanceLogger.get().startTiming("addinLoadSet_" + loadsetName, "Initializing Addin loadset " + loadsetName + "...");
            this.initializeAddins(ts, loadsetName);
        }
        finally {
            PerformanceLogger.get().stopTiming("addinLoadSet_" + loadsetName, "Initialized Addin loadset " + loadsetName);
        }
    }

    private int getCurrentNumberOfClasses() {
        if (Version.DEBUG_BUILD != 0) {
            try {
                Field f = ClassLoader.class.getDeclaredField("classes");
                f.setAccessible(true);
                Vector classes = (Vector)f.get(Thread.currentThread().getContextClassLoader());
                return classes.size();
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    private static boolean isIdeHeadless() {
        return !Ide.getIdeArgs().getCreateUI();
    }

    private static boolean isAddinLoadable(AddinInfo info, String loadSetName) {
        if (info.hasUI() && AddinManagerImpl.isIdeHeadless()) {
            return false;
        }
        return loadSetName == null && info.getLoadSet() == null || loadSetName != null && loadSetName.equals(info.getLoadSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAddins(TaskMonitor ts, String loadSetName) {
        int currentCount = 1;
        List<AddinInfo> addins = this.getAddinInfos();
        if (ts == null) {
            ProgressManager.finalizeProgress((String)"initializing", (int)addins.size());
        }
        int addinCount = this.getAddinInfos().size();
        Iterator<AddinInfo> i = addins.iterator();
        while (i.hasNext()) {
            ++currentCount;
            AddinInfo info = i.next();
            try {
                if (!AddinManagerImpl.isAddinLoadable(info, loadSetName)) continue;
                int numClasses = this.getCurrentNumberOfClasses();
                try {
                    if (!this.createAddin(info)) continue;
                    String className = info.getClassName();
                    if (ts != null) {
                        int progress = (int)((float)currentCount * 100.0f) / addinCount;
                        ts.fireProgress(new ProgressEvent(ts.getSource(), progress, 0L, new String[]{info.getClassName()}));
                        this.initializeAddin(ts, info, this.getAddin(className));
                        continue;
                    }
                    ProgressManager.updateProgressDescription((String)"initializing", (String)className, (int)1);
                    this.initializeAddin(info, this.getAddin(className));
                }
                finally {
                    int classesLoaded = this.getCurrentNumberOfClasses() - numClasses;
                    info.setClassesLoaded(classesLoaded);
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                Logger.getLogger(AddinManagerImpl.class.getName()).log(Level.SEVERE, "Exception initializing '" + info.getClassName() + "' in extension '" + info.getExtension().getName(), t);
            }
        }
    }

    @Override
    public synchronized boolean registerAddin(String clazz) {
        AddinInfo info = new AddinInfo(Thread.currentThread().getContextClassLoader(), clazz);
        if (this.createAddin(info)) {
            this.getAddinInfos();
            this._addinInfos.add(info);
            this.initializeAddin(info, this.getAddin(clazz));
            return true;
        }
        return false;
    }

    @Override
    public final String getCommand(String commandName, String defaultCommand) {
        if (commandName == null) {
            return null;
        }
        Properties props = this.getProductProperties();
        String command = props.getProperty(commandName, defaultCommand);
        return command;
    }

    @Override
    public final String getCommand(int commandID, String defaultCommand) {
        String commandName = Ide.findCmdName(commandID);
        if (commandName == null) {
            return defaultCommand;
        }
        return this.getCommand(commandName, defaultCommand);
    }

    @Override
    public synchronized <T extends Addin> T getAddin(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is null");
        }
        Addin addin = this._addinInstancesByClassName.get(clazz.getName());
        if (addin == null && clazz.isInterface()) {
            Iterator<String> i = this._addinInstancesByClassName.keySet().iterator();
            while (i.hasNext()) {
                try {
                    String className = i.next();
                    Addin storedAddin = this._addinInstancesByClassName.get(className);
                    Class<?> instanceClass = storedAddin.getClass();
                    if (!clazz.isAssignableFrom(instanceClass)) continue;
                    this._addinInstancesByClassName.put(clazz.getName(), storedAddin);
                    addin = storedAddin;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return (T)addin;
    }

    @Override
    public Addin getAddin(String className) {
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        return this._addinInstancesByClassName.get(className);
    }

    public final void addCommand(String name, String clazz) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.setProperty(name, clazz);
    }

    @Override
    public void initialize() {
        MigrationManager mgr = MigrationManager.getMigrationManager();
        if (mgr != null) {
            mgr.migrate();
        }
    }

    private AddinManagerImpl() {
    }

    private void initializeAddin(AddinInfo info, Addin addin) {
        this.initializeAddin(null, info, addin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAddin(TaskMonitor ts, AddinInfo info, Addin addin) {
        long start = System.nanoTime();
        try {
            addin.initialize();
        }
        finally {
            long nanoElapsed = System.nanoTime() - start;
            info.addTimeToLoad(nanoElapsed);
            PerformanceLogger.get().log("Addin.initialize", info.getClassName(), info.getTimeToLoad());
            info.setLoaded(true);
        }
    }

    protected void initializeAddin(AddinInfo info) {
        if (AddinManagerImpl.isAddinLoadable(info, info.getLoadSet())) {
            try {
                if (this._addinInfos == null) {
                    throw new IllegalStateException("Trying to initialize an addin, " + info.getClassName() + " " + "before the addin manager has the list of all addins. This can happen, particularly on " + "start-up, when the IDE is attempting to load a class from an extension that is not part " + "of a start-up feature list");
                }
                this._addinInfos.add(info);
                if (this.createAddin(info)) {
                    this.initializeAddin(info, this.getAddin(info.getClassName()));
                }
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                System.err.print("Exception initializing '" + info.getClassName() + "' in extension '" + info.getExtension().getName() + "': ");
                t.printStackTrace();
            }
        }
    }

    private boolean createAddin(AddinInfo addin) {
        String className = addin.getClassName();
        Addin instance = this.getAddin(className);
        if (instance == null) {
            Class addinClass = null;
            try {
                long start = System.nanoTime();
                addinClass = new MetaClass(addin.getClassLoader(), className).toClass();
                long elapsed = System.nanoTime() - start;
                addin.addTimeToLoad(elapsed);
            }
            catch (ClassNotFoundException cnfe) {
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Addin " + className + " does not exist.", addin.getExtension(), addin.getManifestLineNumber(), (Throwable)cnfe));
                return false;
            }
            catch (NoClassDefFoundError ncdfe) {
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "No class def found for addin " + className, addin.getExtension(), addin.getManifestLineNumber(), (Throwable)ncdfe));
                return false;
            }
            try {
                Constructor ctor = addinClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                long start = System.nanoTime();
                instance = (Addin)ctor.newInstance(new Object[0]);
                long elapsed = System.nanoTime() - start;
                addin.addTimeToLoad(elapsed);
                this._addinInstancesByClassName.put(className, instance);
                return true;
            }
            catch (NoSuchMethodException nsme) {
                ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Addin " + className + " does not have a no-argument constructor", addin.getExtension(), addin.getManifestLineNumber(), (Throwable)nsme));
            }
            catch (InvocationTargetException ite) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Failed to create addin " + className, addin.getExtension(), addin.getManifestLineNumber(), (Throwable)ite));
            }
            catch (IllegalAccessException ie) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Failed to create addin " + className, addin.getExtension(), addin.getManifestLineNumber(), (Throwable)ie));
            }
            catch (InstantiationException ine) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Failed to create addin " + className, addin.getExtension(), addin.getManifestLineNumber(), (Throwable)ine));
            }
        }
        return false;
    }

    void setProperty(String name, String value) {
        if (this._properties == null) {
            this._properties = new Properties();
        }
        this._properties.setProperty(name, value);
    }

    @Override
    public Extension getExtensionForAddin(Addin addin) {
        if (addin == null) {
            throw new NullPointerException("addin is null");
        }
        AddinInfo info = this.findAddinInfo(addin);
        if (info == null) {
            throw new IllegalArgumentException("Unregistered addin:" + addin);
        }
        return info.getExtension();
    }

    private AddinInfo findAddinInfo(Addin addin) {
        return this.findAddinInfo(addin.getClass().getName());
    }

    private AddinInfo findAddinInfo(String className) {
        for (AddinInfo ai : this.getAddinInfos()) {
            if (!className.equals(ai.getClassName())) continue;
            return ai;
        }
        return null;
    }

    @Override
    public boolean isRegisteredAddin(String addinClass) {
        return this.findAddinInfo(addinClass) != null;
    }
}

