/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.RecentFilesDockableWindow;
import oracle.ideimpl.editor.RecentFilesLRUProvider;
import oracle.javatools.dialogs.MessageDialog;

public final class RecentFilesLRU {
    private final int LRU_FILES_SIZE;
    private AtomicInteger explicitCount = new AtomicInteger();
    private static final ViewId RECENT_FILES_VIEWID = new ViewId("Applicationoracle_ideimpl_editor_RecentFiles_VIEW_TYPE", "Applicationoracle_ideimpl_editor_RecentFiles_VIEW_NAME");
    private final ArrayList _windows = new ArrayList();

    public RecentFilesLRU() {
        String property = Ide.getProperty("Editors.RecentFilesSize", "20");
        this.LRU_FILES_SIZE = Integer.parseInt(property);
    }

    public void setExplicit(Context context, boolean explicit) {
        if (context == null) {
            return;
        }
        Node node = context.getNode();
        if (node == null || !URLFileSystem.isLocal((URL)node.getURL()) || !URLFileSystem.exists((URL)node.getURL())) {
            return;
        }
        RecentFile recentFile = this.getRecentFile(context);
        if (recentFile != null) {
            boolean wasExplicit = recentFile.isExplicit();
            if (wasExplicit) {
                this.explicitCount.decrementAndGet();
            }
            recentFile.setExplicit(explicit);
            if (explicit) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private void adjustSize() {
        int expCount = this.explicitCount.get();
        if (expCount > this.LRU_FILES_SIZE) {
            this.removeOldest(true);
        } else {
            int lruSize = this.getLRUList().size();
            int implicitCount = lruSize - expCount;
            if (implicitCount > this.LRU_FILES_SIZE) {
                this.removeOldest(false);
            }
        }
    }

    private void removeOldest(final boolean removeExplicit) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorManager editorManager = EditorManager.getEditorManager();
                final ArrayList lruFiles = RecentFilesLRU.this.getLRUList();
                for (int index = 0; index < lruFiles.size(); ++index) {
                    RecentFile recentFile = (RecentFile)((Object)lruFiles.get(index));
                    boolean explicit = recentFile.isExplicit();
                    boolean urlExists = RecentFilesLRU.this.removeNonExistingRecentFile(recentFile, lruFiles);
                    if (!urlExists) continue;
                    boolean canRemove = true;
                    URL recentFileURL = recentFile.getNodeURL();
                    if (recentFileURL != null) {
                        List<Editor> editors = editorManager.getAllEditors();
                        for (Editor editor : editors) {
                            Context context = editor.getContext();
                            if (context == null || context.getNode() == null || context.getNode().getURL() == null) continue;
                            URL editorUrl = context.getNode().getURL();
                            if (recentFileURL == null || !recentFileURL.equals(editorUrl)) continue;
                            canRemove = false;
                            break;
                        }
                    }
                    if (explicit != removeExplicit || !canRemove) continue;
                    RecentFilesLRU.this.removeRecentFile(recentFile, lruFiles);
                    break;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        RecentFilesLRU.this.setLRUList(lruFiles);
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        new Thread(runnable).start();
    }

    public RecentFile[] getRecentFiles() {
        return this.getRecentFiles(true);
    }

    public RecentFile[] getRecentFiles(boolean includeOpen) {
        ArrayList lruFiles = this.getLRUList();
        Collections.reverse(lruFiles);
        if (!includeOpen) {
            Collection<URL> openURLs = EditorManager.getEditorManager().getAllUrlEditors();
            Iterator it = lruFiles.iterator();
            while (it.hasNext()) {
                if (!openURLs.contains(((RecentFile)((Object)it.next())).getNodeURL())) continue;
                it.remove();
            }
        }
        return lruFiles.toArray(new RecentFile[lruFiles.size()]);
    }

    public void raiseContextInLRUList(Context context, String editorAddinClassName) {
        Node node;
        if (context != null && (node = context.getNode()) != null) {
            if (!URLFileSystem.isLocal((URL)node.getURL()) || !URLFileSystem.exists((URL)node.getURL())) {
                return;
            }
            RecentFile recentFile = this.remove(context);
            if (recentFile == null) {
                recentFile = new RecentFile(context);
            }
            if (editorAddinClassName != null) {
                recentFile.setEditor(editorAddinClassName);
            }
            recentFile.setNodeClass(node.getClass().getName());
            ArrayList lruFiles = this.getLRUList();
            lruFiles.add(recentFile);
            RemovedFileTracker.addListener(recentFile.getNodeURL(), this);
            this.setLRUList(lruFiles);
            if (recentFile.isExplicit()) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private ArrayList getLRUList() {
        EditorsOptions editorsOptions = EditorManagerImpl.getEditorsOptions();
        ArrayList<RecentFile> lruFiles = editorsOptions.getLruFiles();
        RemovedFileTracker.addListeners(lruFiles, this);
        this.explicitCount.set(0);
        for (int i = 0; i < lruFiles.size(); ++i) {
            RecentFile recentFile = lruFiles.get(i);
            if (!recentFile.isExplicit()) continue;
            this.explicitCount.incrementAndGet();
        }
        return lruFiles;
    }

    final void addWindow(RecentFilesDockableWindow window) {
        this._windows.add(window);
    }

    private void setLRUList(ArrayList lruList) {
        RemovedFileTracker.addListeners(lruList, this);
        EditorsOptions editorsOptions = EditorManagerImpl.getEditorsOptions();
        editorsOptions.setLruFiles(lruList);
        Runnable recentUpdater = new Runnable(){

            @Override
            public void run() {
                for (RecentFilesDockableWindow window : RecentFilesLRU.this._windows) {
                    window.updateGUI();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            recentUpdater.run();
        } else {
            SwingUtilities.invokeLater(recentUpdater);
        }
    }

    private int getPositionInLRUList(Context context, ArrayList lruList) {
        if (context != null) {
            for (int i = 0; i < lruList.size(); ++i) {
                RecentFile recentFile = (RecentFile)((Object)lruList.get(i));
                if (!recentFile.isSameNode(context)) continue;
                return i;
            }
        }
        return -1;
    }

    public RecentFile getRecentFile(Context context) {
        if (context != null) {
            ArrayList lruList = this.getLRUList();
            for (RecentFile recentFile : lruList) {
                if (!recentFile.isSameNode(context)) continue;
                return recentFile;
            }
        }
        return null;
    }

    RecentFile remove(Context context) {
        Node node = context.getNode();
        if (node != null && !URLFileSystem.isLocal((URL)node.getURL())) {
            return null;
        }
        RecentFile ret = null;
        ArrayList lruList = this.getLRUList();
        int index = this.getPositionInLRUList(context, lruList);
        if (index >= 0) {
            ret = (RecentFile)((Object)lruList.remove(index));
            RemovedFileTracker.removeListener(ret.getNodeURL());
            this.setLRUList(lruList);
            if (ret.isExplicit()) {
                this.explicitCount.decrementAndGet();
            }
        }
        return ret;
    }

    private boolean removeNonExistingRecentFile(RecentFile recentFile, List recentFiles) {
        boolean urlExists = true;
        URL nodeURL = recentFile.getNodeURL();
        urlExists = nodeURL == null ? false : URLFileSystem.exists((URL)nodeURL);
        if (!urlExists) {
            this.removeRecentFile(recentFile, recentFiles);
        }
        return urlExists;
    }

    private void removeRecentFile(RecentFile recentFile, List recentFiles) {
        recentFiles.remove((Object)recentFile);
        RemovedFileTracker.removeListener(recentFile.getNodeURL());
        if (recentFile.isExplicit()) {
            this.explicitCount.decrementAndGet();
        }
    }

    public void openRecentFile(RecentFile recentFile) {
        if (recentFile != null) {
            if (URLFileSystem.exists((URL)recentFile.getNodeURL())) {
                Context context = recentFile.getContext();
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(8, true);
                editorManager.openEditor(openEditorOptions);
            } else {
                URL url = recentFile.getNodeURL();
                Node node = this.getErasedFileNode(url);
                if (node != null) {
                    RecentFilesLRU recentFilesLRU = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU();
                    recentFilesLRU.remove(new Context(node));
                    MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)(URLFileSystem.getPlatformPathName((URL)url) + " does not exist."), (String)"File not Found", null);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dockable recentFilesDockable = DockStation.getDockStation().getDockable(RECENT_FILES_VIEWID);
                        if (recentFilesDockable == null) {
                            return;
                        }
                        ((RecentFilesDockableWindow)recentFilesDockable).updateGUI();
                    }
                });
            }
        }
    }

    private Node getErasedFileNode(URL url) {
        try {
            Node node = NodeFactory.findOrCreate(url);
            NodeFactory.uncache(url, false);
            return node;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public void reopenRecentFiles(URL workspaceURL) {
        if (Ide.isStarting() || Ide.isQuitting() || workspaceURL == null) {
            return;
        }
        ArrayList lruFiles = this.getLRUList();
        if (lruFiles == null || lruFiles.isEmpty()) {
            return;
        }
        Collections.reverse(lruFiles);
        for (RecentFile recentFile : lruFiles) {
            if (recentFile.getNodeURL() == null || !URLFileSystem.equals((URL)workspaceURL, (URL)recentFile.getWorkspaceURL())) continue;
            if (recentFile.isReopen()) {
                this.openRecentFile(recentFile);
            }
            recentFile.setReopen(false);
        }
    }

    public void flushRecentFiles() {
        this.setLRUList(new ArrayList(0));
    }

    private static class RemovedFileTracker
    implements URLFileSystemListener {
        private static Map<String, RemovedFileTracker> trackerMap = new HashMap<String, RemovedFileTracker>();
        private URL url;
        private URL parent;
        private boolean attached;
        private RecentFilesLRU lru;

        public static void addListeners(List recentFiles, RecentFilesLRU lru) {
            if (trackerMap.isEmpty()) {
                for (Object recentFile : recentFiles) {
                    RemovedFileTracker.addListener(((RecentFile)((Object)recentFile)).getNodeURL(), lru);
                }
            }
        }

        public static void addListener(URL url, RecentFilesLRU lru) {
            String key;
            if (url != null && trackerMap.get(key = url.toString()) == null) {
                trackerMap.put(key, new RemovedFileTracker(url, lru).attach());
            }
        }

        public static void removeListener(URL url) {
            String key = url.toString();
            RemovedFileTracker tracker = trackerMap.get(key);
            if (tracker != null) {
                tracker.dettach();
                trackerMap.remove(key);
            }
        }

        RemovedFileTracker(URL url, RecentFilesLRU lru) {
            this.lru = lru;
            this.url = url;
            this.parent = URLFileSystem.getParent((URL)url);
        }

        public RemovedFileTracker attach() {
            if (!this.attached) {
                URLFileSystem.addURLFileSystemListener((URL)this.parent, (URLFileSystemListener)this);
                this.attached = true;
            }
            return this;
        }

        public RemovedFileTracker attachTo(URL url) {
            if (!URLFileSystem.equals((URL)this.url, (URL)url)) {
                this.dettach();
                this.url = url;
                this.parent = URLFileSystem.getParent((URL)url);
                return this.attach();
            }
            return this;
        }

        public RemovedFileTracker dettach() {
            if (this.attached) {
                URLFileSystem.removeURLFileSystemListener((URL)this.parent, (URLFileSystemListener)this);
                this.attached = false;
            }
            return this;
        }

        public void notifyEvent(URLFileSystemEvent event) {
            switch (event.getEventType()) {
                case 3: {
                    if (!URLFileSystem.equals((URL)this.url, (URL)event.getURL())) break;
                    this.removeFileFromList(event.getURL());
                    this.dettach();
                    break;
                }
                case 4: {
                    if (!URLFileSystem.equals((URL)this.url, (URL)event.getOldURL())) break;
                    this.renameFileInList(event.getOldURL(), event.getNewURL());
                    this.attachTo(event.getNewURL());
                }
            }
        }

        private void removeFileFromList(URL url) {
            ArrayList lruList = this.lru.getLRUList();
            int size = lruList.size();
            for (int i = 0; i < size; ++i) {
                RecentFile recentFile = (RecentFile)((Object)lruList.get(i));
                if (recentFile == null || !URLFileSystem.equals((URL)recentFile.getNodeURL(), (URL)url)) continue;
                lruList.remove(i);
                this.lru.setLRUList(lruList);
                break;
            }
        }

        private void renameFileInList(URL oldurl, URL newurl) {
            ArrayList lruList = this.lru.getLRUList();
            int size = lruList.size();
            for (int i = 0; i < size; ++i) {
                RecentFile recentFile = (RecentFile)((Object)lruList.get(i));
                if (recentFile == null || !URLFileSystem.equals((URL)recentFile.getNodeURL(), (URL)oldurl)) continue;
                recentFile.setNodeURL(newurl);
                this.lru.setLRUList(lruList);
                break;
            }
        }
    }
}

