/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.editor.DynamicEditorHookRegistration;
import oracle.ideimpl.editor.EditorHookRegistration;
import oracle.javatools.data.HashStructure;

final class EditorHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "editors");
    private final Collection<EditorHookRegistration> editors = new CopyOnWriteArrayList<EditorHookRegistration>();
    private final Collection<DynamicEditorHookRegistration> dynamicEditors = new CopyOnWriteArrayList<DynamicEditorHookRegistration>();

    public EditorHook() {
        super(true);
        this.populateEditors(this.getHashStructure());
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                EditorHook.this.populateEditors(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
            }
        });
    }

    private void populateEditors(HashStructure hs) {
        this.editors.addAll(EditorHook.registeredEditors(hs));
        this.dynamicEditors.addAll(EditorHook.registeredDynamicEditors(hs));
    }

    public Collection<EditorHookRegistration> getRegisteredEditors() {
        return Collections.unmodifiableCollection(this.editors);
    }

    private static Collection<EditorHookRegistration> registeredEditors(HashStructure hs) {
        List list = hs.getAsList("editor");
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<EditorHookRegistration> registrations = new ArrayList<EditorHookRegistration>(list.size());
        for (HashStructure hash : list) {
            if (!EditorHook.isValid(hash)) continue;
            registrations.add(new EditorHookRegistration(hash));
        }
        return Collections.unmodifiableList(registrations);
    }

    private static boolean isValid(HashStructure editor) {
        return editor != null && EditorHook.hasValue(editor.getString("id")) && EditorHook.hasValue(editor.getString("label")) && EditorHook.hasValue(editor.getString("editor-class")) && EditorHook.hasItems(editor, "node-type", "class");
    }

    private static boolean hasItems(HashStructure hs, String listName, String attributeName) {
        List l = hs.getAsList(listName);
        if (l != null) {
            for (HashStructure h : l) {
                if (EditorHook.hasValue(h.getString(attributeName))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean hasValue(String v) {
        return v != null && v.length() > 0;
    }

    public Collection<DynamicEditorHookRegistration> getRegisteredDynamicEditors() {
        return Collections.unmodifiableCollection(this.dynamicEditors);
    }

    private static Collection<DynamicEditorHookRegistration> registeredDynamicEditors(HashStructure hs) {
        List list = hs.getAsList("dynamic-editor");
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<DynamicEditorHookRegistration> registrations = new ArrayList<DynamicEditorHookRegistration>(list.size());
        for (HashStructure hash : list) {
            DynamicEditorHookRegistration editor = new DynamicEditorHookRegistration(hash);
            registrations.add(editor);
        }
        return Collections.unmodifiableList(registrations);
    }
}

