/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.docking.AbstractDockPanelDragListener;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;

public class TitledPanelTabDragListener
extends AbstractDockPanelDragListener {
    protected TitledPanelHolder _source;

    protected TitledPanelTabDragListener(TitledPanelHolder source) {
        super(source);
        this._source = source;
    }

    @Override
    protected boolean isDraggingTab() {
        return true;
    }

    @Override
    protected DockInsertionPoint getDockInsertionPoint(DragComponentEvent e) {
        DockLayoutConstraint dlc;
        JComponent compMoved;
        DockInsertionPoint dip = null;
        if (0 == (e.getModifiers() & 2) && (dip = DockStationImpl.getInstance().getDockInsertionAt(e.getPoint())) != null && !DockPanel.canDock(compMoved = this._source.getComponent(), dlc = dip.createConstraint())) {
            dip = null;
        }
        return dip;
    }

    @Override
    protected void dragComponent(DragComponentEvent e) {
    }

    @Override
    protected void dropComponent(DragComponentEvent e) {
        DockInsertionPoint dip = this.getDockInsertionPoint(e);
        if (dip == null) {
            this.floatComponent(e);
        } else if (dip.getOrientation() != 4) {
            this.dockComponent(dip);
        } else {
            this.dockCenterComponent(dip);
        }
        JComponent component = this._source.getOrCreateComponent();
        component.setVisible(true);
    }

    private void floatComponent(DragComponentEvent e) {
        int flags = 12;
        DockStationImpl dockStation = DockStationImpl.getInstance();
        Rectangle r = this.getFloatingRect(e);
        Dockable dockable = this._source.getDockable();
        dockStation.undock(dockable, flags);
        DockingParam dockingParam = new DockingParam();
        Point location = r.getLocation();
        Site site = dockable.getSite();
        Dimension size = site.geometry.getSize();
        Rectangle floatingPosition = new Rectangle(location.x, location.y, size.width, size.height);
        dockingParam.setFloatingPosition(floatingPosition);
        dockingParam.setFloatOnTop(this._source.getFloatOnTop());
        dockStation.dock(dockable, dockingParam, flags);
        dockStation.setDockableVisible(dockable, true, flags);
        dockStation.activateDockable(dockable);
    }

    protected void dockComponent(DockInsertionPoint dip) {
        DockStationImpl ds = DockStationImpl.getInstance();
        DockPanel dp = (DockPanel)dip.getContainer();
        Dockable dockable = this._source.getDockable();
        int flags = 12;
        ds.undock(dockable, flags);
        TitledPanel tp = ds._dock(dockable, dp, dip.createConstraint(), true, flags);
        tp.activate();
        dp.validate();
    }

    protected void dockCenterComponent(DockInsertionPoint dip) {
        TitledPanel tpTarget = (TitledPanel)dip.getCenterReferenceComponent();
        DockStationImpl ds = DockStationImpl.getInstance();
        Dockable dockable = this._source.getDockable();
        ds.undock(dockable, 12);
        tpTarget.addClient(dockable, true, 12);
        tpTarget.activateDockable(dockable);
        tpTarget.getParent().validate();
    }
}

