/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.window.WindowSelector;

@Deprecated
final class DockableSelector
extends WindowSelector {
    private static final DockableSelector INSTANCE = new DockableSelector();
    private List _dockableList;
    private List<Editor> _editorList;

    private DockableSelector() {
    }

    public static DockableSelector getInstance() {
        return INSTANCE;
    }

    void selectNext(List dockableList) {
        this.initialize(dockableList);
        this.selectNextItem();
    }

    void selectPrevious(List dockableList) {
        this.initialize(dockableList);
        this.selectPreviousItem();
    }

    public int sizeOfDisplayables() {
        return EditorManager.getEditorManager().getAllEditors().size() + DockStationImpl.getInstance().getVisibleDockablePaths().size();
    }

    @Override
    protected Displayable[] getDisplayables() {
        assert (this._dockableList != null);
        Displayable[] displayables = new Displayable[this._dockableList.size() + this._editorList.size()];
        int index = 0;
        for (DockablePath dockablePath : this._dockableList) {
            final Dockable dockable = dockablePath.getDockable();
            DefaultDisplayable displayable = new DefaultDisplayable(){

                @Override
                public String getShortLabel() {
                    return dockable.getTitleName();
                }

                @Override
                public Icon getIcon() {
                    return dockable.getTabIcon();
                }
            };
            displayables[index++] = displayable;
        }
        for (Editor editor : this._editorList) {
            displayables[index++] = editor.getContext().getNode();
        }
        return displayables;
    }

    @Override
    protected void activateSelectedWindow() {
        if (this._dockableList != null) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < this._dockableList.size()) {
                DockablePath dockablePath = (DockablePath)this._dockableList.get(selectedIndex);
                Dockable dockable = dockablePath.getDockable();
                DockStationImpl.getInstance().activateDockable(dockable);
            } else {
                Editor selectedEditor = this._editorList.get(selectedIndex -= this._dockableList.size());
                EditorInfo selectedEditorInfo = this.findEditorInfo(selectedEditor);
                EditorManager.getEditorManager().activateEditor(selectedEditorInfo);
                EditorManagerImpl.getInstance().focusCurrentEditorTab();
            }
            this.dispose();
        }
    }

    private EditorInfo findEditorInfo(Editor editor) {
        List<EditorInfo> editorInfos = EditorManager.getEditorManager().getEditorsInfo();
        for (EditorInfo info : editorInfos) {
            if (info._getEditor() == null || !info._getEditor().equals(editor)) continue;
            return info;
        }
        return null;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this._dockableList = null;
        this._editorList = null;
    }

    private void initialize(List dockableList) {
        if (this._dockableList == null) {
            assert (dockableList != null && dockableList.size() > 0);
            this._dockableList = dockableList;
            this._editorList = new ArrayList<Editor>();
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                EditorAddin addin = EditorManagerImpl.getInstance().getMostRecentEditorAddin(editor.getContext());
                if (addin == null || addin.getEditorClass() == null || !editor.getClass().getName().equals(addin.getEditorClass().getName())) continue;
                this._editorList.add(editor);
            }
        }
    }
}

