/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.docking.AutoExpandListener;

public class AutoExpandEventListener
implements AWTEventListener {
    public static final long EVENT_MASK = 48L;
    private List<AutoExpandListener> delegates = new ArrayList<AutoExpandListener>();

    AutoExpandEventListener() {
    }

    void addDelegate(AutoExpandListener delegate) {
        this.delegates.add(delegate);
    }

    AutoExpandListener delegateFrom(Dockable dockable) {
        if (this.delegates.isEmpty()) {
            return null;
        }
        for (AutoExpandListener delegate : this.delegates) {
            if (delegate.dockable() != dockable) continue;
            return delegate;
        }
        return null;
    }

    void removeDelegate(AutoExpandListener delegate) {
        this.delegates.remove(delegate);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        for (AutoExpandListener delegate : this.delegates) {
            switch (mouseEvent.getID()) {
                case 503: {
                    delegate.mouseMovedFromAWTEventListener(mouseEvent);
                    break;
                }
                case 505: {
                    delegate.mouseExited(mouseEvent);
                }
            }
        }
    }
}

