/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.controls.DragComponentListener;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.Site;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DragFeedback;

abstract class AbstractDockPanelDragListener
implements DragComponentListener,
KeyEventDispatcher {
    private DragFeedback _feedback;
    private static Point _ptDragFrom;
    private static Rectangle _rcOriginalBounds;
    private Dimension _preferredFloatingSize;
    private DockLayout _lockedLayout;

    protected boolean isDraggingTab() {
        return false;
    }

    protected abstract DockInsertionPoint getDockInsertionPoint(DragComponentEvent var1);

    protected abstract void dropComponent(DragComponentEvent var1);

    protected abstract void dragComponent(DragComponentEvent var1);

    protected AbstractDockPanelDragListener(DockableHolder ref) {
        this._preferredFloatingSize = AbstractDockPanelDragListener.getPreferredFloatingSize(ref);
    }

    private final DragFeedback getFeedback() {
        if (this._feedback == null) {
            this._feedback = new DragFeedback();
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addKeyEventDispatcher(this);
        }
        return this._feedback;
    }

    private final void disposeFeedback() {
        if (this._feedback != null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removeKeyEventDispatcher(this);
            this._feedback.dispose();
            this._feedback = null;
        }
    }

    private static final boolean isDragging() {
        return _ptDragFrom != null;
    }

    private static final void endDragging() {
        _ptDragFrom = null;
    }

    @Override
    public void start(DragComponentEvent e) {
        Point point = e.getPoint();
        _ptDragFrom = new Point(point);
        Component c = (Component)e.getSource();
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, c);
        _rcOriginalBounds = new Rectangle(p, c.getSize());
        if (this.isDraggingTab()) {
            AbstractDockPanelDragListener._rcOriginalBounds.x = AbstractDockPanelDragListener._ptDragFrom.x - AbstractDockPanelDragListener._rcOriginalBounds.width / 2;
            AbstractDockPanelDragListener._rcOriginalBounds.y = AbstractDockPanelDragListener._ptDragFrom.y - 5;
        }
        this.dragComponent(e);
    }

    @Override
    public final void move(DragComponentEvent e) {
        if (AbstractDockPanelDragListener.isDragging()) {
            DockInsertionPoint dip = this.getDockInsertionPoint(e);
            if (dip != null) {
                DockLayoutPanel dp = dip.getContainer();
                DockLayout dl = (DockLayout)dp.getLayout();
                this.lockOptimize(dl);
                Point ptTarget = dip.getContainer().getLocationOnScreen();
                Rectangle r = dip.getFeedback();
                this.getFeedback().setFeedbackPosition(ptTarget.x + r.x, ptTarget.y + r.y, r.width, r.height);
            } else {
                Rectangle r = this.getFloatingRect(e);
                if (r != null) {
                    this.getFeedback().setFloatingFeedbackPosition(r.x, r.y, r.width, r.height);
                } else {
                    this.getFeedback().setFloatingFeedbackPosition(0, 0, 0, 0);
                }
            }
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void end(DragComponentEvent e) {
        block6: {
            try {
                if (!AbstractDockPanelDragListener.isDragging()) break block6;
                this.disposeFeedback();
                DockStationImpl ds = DockStationImpl.getInstance();
                ds.addDockableEventContext(12);
                try {
                    this.dropComponent(e);
                }
                finally {
                    ds.removeDockableEventContext(12);
                }
                AbstractDockPanelDragListener.endDragging();
                e.consume();
            }
            finally {
                this.lockOptimize(null);
            }
        }
    }

    @Override
    public void canceled(DragComponentEvent e) {
        try {
            this.disposeFeedback();
            AbstractDockPanelDragListener.endDragging();
        }
        finally {
            this.lockOptimize(null);
        }
    }

    final Rectangle getFloatingRect(DragComponentEvent e) {
        Point pt = e.getPoint();
        boolean isInBounds = false;
        Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
        Rectangle closestBounds = screenBounds[0];
        double closest = Double.MAX_VALUE;
        for (int i = 0; !isInBounds && i < screenBounds.length; ++i) {
            Rectangle bounds = screenBounds[i];
            isInBounds = bounds.contains(pt);
            if (isInBounds) continue;
            Point ptCorner = new Point();
            for (int x = 0; x < 2; ++x) {
                ptCorner.x = bounds.x + x * bounds.width;
                for (int y = 0; y < 2; ++y) {
                    ptCorner.y = bounds.y + y * bounds.height;
                    double dist = pt.distance(ptCorner);
                    if (!(dist < closest)) continue;
                    closestBounds = bounds;
                    closest = dist;
                }
            }
        }
        if (!isInBounds) {
            pt.x = Math.max(pt.x, closestBounds.x);
            pt.y = Math.max(pt.y, closestBounds.y);
            pt.x = Math.min(pt.x, closestBounds.x + closestBounds.width);
            pt.y = Math.min(pt.y, closestBounds.y + closestBounds.height);
        }
        return AbstractDockPanelDragListener.calcFloatFeedback(_ptDragFrom, pt, _rcOriginalBounds, this._preferredFloatingSize);
    }

    private static final Dimension getPreferredFloatingSize(DockableHolder holder) {
        Dockable dockable = holder.getDockable();
        Dimension d = null;
        Site site = dockable.getSite();
        if (site.geometry != null) {
            d = site.geometry.getSize();
        }
        if (d == null) {
            JComponent c = holder.getComponent();
            d = c.getPreferredSize();
        }
        return d;
    }

    private static final Rectangle calcFloatFeedback(Point ptFrom, Point ptTo, Rectangle rFrom, Dimension dTo) {
        if (rFrom == null) {
            return new Rectangle(1, 1);
        }
        int rFromWidth = rFrom.width;
        if (rFromWidth == 0) {
            rFromWidth = 1;
        }
        Rectangle rRet = new Rectangle(ptTo.x - (ptFrom.x - rFrom.x) * dTo.width / rFromWidth, ptTo.y - (ptFrom.y - rFrom.y), dTo.width, dTo.height);
        return rRet;
    }

    private final void lockOptimize(DockLayout dl) {
        if (this._lockedLayout != null) {
            this._lockedLayout.unlockOptimize();
        }
        if (dl != null) {
            dl.lockOptimize();
        }
        this._lockedLayout = dl;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.canceled(null);
                return true;
            }
        }
        return false;
    }
}

