/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.migration.ExtensionMigrator;
import oracle.ideimpl.config.FileAssociationsImpl;
import oracle.ideimpl.config.FileTypesPrefs;
import oracle.javatools.util.PlatformUtils;

public class FileTypesMigrator
extends ExtensionMigrator {
    @Override
    protected List getSettingKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("document-extensions-options");
        return list;
    }

    @Override
    protected String getExtensionID() {
        return "oracle.ide";
    }

    @Override
    protected File getSourceFile(File sourceDir) {
        return this.getSourceFileOrJDevExtrasFile(sourceDir);
    }

    @Override
    protected boolean addToProductPreferences() {
        return true;
    }

    @Override
    public String[] migrate(File sourceDir, File destDir) {
        String[] errors = super.migrate(sourceDir, destDir);
        if (PlatformUtils.isWindows()) {
            for (File fileExtension : FileTypesRecognizer.allMappedExtensionsToNodes()) {
                String ext = fileExtension.getPath();
                if (!FileAssociationsImpl.shouldMigrate(ext)) continue;
                FileAssociationsImpl.setExtensionPath(ext);
            }
            FileAssociationsImpl.setProxyPath();
        }
        return errors;
    }

    @Override
    protected ExtensionMigrator.AdjustedObject[] adjustObject(String inKey, Object inObject) {
        if (inObject instanceof DocumentExtensions) {
            DocumentExtensions dext = (DocumentExtensions)inObject;
            FileTypesPrefs fileTypesPrefs = FileTypesPrefs.getInstance(null);
            for (DocumentExtensions.DocRecord docRecord : dext.getDocuments()) {
                for (DocumentExtensions.ExtInfo extInfo : docRecord.getUserExtensions()) {
                    fileTypesPrefs.setNodeType(extInfo.getExtension(), docRecord.getDocClassName());
                }
            }
            for (Map.Entry entry : dext.getExtensionToContentTypeMap().entrySet()) {
                fileTypesPrefs.setContentType((String)entry.getKey(), (String)entry.getValue());
            }
            return new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("oracle.ideimpl.config.FileTypesPrefs", (Object)fileTypesPrefs)};
        }
        return new ExtensionMigrator.AdjustedObject[0];
    }
}

