/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.config;

import java.io.File;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.model.Recognizer;
import oracle.ideimpl.config.FileTypesPrefs;
import oracle.javatools.data.PropertyStorage;

public abstract class FileTypesClosure {
    private final PropertyStorage _prefs;

    public FileTypesClosure(PropertyStorage prefs) {
        this._prefs = prefs;
    }

    public final void run() {
        String docClass;
        String ext2;
        Map<File, MetaClass> docMap = Recognizer.getExtensionToMetaClassMap();
        for (Map.Entry<File, MetaClass> entry : docMap.entrySet()) {
            ext2 = entry.getKey().getPath();
            docClass = entry.getValue().getClassName();
            this.runImpl(ext2, docClass, false);
        }
        docMap = Recognizer.getDeclarativeExtensionToClassMap();
        if (docMap != null) {
            for (Map.Entry<File, MetaClass> entry : docMap.entrySet()) {
                ext2 = entry.getKey().getPath();
                docClass = entry.getValue().getClassName();
                this.runImpl(ext2, docClass, false);
            }
        }
        FileTypesPrefs fileTypes = FileTypesPrefs.getInstance(this._prefs);
        for (String ext2 : fileTypes.getFileExtensions()) {
            docClass = fileTypes.getNodeType(ext2);
            this.runImpl(ext2, docClass, true);
        }
    }

    protected abstract void runImpl(String var1, String var2, boolean var3);
}

