/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.menu.ActionRegistry;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeArgs;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.TitleProvider;
import oracle.ide.Version;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controls.FocusHierarchyDispatcher;
import oracle.ide.controls.PentaLayout;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.StatusBarControl;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.JDK;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.TitledContainer;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.DefaultTitleProvider;
import oracle.ideimpl.IdeImpl;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.MemoryMonitor;
import oracle.ideimpl.controller.EditorMenuHook;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.util.DropFileUtil;
import oracle.ideimpl.window.MaximizedWindowInfo;
import oracle.ideimpl.window.WindowingConstants;
import oracle.javatools.data.HashStructure;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingClosure;

public final class MainWindowImpl
extends IdeMainWindow {
    private static final String MAXIMIZED_PROP = "MainWindow.maximized";
    private static final String STATUS_DETRACTORS = "MainWindow.nonStatusViews";
    private ActiveViewHandlerImpl _activeViewHandler = new ActiveViewHandlerImpl();
    private final ArrayList _activationListeners = new ArrayList(2);
    private StatusListener _statusListener = new StatusListener();
    private DynamicStatusProvider _dynamicStatusProvider;
    private ArrayList _statusDetractors;
    private MemoryMonitor _memoryMonitor;
    private final ArrayList _menuListeners = new ArrayList();
    private JMenu _dynamicMenu;
    private JMenuItem _dynamicPlaceholderItem;
    private BackgroundPanel _backgroundPanel;
    private static int _mwCount = 0;
    private TitleProvider _titleProvider;
    private StartupEventListener sl;
    private static boolean _isFirstMainWindow = true;
    private boolean _deactivatingDynMenu;
    private boolean _activatingDynMenu;

    public MainWindowImpl() {
        Logger.getAnonymousLogger().info("Logs for bug 12847870. If you see this log and you are using the NEW WINDOW MANAGER please add stack trace to BUG 12847870");
        Thread.dumpStack();
    }

    @Override
    public final void preInitialize() {
        super.preInitialize();
        this.getIdeMainWindowView().getToolbar();
        this.createMenubar();
        ++_mwCount;
        this._statusDetractors = new ArrayList();
        String detractors = Ide.getProperty(STATUS_DETRACTORS);
        if (detractors != null) {
            StringTokenizer tokenizer = new StringTokenizer(detractors, ";");
            while (tokenizer.hasMoreTokens()) {
                String detractor = tokenizer.nextToken();
                this._statusDetractors.add(detractor);
            }
        }
        this._backgroundPanel = new BackgroundPanel();
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(WindowingConstants.COLOR_BACKGROUND);
        content.add((Component)this._backgroundPanel, "Center");
        content.add((Component)this.getStatusBar().getGUI(), "South");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.updatePosAndSize(e);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.updatePosAndSize(e);
            }

            private void updatePosAndSize(ComponentEvent e) {
                if (MainWindowImpl.this.isVisible()) {
                    boolean isMaximized = BitField.isSet(MainWindowImpl.this.getExtendedState(), 6);
                    Ide.setProperty(MainWindowImpl.MAXIMIZED_PROP, Boolean.toString(isMaximized));
                    if (!isMaximized) {
                        Rectangle r = new Rectangle();
                        e.getComponent().getBounds(r);
                        IdeImpl.updatePosAndSize(r);
                    }
                }
            }
        });
        new DropTarget((Component)((Object)this), 2, DropFileUtil.getDefaultDropFileListener());
    }

    @Override
    public final void initialize() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".initialize");
        this.setName("main-window");
        super.initialize();
        boolean isFirstTime = _isFirstMainWindow;
        _isFirstMainWindow = false;
        this.installDockStation();
        FocusHierarchyDispatcher fhd = FocusHierarchyDispatcher.getInstance();
        fhd.install();
        fhd.addFocusHierarchyListener(this._activeViewHandler);
        if (isFirstTime) {
            EditorManagerImpl editorManager = (EditorManagerImpl)EditorManager.getEditorManager();
            editorManager.setActiveViewHandler(this._activeViewHandler);
            DockStation dockStation = DockStation.getDockStation();
            if (dockStation instanceof DockStationImpl) {
                ((DockStationImpl)dockStation).setActiveViewHandler(this._activeViewHandler);
            }
        }
        this.createContextMenuAction();
        this.initDialogSize();
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(new ApplicationSwitchListener(), 68L);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){
            private ArrayList<TitledContainer> _lastKnownFocusedContainers = new ArrayList(0);

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ArrayList<TitledContainer> newlyFocused = new ArrayList<TitledContainer>(3);
                for (Component component = (Component)evt.getNewValue(); component != null; component = component.getParent()) {
                    if (!(component instanceof TitledContainer)) continue;
                    TitledContainer titledContainer = (TitledContainer)((Object)component);
                    if (!this._lastKnownFocusedContainers.remove(titledContainer)) {
                        titledContainer.containerActivated(true);
                    }
                    newlyFocused.add(titledContainer);
                }
                for (int i = 0; i < this._lastKnownFocusedContainers.size(); ++i) {
                    TitledContainer titledContainer = this._lastKnownFocusedContainers.get(i);
                    if (titledContainer instanceof ShutterPanel) continue;
                    titledContainer.containerActivated(false);
                }
                this._lastKnownFocusedContainers = newlyFocused;
            }
        });
        Ide.getSystem().attach(new Observer(){

            @Override
            public void update(Object observed, UpdateMessage change) {
                if (change.getMessageID() == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    View activeView = MainWindowImpl.this.getLastActiveView();
                    MainWindowImpl.this.updateTitle(activeView);
                }
            }
        });
        View active = this.getLastActiveView();
        this.addActiveViewListener(new ActiveViewListener(){

            @Override
            public void activeViewChanged(ActiveViewEvent e) {
                final View view = e.getNewView();
                MainWindowImpl.this.updateStatusBar(view);
                if (view == null || view == MainWindowImpl.this.getIdeMainWindowView()) {
                    Timer timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            View activeView = MainWindowImpl.this.getLastActiveView();
                            MainWindowImpl.this.updateTitle(activeView);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                } else {
                    MainWindowImpl.this.updateTitle(view);
                }
                MainWindowImpl.this.deactivateDynamicMenu();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Editor activeEditor = EditorManager.getEditorManager().getCurrentEditor();
                        if (activeEditor != null) {
                            if (Ide.getMainWindow().getLastActiveView() != view) {
                                return;
                            }
                            Object editorAttribute = activeEditor.getEditorAttribute("old_editor");
                            if (!Boolean.TRUE.equals(editorAttribute)) {
                                MainWindowImpl.this.activateDynamicMenu(view);
                            }
                        }
                    }
                });
            }
        });
        this.updateStatusBar(active);
        this.setMinimumSize(new Dimension(120, 90));
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.maximizeWindowIfNecessary();
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".initialize", "Initialized main window");
    }

    protected WindowListener getWindowListener() {
        return new WindowAdapter(){
            private boolean _active;
            private Component focusComponent;

            @Override
            public void windowClosing(WindowEvent e) {
                if (_mwCount == 1) {
                    if (!Ide.isQuitting()) {
                        Context context = MainWindowImpl.this.getIdeMainWindowView().getContext(e);
                        Ide.quit(IdeActions.getFileExitAction(), context);
                    }
                } else {
                    MainWindowImpl.this.getIdeMainWindowView().close();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                DockStation dockStation = DockStation.getDockStation();
                Logger.getAnonymousLogger().info("Current window manager " + dockStation);
                _mwCount--;
                if (_mwCount == 0 && WindowManagerStartingController.getInstance() == null) {
                    MainWindowImpl.this.terminateIde();
                    Beans.setDesignTime(false);
                    System.exit(0);
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
                this._active = true;
                MainWindowImpl.this.getIdeMainWindowView().activate();
                if (JDK.HAS_BUG_4552322) {
                    MainWindowImpl.this.repaint();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                this._active = false;
                MainWindowImpl.this.getIdeMainWindowView().deactivate();
                if (JDK.HAS_BUG_4381959) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!_active) {
                                MainWindowImpl.this.dispatchEvent(new FocusEvent((Component)((Object)MainWindowImpl.this), 1005, true));
                            }
                        }
                    });
                }
            }

            @Override
            public void windowIconified(WindowEvent e) {
                this.focusComponent = MainWindowImpl.this.getFocusOwner();
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                if (this.focusComponent instanceof JComponent) {
                    JComponent jcFocused = (JComponent)this.focusComponent;
                    jcFocused.dispatchEvent(new FocusEvent(this.focusComponent, 1004, false));
                }
            }
        };
    }

    protected void initGeometry() {
        this.setBounds(IdeImpl.getStartupCoordinates());
    }

    protected void loadMainMenu() {
        if (_isFirstMainWindow) {
            JMenu fileMenu = IdeMenus.findOrCreateJMenu("File");
            JMenuItem exitItem = IdeMenus.createMenuItem(IdeActions.getFileExitAction(), MenuConstants.WEIGHT_FILE_EXIT);
            Ide.getMenubar().add(exitItem, fileMenu, MenuConstants.SECTION_FILE_EXIT);
        }
    }

    @Override
    public boolean isFullScreenMode() {
        return false;
    }

    @Override
    public IdeMainWindow.ControllerContext getControllerContext() {
        return this._activeViewHandler;
    }

    @Override
    public void registerView(View view) {
        Component c;
        if (view != null && (c = view.getGUI()) != null) {
            this.registerView(view, c);
        }
    }

    @Override
    public void registerView(View view, Component c) {
        this._activeViewHandler.addDependant(c, view);
    }

    @Override
    public void unregisterView(View view) {
        if (view != null) {
            this._activeViewHandler.removeDependant(view);
        }
    }

    @Override
    public final View getLastActiveView() {
        View view = null;
        if (this._activeViewHandler != null && (view = this._activeViewHandler.getLastActiveView()) == null) {
            view = this.getIdeMainWindowView();
        }
        return view != null ? view.getViewWithoutDecoration() : null;
    }

    @Override
    public final List<View> getVisibleViews() {
        if (this._activeViewHandler != null) {
            return this._activeViewHandler.getVisibleViews();
        }
        return Collections.emptyList();
    }

    @Override
    public void addActiveViewListener(ActiveViewListener l) {
        this._activeViewHandler.addActiveViewListener(l);
    }

    @Override
    public void removeActiveViewListener(ActiveViewListener l) {
        this._activeViewHandler.removeActiveViewListener(l);
    }

    @Override
    public void addIdeActivationListener(IdeActivationListener l) {
        this._activationListeners.add(l);
    }

    @Override
    public void removeIdeActivationListener(IdeActivationListener l) {
        this._activationListeners.remove(l);
    }

    @Override
    public void addDynamicMenuListener(DynamicMenuListener listener) {
        if (!this._menuListeners.contains(listener)) {
            this._menuListeners.add(listener);
        }
    }

    @Override
    public void removeDynamicMenuListener(DynamicMenuListener listener) {
        if (listener != null) {
            this._menuListeners.remove(listener);
        }
    }

    @Override
    public void updateTitle(Object ctx) {
        if (ctx instanceof View) {
            this.updateTitle((View)ctx);
        }
    }

    @Override
    public final void close() {
        StatusBar sb;
        FocusHierarchyDispatcher.getInstance().uninstall();
        Toolbar toolbar = this.getIdeMainWindowView().getToolbar();
        if (toolbar != null) {
            toolbar.dispose();
        }
        if ((sb = this.getStatusBar()) instanceof StatusBarControl) {
            ((StatusBarControl)sb).dispose();
        }
        super.close();
    }

    public void addNotify() {
        super.addNotify();
        if (Ide.isStarting() && Ide.getIdeProperties().isPropertySet(MAXIMIZED_PROP, Boolean.TRUE.toString(), null)) {
            this.setExtendedState(6);
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == DynamicMenuListener.class) {
            return this._menuListeners.toArray(new EventListener[this._menuListeners.size()]);
        }
        if (listenerType == ActiveViewListener.class) {
            return this._activeViewHandler.getListeners(listenerType);
        }
        return super.getListeners(listenerType);
    }

    public void setDesktop(JComponent desktop) {
        this._backgroundPanel.getHost().add((Component)desktop, PentaLayout.CENTER);
    }

    public boolean isMaximized() {
        return this._backgroundPanel.isMaximized();
    }

    public void maximize(MaximizedWindowInfo maximizedWindowInfo) {
        this._backgroundPanel.maximize(maximizedWindowInfo);
    }

    public void restore() {
        this._backgroundPanel.restore();
    }

    public int getMaximizedWindowType() {
        return this._backgroundPanel.getMaximizedWindowType();
    }

    @Override
    protected StatusBar createStatusBar() {
        StatusBar sb = super.createStatusBar();
        String property = Ide.getProperty("MainWindow.MemoryMonitorOn");
        String systemProperty = System.getProperty("MainWindow.MemoryMonitorOn");
        if ("1".equals(systemProperty) || "on".toLowerCase().equals(systemProperty)) {
            systemProperty = "true";
        }
        if (Version.DEBUG_BUILD == 1 || Boolean.valueOf(property).booleanValue() || Boolean.valueOf(systemProperty).booleanValue()) {
            this._memoryMonitor = new MemoryMonitor(sb);
        }
        return sb;
    }

    @Override
    public void postInitialize(final IdeArgs ideArgs) {
        ActionRegistry.getActionRegistry().initAfterMainWindowOpened();
        this.loadToolbar();
        this.updateStatusBarAction();
        try {
            new SwingClosure(){

                private void processThrowable(Throwable e) {
                    if (e instanceof ThreadDeath) {
                        e.printStackTrace();
                        throw (ThreadDeath)e;
                    }
                    ExceptionDialog.showExceptionDialog((Component)((Object)MainWindowImpl.this), (Throwable)e);
                }

                protected void runImpl() throws Exception {
                    try {
                        Layouts layouts = Layouts.getLayouts();
                        if (layouts != null) {
                            IdeLayout activeLayout = layouts.getActiveLayout();
                            layouts.activateLayout(activeLayout, true);
                        }
                    }
                    catch (Throwable e) {
                        this.processThrowable(e);
                    }
                    try {
                        MainWindowImpl.this.processCommandLine(ideArgs);
                    }
                    catch (Throwable e) {
                        this.processThrowable(e);
                    }
                    try {
                        if (MainWindowImpl.this._memoryMonitor != null) {
                            MainWindowImpl.this._memoryMonitor.startMonitor();
                        }
                    }
                    catch (Throwable e) {
                        this.processThrowable(e);
                    }
                    Assert.startTiming((String)(((Object)((Object)this)).getClass().getName() + ".postInitialize(SETVISIBLE)"), null, (boolean)false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IdeUtil.tryToRestoreFocus(null);
                        }
                    });
                    Assert.endTiming((String)(((Object)((Object)this)).getClass().getName() + ".postInitialize(SETVISIBLE)"), (String)"Made main window visible", null, (boolean)false);
                }
            }.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.sl);
    }

    protected void loadToolbar() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.loadToolbarImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainWindowImpl.this.loadToolbarImpl();
                }
            });
        }
    }

    private void loadToolbarImpl() {
        Assert.startTiming((String)(this.getClass().getName() + ".postInitialize(TOOLBAR)"), null, (boolean)false);
        View.loadManifestToolbar("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID", this.getIdeMainWindowView().getToolbar());
        Assert.endTiming((String)(this.getClass().getName() + ".postInitialize(TOOLBAR)"), (String)"Loaded main toolbar", null, (boolean)false);
    }

    private TitleProvider getTitleProvider() {
        LazyClassAdapter adapter;
        TitleProvider provider;
        HashStructure productHook;
        if (this._titleProvider != null) {
            return this._titleProvider;
        }
        ProductInformation pi = ProductInformation.getProductInformation();
        if (pi != null && (productHook = pi.getHashStructure()) != null && (provider = (adapter = LazyClassAdapter.getInstance(productHook)).createInstance(TitleProvider.class, "main-window/title-provider-class/#text")) != null) {
            this._titleProvider = provider;
            return provider;
        }
        this._titleProvider = new DefaultTitleProvider(this);
        return this._titleProvider;
    }

    private void updateTitle(View view) {
        this.setTitle(this.getTitleProvider().getTitle(view));
    }

    private void installDockStation() {
        DockStation dockStation = DockStation.getDockStation();
        EditorManager editorManager = EditorManager.getEditorManager();
        if (dockStation != null && editorManager != null) {
            dockStation.install((JFrame)((Object)this), this._backgroundPanel.getHost(), editorManager.getDesktopComponent());
        }
    }

    private void createContextMenuAction() {
        IdeAction action = IdeAction.get(50, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString(322), null, null, null, null, true);
        Ide.getMenubar().createMenuItem(action);
    }

    private void initDialogSize() {
        IdeProperties properties = Ide.getIdeProperties();
        String dialogWidth = properties.getProperty("Ide.DefaultDialogWidth", "700");
        String dialogHeight = properties.getProperty("Ide.DefaultDialogHeight", "500");
        try {
            int width = Integer.parseInt(dialogWidth);
            width = Math.max(width, 600);
            width = Math.min(width, 1200);
            int height = Integer.parseInt(dialogHeight);
            height = Math.max(height, 400);
            height = Math.min(height, 800);
            TDialogLauncher.setPreferredDefaultInitialSize((Dimension)new Dimension(width, height));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setStatusBarVisible(boolean visible) {
        super.setStatusBarVisible(visible);
        this.updateStatusBar(this.getLastActiveView());
    }

    private void updateStatusBar(View view) {
        if (!Ide.getStatusBar().getGUI().isVisible()) {
            return;
        }
        if (this._dynamicStatusProvider != null) {
            this._dynamicStatusProvider.removeChangeListener(this._statusListener);
            this._dynamicStatusProvider = null;
        }
        StatusBarControl statusBar = (StatusBarControl)this.getStatusBar();
        if (view instanceof StatusProvider) {
            int i;
            boolean reset;
            StatusProvider provider = (StatusProvider)((Object)view);
            JComponent[] cells = provider.getCustomCells();
            int count = cells != null ? cells.length : 0;
            boolean bl = reset = count != statusBar.getStatusCount();
            if (!reset) {
                for (i = 0; i < count; ++i) {
                    if (statusBar.containsStatusItem(cells[i])) continue;
                    reset = true;
                    break;
                }
            }
            if (reset) {
                statusBar.resetStatus();
                for (i = 0; i < count; ++i) {
                    statusBar.add(cells[i]);
                    statusBar.setExpandable(cells[i], provider.isExpandable(cells[i]));
                }
                statusBar.getGUI().repaint();
            }
            if (view instanceof DynamicStatusProvider) {
                this._dynamicStatusProvider = (DynamicStatusProvider)((Object)view);
                this._dynamicStatusProvider.addChangeListener(this._statusListener);
            }
        } else {
            if (view != null) {
                ViewId id = new ViewId(view.getId());
                String type = id.getType();
                if ("ComponentPalette".equals(type) || "InspectorWindow".equals(type)) {
                    return;
                }
                if (this._statusDetractors.contains(view.getClass().getName())) {
                    return;
                }
            }
            statusBar.resetStatus();
            statusBar.getGUI().repaint();
        }
    }

    private void deactivateDynamicMenu() {
        if (this._deactivatingDynMenu || this._activatingDynMenu) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MainWindowImpl.this._dynamicMenu != null) {
                    MainWindowImpl.this._deactivatingDynMenu = true;
                    if (!PlatformUtils.isMac()) {
                        MainWindowImpl.this._dynamicMenu.setVisible(false);
                    }
                    if (MainWindowImpl.this._dynamicPlaceholderItem == null) {
                        MainWindowImpl.this._dynamicPlaceholderItem = new JMenuItem(IdeArb.getString(530));
                        MainWindowImpl.this._dynamicPlaceholderItem.setEnabled(false);
                    }
                    MainWindowImpl.this.getMenubar().getGUI(false).validate();
                    MainWindowImpl.this._dynamicMenu.removeAll();
                    MainWindowImpl.this._dynamicMenu.add(MainWindowImpl.this._dynamicPlaceholderItem);
                    MainWindowImpl.this._deactivatingDynMenu = false;
                }
            }
        });
    }

    private void activateDynamicMenu(View view) {
        if (this._deactivatingDynMenu || this._activatingDynMenu) {
            return;
        }
        String viewName = this.getViewAttribute(view);
        if (viewName == null) {
            return;
        }
        ArrayList<JComponent> commandList = new ArrayList<JComponent>();
        this._activatingDynMenu = true;
        Context ctxt = view.getContext();
        for (int i = 0; i < this._menuListeners.size(); ++i) {
            DynamicMenuListener ml = (DynamicMenuListener)this._menuListeners.get(i);
            try {
                long startTime = System.nanoTime();
                JComponent[] menuItems = ml.gatherDynamicActions(ctxt);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("DyanmicMenuListener.gatherDynamicActions", ml.getClass().getName(), endTime - startTime);
                if (menuItems == null || menuItems.length <= 0) continue;
                ArrayList<JComponent> commands = new ArrayList<JComponent>();
                for (int x = 0; x < menuItems.length; ++x) {
                    commands.add(menuItems[x]);
                }
                this.ensureItemsAreWeighted(commands);
                commandList.addAll(commands);
                continue;
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        String label = StringUtils.stripMnemonic((String)viewName);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)viewName);
        if (this._dynamicMenu == null) {
            this._dynamicMenu = this.getMenubar().createMenu(label, (Integer)mnemonic, MenuConstants.WEIGHT_DYNAMIC_MENU);
        }
        if (this._dynamicPlaceholderItem != null) {
            this._dynamicMenu.remove(this._dynamicPlaceholderItem);
        }
        this._dynamicMenu.setText(label);
        this._dynamicMenu.setMnemonic(mnemonic);
        if (commandList.size() > 0) {
            Collections.sort(commandList, new MenuWeightComparator());
            float section = 1.0f;
            Iterator menuItems = commandList.iterator();
            while (menuItems.hasNext()) {
                JComponent comp = (JComponent)menuItems.next();
                if (comp instanceof JSeparator) {
                    menuItems.remove();
                    section = MenuConstants.increment(section);
                    continue;
                }
                this.getMenubar().add(comp, this._dynamicMenu, section);
            }
        }
        this.addEditorMenuHookItems(this._dynamicMenu, view);
        if (this._dynamicMenu.getItemCount() > 0) {
            if (this.getMenubar().contains(this._dynamicMenu)) {
                if (!PlatformUtils.isMac()) {
                    this._dynamicMenu.setVisible(true);
                }
            } else {
                this.getMenubar().add(this._dynamicMenu);
            }
        }
        this._dynamicMenu.revalidate();
        this._activatingDynMenu = false;
    }

    private void addEditorMenuHookItems(JMenu menu, View view) {
        Context context = view.getContext();
        EditorMenuHook hook = (EditorMenuHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorMenuHook.ELEMENT);
        hook.addMenuItems(menu, context);
    }

    private void ensureItemsAreWeighted(ArrayList<JComponent> commands) {
        int size = commands.size();
        if (size == 0) {
            return;
        }
        HashMap<Integer, Float> weightsMap = this.getMarkers(commands);
        if (weightsMap.size() == 0) {
            return;
        }
        ArrayList<Integer> markers = new ArrayList<Integer>(weightsMap.keySet());
        Collections.sort(markers);
        int start = 0;
        for (Integer index : markers) {
            int end = index;
            for (int i = start; i < end; ++i) {
                commands.get(i).putClientProperty("menu-weight", weightsMap.get(index));
            }
            start = end + 1;
        }
        int lastIndex = size - 1;
        int finalMarker = markers.get(markers.size() - 1);
        if (finalMarker < lastIndex) {
            for (int i = finalMarker + 1; i <= lastIndex; ++i) {
                commands.get(i).putClientProperty("menu-weight", weightsMap.get(finalMarker));
            }
        }
    }

    private HashMap<Integer, Float> getMarkers(ArrayList<JComponent> list) {
        HashMap<Integer, Float> markers = new HashMap<Integer, Float>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Float weight = (Float)list.get(i).getClientProperty("menu-weight");
            if (weight == null) continue;
            markers.put(i, weight);
        }
        return markers;
    }

    private String getViewAttribute(View view) {
        Editor editor;
        String menuId;
        if (view instanceof Editor && (menuId = (String)(editor = (Editor)view).getEditorAttribute("menu_id")) != null) {
            return menuId;
        }
        return null;
    }

    public void removeNotify() {
        MainWindowImpl.checkEventDispatchThread();
        super.removeNotify();
    }

    private static void checkEventDispatchThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Outside of the AWT. Look at the stacktrace below:");
            Thread.dumpStack();
        }
    }

    private void maximizeWindowIfNecessary() {
        String maximized = Ide.getProperty(MAXIMIZED_PROP);
        if (maximized != null && maximized.equals(Boolean.TRUE.toString())) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    class StartupEventListener
    implements AWTEventListener {
        private int openChildren = 0;

        StartupEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            block0 : switch (event.getID()) {
                case 200: {
                    Window child = (Window)event.getSource();
                    Window[] children = MainWindowImpl.this.getOwnedWindows();
                    if (children == null) break;
                    for (int i = children.length - 1; i >= 0; --i) {
                        if (child != children[i]) continue;
                        ++this.openChildren;
                        break block0;
                    }
                    break;
                }
                case 202: {
                    Window child = (Window)event.getSource();
                    Window[] children = MainWindowImpl.this.getOwnedWindows();
                    if (children == null) break;
                    for (int i = children.length - 1; i >= 0; --i) {
                        if (child != children[i]) continue;
                        --this.openChildren;
                        break;
                    }
                    if (this.openChildren != 0) break;
                    MainWindowImpl.this.setVisible(false);
                    break;
                }
            }
        }
    }

    private static final class BackgroundPanel
    extends Box
    implements Runnable {
        private HostPanel _content = new HostPanel();
        private MaximizedWindowInfo _maximizedWindowInfo;

        public BackgroundPanel() {
            super(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setOpaque(false);
            this._content.setOpaque(false);
            this.add(this._content);
        }

        public Container getHost() {
            return this._content;
        }

        public boolean isMaximized() {
            return this._maximizedWindowInfo != null;
        }

        public void maximize(MaximizedWindowInfo maximizedWindowInfo) {
            if (this._maximizedWindowInfo != null) {
                this.restore();
            }
            assert (maximizedWindowInfo != null);
            assert (maximizedWindowInfo.getMaximizeComponent() != null);
            this._maximizedWindowInfo = maximizedWindowInfo;
            SwingUtilities.invokeLater(this);
        }

        public void restore() {
            if (this._maximizedWindowInfo != null) {
                this.remove(0);
                this.add(this._content);
                this._maximizedWindowInfo.restore();
                this._maximizedWindowInfo = null;
                this.revalidate();
                this.repaint();
            }
        }

        public int getMaximizedWindowType() {
            return this._maximizedWindowInfo == null ? 0 : this._maximizedWindowInfo.getWindowType();
        }

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            assert (this.getComponentCount() == 0);
            super.addImpl(comp, constraints, index);
        }

        @Override
        public void run() {
            if (this._maximizedWindowInfo != null) {
                assert (this._maximizedWindowInfo.getMaximizeComponent() != null);
                assert (this.getComponentCount() == 1);
                this.remove(0);
                this.add(this._maximizedWindowInfo.getMaximizeComponent());
                this._maximizedWindowInfo.maximize();
                this.revalidate();
                this.repaint();
            }
        }

        private static final class HostPanel
        extends JPanel {
            public HostPanel() {
                this.setOpaque(false);
            }
        }
    }

    private final class StatusListener
    implements ChangeListener {
        private StatusListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainWindowImpl.this.updateStatusBar((View)e.getSource());
        }
    }

    private class ApplicationSwitchListener
    implements AWTEventListener {
        private Object _active;
        private Object _inactive;
        private boolean _deactivated;

        private ApplicationSwitchListener() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            try {
                int id = e.getID();
                Object source = e.getSource();
                switch (id) {
                    case 205: {
                        this._active = source;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ApplicationSwitchListener.this._deactivated) {
                                    return;
                                }
                                ApplicationSwitchListener.this._deactivated = false;
                                ApplicationSwitchListener.this.fireIdeActivated();
                            }
                        });
                        return;
                    }
                    case 206: {
                        this._inactive = source;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (ApplicationSwitchListener.this._active != ApplicationSwitchListener.this._inactive || ApplicationSwitchListener.this._inactive != MainWindowImpl.this) {
                                    return;
                                }
                                ApplicationSwitchListener.this._deactivated = true;
                                ApplicationSwitchListener.this.fireIdeDeactivated();
                            }
                        });
                        return;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void fireIdeDeactivated() {
            IdeActivationEvent event = new IdeActivationEvent();
            IdeActivationListener[] listeners = MainWindowImpl.this._activationListeners.toArray(new IdeActivationListener[MainWindowImpl.this._activationListeners.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                IdeActivationListener l = listeners[i];
                try {
                    long startTime = System.nanoTime();
                    l.deactivated(event);
                    long endTime = System.nanoTime();
                    PerformanceLogger.get().log("IdeActivationListener.deactivated", l.getClass().getName(), endTime - startTime);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void fireIdeActivated() {
            IdeActivationEvent event = new IdeActivationEvent();
            IdeActivationListener[] listeners = MainWindowImpl.this._activationListeners.toArray(new IdeActivationListener[MainWindowImpl.this._activationListeners.size()]);
            long cet = System.nanoTime();
            boolean longListener = false;
            for (int i = 0; i < listeners.length; ++i) {
                IdeActivationListener l = listeners[i];
                try {
                    long et = System.nanoTime();
                    l.activated(event);
                    et = System.nanoTime() - et;
                    PerformanceLogger.get().log("IdeActivationListener.activated", l.getClass().getName(), et);
                    if (et < 200000000L) continue;
                    longListener = true;
                    Assert.println((String)("fireIdeActivated(): " + l.getClass().getName() + " " + et / 1000000L + "ms"));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            cet = System.nanoTime() - cet;
            if (!longListener && cet >= 500000000L) {
                Assert.println((String)("fireIdeActivated(): all " + listeners.length + " listeners executed in " + cet / 1000000L + "ms"));
            }
        }
    }

    protected static interface ControllerContextImpl
    extends IdeMainWindow.ControllerContext {
    }
}

