/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;

public class Arguments<T extends Enum<T>> {
    private static final char OPTION_PREFIX = '-';
    private static final char[] VALUE_SEPARATORS = new char[]{':', '='};
    private final EnumSet<T> _set;
    private final EnumMap<T, String> _values;
    private final EnumSet<T> _options;
    private final EnumMap<T, T> _argumentsMap;
    private final EnumMap<T, String> _nameOverrides;
    private final EnumMap<T, T> _mutuallyExclusive;
    private final EnumSet<T> _exclusions;
    private String[] _parameters = null;
    private final IArgumentManager _argumentManager;

    public Arguments(IArgumentManager argumentManager) {
        Class enumClass = argumentManager.getEnumClass();
        this._set = EnumSet.noneOf(enumClass);
        this._values = new EnumMap(enumClass);
        this._options = EnumSet.noneOf(enumClass);
        this._argumentsMap = new EnumMap(enumClass);
        this._nameOverrides = new EnumMap(enumClass);
        this._mutuallyExclusive = new EnumMap(enumClass);
        this._exclusions = EnumSet.noneOf(enumClass);
        this._argumentManager = argumentManager;
        if (this._argumentManager != null) {
            this._argumentManager.setup(this._options, this._argumentsMap, this._nameOverrides, this._mutuallyExclusive);
        }
    }

    public void processArguments(String[] args) {
        LinkedList<String> lparameters = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            Object argument;
            String sArg = args[i];
            if (sArg.length() <= 0) continue;
            if (sArg.charAt(0) != '-') {
                lparameters.add(sArg);
                continue;
            }
            String sArgNoDash = sArg.substring(1);
            String sVal = null;
            String sOpt = null;
            boolean found = false;
            for (char separator : VALUE_SEPARATORS) {
                int index = sArgNoDash.indexOf(separator);
                if (index <= 0) continue;
                sOpt = sArgNoDash.substring(0, index);
                sVal = sArgNoDash.substring(index + 1);
                found = true;
                break;
            }
            if (!found) {
                sOpt = sArgNoDash;
            }
            if (sOpt == null || (argument = this.stringToArgument(this._argumentManager.getEnumClass(), sOpt, this._nameOverrides)) == null) continue;
            if (this._argumentsMap.containsKey(argument)) {
                argument = (Enum)this._argumentsMap.get(argument);
            }
            this._set.add(argument);
            if (sVal == null || !this._options.contains(argument)) continue;
            this._values.put(argument, Arguments.getValue(sVal));
        }
        this._argumentManager.postSetup(this._set, this._values);
        for (Enum argument : this._set) {
            if (!this._mutuallyExclusive.containsKey(argument)) continue;
            this._exclusions.add(this._mutuallyExclusive.get(argument));
        }
        for (Enum argument : this._exclusions) {
            if (!this._set.contains(argument)) continue;
            this._set.remove(argument);
        }
        int parametersSize = lparameters.size();
        if (parametersSize > 0) {
            this._parameters = lparameters.toArray(new String[parametersSize]);
        }
    }

    public boolean contains(T argument) {
        return this._set.contains(argument);
    }

    public boolean hasOption(T argument) {
        return this._options.contains(argument);
    }

    public String getOption(T argument) {
        String result = null;
        if (this.hasOption(argument)) {
            result = this._values.get(argument);
        }
        return result;
    }

    public EnumSet<T> getExclusions() {
        return this._exclusions;
    }

    public String[] getParameters() {
        return this._parameters;
    }

    private T stringToArgument(Class enumClass, String value, EnumMap<T, String> overrides) {
        Enum result = null;
        if (value != null) {
            String caseInsensitiveValue = value.toLowerCase();
            EnumSet<Enum> values = EnumSet.allOf(enumClass);
            for (Enum argument : values) {
                String lname = null;
                String lvalue = null;
                if (overrides.containsKey(argument)) {
                    lname = overrides.get(argument);
                    lvalue = value;
                } else {
                    lname = argument.toString().toLowerCase();
                    lvalue = caseInsensitiveValue;
                }
                if (lname == null || lname.compareTo(lvalue) != 0) continue;
                result = argument;
                break;
            }
        }
        return (T)result;
    }

    private static String getValue(String sValue) {
        int n;
        if (sValue != null && (n = sValue.length()) > 1 && (sValue.startsWith("\"") && sValue.endsWith("\"") || sValue.startsWith("'") && sValue.endsWith("'"))) {
            sValue = sValue.substring(1, n - 1);
        }
        return sValue;
    }

    public static interface IArgumentManager<T extends Enum<T>> {
        public void setup(EnumSet var1, EnumMap<T, T> var2, EnumMap<T, String> var3, EnumMap<T, T> var4);

        public void postSetup(EnumSet<T> var1, EnumMap<T, String> var2);

        public Class getEnumClass();
    }
}

