/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.PanelsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;

public class FinishPanel
extends DefaultTraversablePanel {
    private final MultiLineLabel _finishText = new MultiLineLabel();
    private Component _comp;
    private JTree _summaryTree;
    private DefaultMutableTreeNode _rootNode;
    private JScrollPane _scrollPane;
    private DefaultTreeModel _treeModel;
    private JPanel _panel;
    private final MultiLineLabel _finishDescText = new MultiLineLabel();

    public FinishPanel(String finishText, String descText) {
        this(finishText);
        MultiLineLabel descriptiveText = new MultiLineLabel();
        descriptiveText.setTextWrapper(WordWrapper.getTextWrapper());
        descriptiveText.setText(descText);
        this.setFinishComponent((Component)descriptiveText);
    }

    public FinishPanel() {
        this.setLayout(new BorderLayout());
        this._finishText.setFont(WelcomePanel.getTitleFont(this._finishText.getFont()));
        this._finishText.setTextWrapper(WordWrapper.getTextWrapper());
        this._finishText.setPreferredAspectRatio(0.0f);
        this._finishText.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this._finishText, "North");
        this.setDefaultTitle(PanelsArb.getString(2));
    }

    public FinishPanel(String finishText) {
        this();
        this.setFinishText(finishText);
    }

    public void onEntry(TraversableContext tc) {
        tc.getWizardCallbacks().wizardSetInitialFocus((Component)this._summaryTree);
    }

    public static Step newStep(String finishText, String descText, String helpID) {
        Class<String> strClass = String.class;
        Class[] argTypes = new Class[]{strClass, strClass};
        Object[] args = new Object[]{finishText, descText};
        Step step = new Step(FinishPanel.class, argTypes, args);
        step.setHelpID(helpID);
        return step;
    }

    public void setFinishText(String txt) {
        this._finishText.setText(txt);
    }

    public String getFinishText() {
        return this._finishText.getText();
    }

    public void setFinishComponent(Component comp) {
        this._comp = comp;
        this.add(this._comp, "Center");
    }

    public Component getFinishComponent() {
        return this._comp;
    }

    public JTree createSummaryTree(String finishDescriptionText) {
        this._summaryTree = new JTree();
        this._summaryTree.setRootVisible(false);
        this._summaryTree.setBorder(null);
        this._rootNode = new DefaultMutableTreeNode();
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._summaryTree.setModel(this._treeModel);
        this._scrollPane = new JScrollPane();
        this._scrollPane.getViewport().add((Component)this._summaryTree, null);
        this._panel = new JPanel();
        this._panel.setLayout(new BorderLayout());
        if (ModelUtil.hasLength((String)finishDescriptionText)) {
            this._finishDescText.setTextWrapper(WordWrapper.getTextWrapper());
            this._finishDescText.setText(finishDescriptionText);
            this._panel.add((Component)this._finishDescText, "North");
        }
        this._panel.add((Component)this._scrollPane, "Center");
        this.setFinishComponent(this._panel);
        return this._summaryTree;
    }

    public void expandSummaryTree() {
        Object o;
        if (this._summaryTree.getModel() != null && (o = this._summaryTree.getModel().getRoot()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)o;
            Enumeration<TreeNode> e = root.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = new TreePath(n.getPath());
                if (this._summaryTree.isExpanded(path)) continue;
                this._summaryTree.expandPath(path);
            }
        }
    }
}

