/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.IOException;
import java.net.URL;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class URLCopier {
    public void copyURL(URL source, URL destination) throws IOException {
        String entry = JarUtil.getJarEntry((URL)source);
        URL dest = URLFactory.newURL((URL)destination, (String)entry);
        if (URLFileSystem.isDirectory((URL)source)) {
            this.copyDirectoryRecursive(source, URLFileSystem.getParent((URL)dest));
        } else {
            URLFileSystem.copy((URL)source, (URL)dest);
        }
    }

    protected void copyDirectoryRecursive(URL source, URL destination) throws IOException {
        String fileName = URLFileSystem.getFileName((URL)source);
        if (URLFileSystem.isDirectory((URL)source)) {
            URL destURL = URLFactory.newDirURL((URL)destination, (String)fileName);
            URLFileSystem.mkdirs((URL)destURL);
            URL[] children = URLFileSystem.list((URL)source);
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectoryRecursive(children[i], destURL);
            }
        } else {
            URL destURL = URLFactory.newURL((URL)destination, (String)fileName);
            URLFileSystem.copy((URL)source, (URL)destURL);
        }
    }
}

