/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.usages;

import java.util.Collection;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

public class UsageData
extends HashStructureAdapter {
    protected static final String EVENT_ID = "event-id";
    protected static final String EVENT_SOURCE = "event-source";
    protected static final String EVENT_PROPERTIES = "event-properties";

    protected UsageData(HashStructure hash) {
        super(hash);
    }

    public final void setEventId(String eventId) {
        this._hash.putString(EVENT_ID, eventId, true);
    }

    public final void setEventSource(String eventSource) {
        this._hash.putString(EVENT_SOURCE, eventSource, true);
    }

    public final void setProperty(String propertyName, String propertyValue) {
        if (propertyName == null || propertyValue == null) {
            return;
        }
        HashStructure properties = this._hash.getOrCreateHashStructure(EVENT_PROPERTIES);
        properties.putString(propertyName, propertyValue);
    }

    public final void setProperty(String propertyName, Collection<String> values) {
        if (propertyName == null || values == null) {
            return;
        }
        ListStructure propList = ListStructure.newInstance();
        for (String val : values) {
            propList.add((Object)val);
        }
        HashStructure properties = this._hash.getOrCreateHashStructure(EVENT_PROPERTIES);
        properties.putListStructure(propertyName, propList);
    }

    public final void setProperties(HashStructure propertyHash) {
        this._hash.putHashStructure(EVENT_PROPERTIES, propertyHash);
    }

    @Deprecated
    public final void setUsageTimeStamp(Long time) {
    }

    @Deprecated
    public final void setUsageType(String usageType) {
        this.setEventSource(usageType);
    }

    @Deprecated
    public final void setExtensionId(String extensionProductId) {
        this.setEventId(extensionProductId);
    }

    @Deprecated
    public final void setPropertyId(String propertyId) {
        this.setProperty("property-id", propertyId);
    }

    @Deprecated
    public final void setPropertyValue(String propertyValue) {
        this.setProperty("property-value", propertyValue);
    }
}

