/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task;

import java.util.LinkedHashMap;
import oracle.ide.task.CancellableTask;
import oracle.ide.task.DefaultTaskMonitorImpl;
import oracle.ide.task.Task;
import oracle.ide.task.TaskGroupExecutionPolicy;
import oracle.ide.task.TaskID;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.TaskState;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskEvent;
import oracle.ide.task.event.TaskException;
import oracle.ide.task.event.TaskExitCode;
import oracle.ide.task.event.TaskFrameworkServicesImpl;
import oracle.ide.task.event.TaskListener;
import oracle.ide.task.event.UpdateEvent;

@Deprecated
public class TaskGroup
extends Task {
    private LinkedHashMap<TaskID, Task> groupTasks = new LinkedHashMap();
    private int totalCount = 0;
    protected int countDone = 0;
    private TaskGroupExecutionPolicy policy;
    private int currentTask;

    public TaskGroup(String implementorID, TaskGroupExecutionPolicy policy) throws TaskException {
        super(implementorID, 0);
        this.policy = policy;
    }

    public Object getResult() {
        return null;
    }

    public int getCountLeft() {
        return this.totalCount - this.countDone;
    }

    public int getCountDone() {
        return this.countDone;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getTimeLeftSeconds() {
        return 0;
    }

    public int getTotalTaskCount() {
        return this.groupTasks.size();
    }

    public int getCurrentTaskCount() {
        return this.currentTask;
    }

    public void addTask(Task task) throws TaskException {
        if (task.state != TaskState.CREATED) {
            throw new TaskException("Tasks can only be added before starting ");
        }
        this.groupTasks.put(task.getID(), task);
        this.totalCount += task.getTotalCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public final TaskExitCode performTask(TaskMonitor ignore) throws Exception {
        InternalTaskListener g = new InternalTaskListener();
        for (Task task : this.groupTasks.values()) {
            task.addTaskListener(g);
            ++this.currentTask;
            DefaultTaskMonitorImpl cs = new DefaultTaskMonitorImpl(task);
            TaskFrameworkServicesImpl fs = new TaskFrameworkServicesImpl(task);
            TaskEvent ee = new TaskEvent(task);
            fs.fireStarted(ee);
            try {
                TaskExitCode exitCode = task.performTask(cs);
                switch (exitCode) {
                    case CANCELLED: {
                        Object e;
                        task.state = TaskState.CANCELLED;
                        if (task instanceof CancellableTask) {
                            e = new TaskEvent(task);
                            fs.fireCancelled((TaskEvent)e);
                        }
                        if (this.policy != TaskGroupExecutionPolicy.ABORT_ON_FAILURE) break;
                        e = TaskExitCode.CANCELLED;
                        return e;
                    }
                    case COMPLETED: {
                        task.state = TaskState.COMPLETED;
                        Object e = new TaskEvent(task);
                        fs.fireComplete((TaskEvent)e);
                        break;
                    }
                    case ABORTED: {
                        task.state = TaskState.ABORTED_INCOMPLETE;
                    }
                }
            }
            catch (Throwable e) {
                task.state = TaskState.ABORTED_ON_EXCEPTION;
                if (e instanceof TaskException) {
                    fs.fireException(ee, (TaskException)e);
                } else {
                    fs.fireException(ee, new TaskException(e));
                }
                if (this.policy != TaskGroupExecutionPolicy.ABORT_ON_FAILURE) continue;
                TaskExitCode taskExitCode = TaskExitCode.CANCELLED;
                return taskExitCode;
            }
        }
        return TaskExitCode.COMPLETED;
    }

    private class InternalTaskListener
    implements TaskListener {
        TaskMonitor groupClientServices;
        TaskFrameworkServicesImpl groupFrameworkServices;

        public InternalTaskListener() {
            this.groupClientServices = new DefaultTaskMonitorImpl(TaskGroup.this);
            this.groupFrameworkServices = new TaskFrameworkServicesImpl(TaskGroup.this);
        }

        @Override
        public void taskComplete(TaskEvent e) {
            TaskGroup.this.countDone += e.getSource().getTotalCount();
            if (TaskGroup.this.currentTask == TaskGroup.this.groupTasks.size()) {
                this.groupFrameworkServices.fireComplete(new TaskEvent(TaskGroup.this));
            }
        }

        @Override
        public void taskException(TaskEvent e, Exception ex) {
        }

        @Override
        public void taskPaused(TaskEvent e) {
        }

        @Override
        public void taskProgress(ProgressEvent e) {
            ProgressEvent p = new ProgressEvent(TaskGroup.this, TaskGroup.this.countDone + e.getCurrent(), 0L, e.getMessage());
            this.groupClientServices.fireProgress(p);
        }

        @Override
        public void taskStarted(TaskEvent e) {
            String[] message = new String[2];
            message[1] = e.getSource().getShortName();
            message[0] = TaskGroup.this.getCurrentTaskCount() + "/" + TaskGroup.this.getTotalTaskCount();
            this.groupClientServices.fireUpdate(new UpdateEvent(TaskGroup.this, message));
        }

        @Override
        public void taskUpdate(UpdateEvent e) {
        }

        @Override
        public void taskCancelled(TaskEvent e) {
        }
    }
}

