/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task;

import java.util.ArrayList;
import oracle.ide.task.Task;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskListener;
import oracle.ide.task.event.UpdateEvent;

public class DefaultTaskMonitorImpl
implements TaskMonitor {
    private final ArrayList<TaskListener> list;
    private int maxProgressCount = 100;
    private int minProgressCount = 0;
    private final Task task;

    public DefaultTaskMonitorImpl(Task task) {
        this.list = task.getListenerList();
        this.task = task;
    }

    private DefaultTaskMonitorImpl(Task task, int minProgressCount, int maxProgressCount) {
        this.list = task.getListenerList();
        this.task = task;
        this.minProgressCount = minProgressCount * this.maxProgressCount / 100;
        this.maxProgressCount = this.maxProgressCount * maxProgressCount / 100;
        if (this.maxProgressCount > 100) {
            this.maxProgressCount = 100;
        }
    }

    @Override
    public void fireUpdate(UpdateEvent tu) {
        for (TaskListener t : this.list) {
            if (t == null) continue;
            t.taskUpdate(tu);
        }
    }

    @Override
    public void fireProgress(ProgressEvent p) {
        p.setCurrent(this.minProgressCount + p.getCurrent() * (this.maxProgressCount - this.minProgressCount) / 100);
        for (TaskListener t : this.list) {
            if (t == null) continue;
            t.taskProgress(p);
        }
    }

    @Override
    public TaskMonitor getTaskMonitorForSegment(int minProgressCount, int maxProgressCount) {
        return new DefaultTaskMonitorImpl(this.task, minProgressCount, maxProgressCount);
    }

    @Override
    public Task getSource() {
        return this.task;
    }
}

