/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.MoveDialogArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.ui.Colors;

public final class ActionHandlerUtil {
    private ActionHandlerUtil() {
    }

    public static final void reportNonDeletedURLs(List<URL> urls, boolean silent) {
        if (urls.isEmpty()) {
            return;
        }
        if (!silent) {
            ActionHandlerUtil.raiseDeletionFailedDialog(urls);
        } else {
            Assert.println((String)("Failed to delete " + urls.size() + " files"));
            for (URL url : urls) {
                Assert.println((String)URLFileSystem.toDisplayString((URL)url));
            }
        }
    }

    public static void raiseDeletionFailedDialog(List<URL> urls) {
        DetailDialog nonDeleteDialog = DetailDialog.createDetailDialog(null, (String)DeleteDialogArb.getString(29), (int)1);
        JList<String> urlsContent = new JList<String>(ActionHandlerUtil.convertAllToDisplayStrings(urls));
        urlsContent.setForeground(Colors.HINT_TEXT);
        MessagePanel messagePanel = new MessagePanel();
        messagePanel.setTitle(DeleteDialogArb.getString(30));
        messagePanel.setMessageText(DeleteDialogArb.getString(31));
        messagePanel.setMessageType(3);
        nonDeleteDialog.setContent((Component)messagePanel);
        nonDeleteDialog.setDetailContent((Component)new JScrollPane(urlsContent));
        nonDeleteDialog.runDialog();
    }

    public static void raiseMoveFailedDialog(List<URL> urls) {
        DetailDialog nonMoveDialog = DetailDialog.createDetailDialog(null, (String)MoveDialogArb.getString(4), (int)1);
        JList<String> urlsContent = new JList<String>(ActionHandlerUtil.convertAllToDisplayStrings(urls));
        urlsContent.setForeground(Colors.HINT_TEXT);
        MessagePanel messagePanel = new MessagePanel();
        messagePanel.setTitle(MoveDialogArb.getString(5));
        messagePanel.setMessageText(MoveDialogArb.getString(6));
        messagePanel.setMessageType(3);
        nonMoveDialog.setContent((Component)messagePanel);
        nonMoveDialog.setDetailContent((Component)new JScrollPane(urlsContent));
        nonMoveDialog.runDialog();
    }

    public static final void reportNonMovedURLs(List<URL> urls, boolean silent) {
        if (urls.isEmpty()) {
            return;
        }
        if (silent) {
            ActionHandlerUtil.raiseMoveFailedDialog(urls);
        } else {
            Assert.println((String)("Failed to move " + urls.size() + " elements"));
            for (URL url : urls) {
                Assert.println((String)URLFileSystem.toDisplayString((URL)url));
            }
        }
    }

    private static String[] convertAllToDisplayStrings(List<URL> urls) {
        ArrayList<String> resultFiles = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            resultFiles.add(url.getPath());
        }
        return resultFiles.toArray(new String[urls.size()]);
    }
}

