/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Element;
import oracle.ide.refactoring.BaseActionHandler;

abstract class AbstractActionHandlerService<CONCRETE_ACTION_HANDLER extends BaseActionHandler> {
    private Map<String, HandlerLoadingInfo> m_element2HandlerMap = new HashMap<String, HandlerLoadingInfo>();
    private Map<String, Class<? extends CONCRETE_ACTION_HANDLER>> m_handlerName2ClassMap = new HashMap<String, Class<? extends CONCRETE_ACTION_HANDLER>>();
    private ArrayList<BaseActionHandler.LookupHelper> m_lookupHelpers = new ArrayList<DefaultLookupHelper>(Collections.singletonList(new DefaultLookupHelper()));

    AbstractActionHandlerService() {
    }

    protected abstract <T extends CONCRETE_ACTION_HANDLER> T _createActionHandler(Context var1);

    final void _registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId) {
        if (elementClassName == null || "".equals(elementClassName)) {
            throw new IllegalArgumentException("elementClassName '" + elementClassName + "' is mandatory argument");
        }
        if (refactoringActionHandlerClassName == null || "".equals(refactoringActionHandlerClassName)) {
            throw new IllegalArgumentException("refactoringActionHandlerClassName '" + refactoringActionHandlerClassName + "' is mandatory argument");
        }
        if (extensionId == null || "".equals(extensionId)) {
            throw new IllegalArgumentException("extensionId '" + extensionId + "' is mandatory argument");
        }
        HandlerLoadingInfo info = new HandlerLoadingInfo(refactoringActionHandlerClassName, extensionId);
        this.m_element2HandlerMap.put(elementClassName, info);
    }

    final void _registerActionHandler(Class<? extends Element> classKey, Class<? extends CONCRETE_ACTION_HANDLER> refactoringActionHandlerClass) {
        String elementClassName = classKey.getName();
        String refactoringActionHandlerClassName = refactoringActionHandlerClass.getName();
        HandlerLoadingInfo info = new HandlerLoadingInfo(refactoringActionHandlerClassName, null);
        this.m_element2HandlerMap.put(elementClassName, info);
        this.m_handlerName2ClassMap.put(refactoringActionHandlerClassName, refactoringActionHandlerClass);
    }

    final Class<? extends CONCRETE_ACTION_HANDLER> _unregisterActionHandler(String elementClassName) {
        HandlerLoadingInfo info = this.m_element2HandlerMap.remove(elementClassName);
        if (info != null) {
            return this.m_handlerName2ClassMap.remove(info.getHandlerClassName());
        }
        return null;
    }

    final Class<? extends CONCRETE_ACTION_HANDLER> _unregisterActionHandler(Class<? extends Element> classKey) {
        String elementClassName = classKey.getName();
        return this._unregisterActionHandler(elementClassName);
    }

    final void _registerLookupHelper(BaseActionHandler.LookupHelper<? extends CONCRETE_ACTION_HANDLER> lookupHelper) {
        this.m_lookupHelpers.add(0, lookupHelper);
    }

    protected final Class<? extends CONCRETE_ACTION_HANDLER> _getHandlerClass(Class<? extends Element> elementClass, Context context) {
        for (BaseActionHandler.LookupHelper helper : this.m_lookupHelpers) {
            Class c = helper.lookup(elementClass, context);
            if (c == null) continue;
            return c;
        }
        return new DefaultLookupHelper().lookup(elementClass, context);
    }

    protected final List<Class<? extends Element>> getAllSelectedElementSubtypes(Element[] elements) {
        ArrayList<Class<? extends Element>> subtypes = new ArrayList<Class<? extends Element>>();
        for (Element e : elements) {
            if (subtypes.contains(e.getClass())) continue;
            subtypes.add(e.getClass());
        }
        Collections.sort(subtypes, new Comparator<Class<? extends Element>>(){

            @Override
            public int compare(Class<? extends Element> o1, Class<? extends Element> o2) {
                if (o2 != null && o2.isAssignableFrom(o1)) {
                    return -1;
                }
                if (o1 != null && o1.isAssignableFrom(o2)) {
                    return 1;
                }
                return 0;
            }
        });
        return subtypes;
    }

    private static class HandlerLoadingInfo {
        private String handlerClassName;
        private String extensionId;

        protected HandlerLoadingInfo(String handlerClassName, String extensionId) {
            this.handlerClassName = handlerClassName;
            this.extensionId = extensionId;
        }

        protected String getHandlerClassName() {
            return this.handlerClassName;
        }

        protected String getExtensionId() {
            return this.extensionId;
        }
    }

    private class DefaultLookupHelper
    implements BaseActionHandler.LookupHelper<CONCRETE_ACTION_HANDLER> {
        private DefaultLookupHelper() {
        }

        @Override
        public Class<? extends CONCRETE_ACTION_HANDLER> lookup(Class<? extends Element> elementClass, Context context) {
            HandlerLoadingInfo info = (HandlerLoadingInfo)AbstractActionHandlerService.this.m_element2HandlerMap.get(elementClass.getName());
            Class<? extends Element> superClass = elementClass;
            while (info == null && superClass != null && !superClass.equals(Element.class)) {
                if ((superClass = superClass.getSuperclass()) == null) continue;
                info = (HandlerLoadingInfo)AbstractActionHandlerService.this.m_element2HandlerMap.get(superClass.getName());
            }
            if (info != null) {
                String handlerClassName = info.getHandlerClassName();
                Class<Object> handlerClass = (Class<Object>)AbstractActionHandlerService.this.m_handlerName2ClassMap.get(handlerClassName);
                if (handlerClass == null) {
                    String extensionId = info.getExtensionId();
                    ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
                    MetaClass metaClass = new MetaClass(loader, handlerClassName);
                    try {
                        handlerClass = metaClass.toClass().asSubclass(Object.class);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (handlerClass != null) {
                        AbstractActionHandlerService.this.m_handlerName2ClassMap.put(handlerClassName, handlerClass);
                    }
                }
                return handlerClass;
            }
            return null;
        }
    }
}

