/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ModelArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class WorkingSets
extends HashStructureAdapter {
    @Deprecated
    public static final boolean ENABLED = Boolean.valueOf(System.getProperty("working.sets.enabled", "true"));
    public static final String ADD_TO_WORKING_SET_CMD = "working-set-add-to-working-set";
    @Deprecated
    public static int ADD_TO_WORKING_SET_CMD_ID;
    @Deprecated
    public static final String ADD_TO_WORKING_SET_MSG_KEY = "add-to-working-set";
    @Deprecated
    public static final String DEFAULT_WORKING_SET_LABEL;
    public static final String ALL_FILES_WORKING_SET_LABEL;
    public static final String DATA_KEY = "working-sets";
    private static final String CURRENT_WORKING_SET_NAME = ".current";

    private WorkingSets(HashStructure hash) {
        super(hash);
    }

    private WorkingSets(HashStructureNode node) {
        this(WorkingSets.getHashStructure(node));
        if (node != null) {
            node.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    WorkingSets.this.getWorkingSet(ALL_FILES_WORKING_SET_LABEL);
                    if (!WorkingSets.this._hash.containsKey(WorkingSets.CURRENT_WORKING_SET_NAME)) {
                        WorkingSets.this.setCurrentWorkingSetName(ALL_FILES_WORKING_SET_LABEL);
                    }
                }
            });
        }
    }

    private static HashStructure getHashStructure(HashStructureNode node) {
        HashStructure userProps;
        if (node != null && (userProps = node.getPropertiesForOverriding()) != null) {
            return userProps.getOrCreateHashStructure(DATA_KEY);
        }
        return HashStructure.newInstance();
    }

    @Deprecated
    public static WorkingSets getInstance(Project project) {
        return new WorkingSets(HashStructure.newInstance());
    }

    public static WorkingSets getInstance(Workspace workspace) {
        return WorkingSets.getInstance((HashStructureNode)workspace);
    }

    private static WorkingSets getInstance(HashStructureNode node) {
        return new WorkingSets(node);
    }

    public WorkingSet getWorkingSet(String workingSetName) {
        return WorkingSet.getInstance(this._hash, workingSetName);
    }

    public static boolean validateName(String workingSetName) {
        return WorkingSet.validateName(workingSetName);
    }

    public static WorkingSet getOrCreateWorkingSet(Workspace workspace, String name, List<Project> includeProjects, Map<URL, List<URL>> projectUrlToFileUrls) {
        if (workspace == null) {
            throw new NullPointerException("The Workspace cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("The working set name cannot be null");
        }
        if (!WorkingSets.validateName(name)) {
            throw new IllegalStateException("The name is not valid: cannot be (All Files) or contain backward or forward slash characters");
        }
        if (includeProjects == null) {
            throw new NullPointerException("The project list cannot be null");
        }
        if (projectUrlToFileUrls == null) {
            throw new NullPointerException("The Map cannot be null");
        }
        WorkingSets appWorkingSets = WorkingSets.getInstance(workspace);
        if (appWorkingSets.getWorkingSetNames().contains(name)) {
            appWorkingSets.deleteWorkingSet(name);
        }
        WorkingSet temp = WorkingSet.getInstance(HashStructure.newInstance(), name);
        temp.includeOnly(includeProjects);
        for (Project project : includeProjects) {
            temp.includeChildren(project, projectUrlToFileUrls.get(project.getURL()), true);
        }
        WorkingSet workingSet = appWorkingSets.getWorkingSet(name);
        temp.copyTo((Object)workingSet);
        return workingSet;
    }

    static WorkingSets projectWorkingSets(HashStructure hash) {
        return new WorkingSets(hash);
    }

    static void migrateExcludeListToIncludeList(Workspace workspace) {
        WorkingSet defaultWorkingSet;
        WorkingSets workingSets = WorkingSets.getInstance(workspace);
        List names = workingSets.getWorkingSetNames();
        names.remove(ALL_FILES_WORKING_SET_LABEL);
        if (workingSets.containsKey(DEFAULT_WORKING_SET_LABEL) && !(defaultWorkingSet = workingSets.getWorkingSet(DEFAULT_WORKING_SET_LABEL)).preMigrateFromExcludeList() && !defaultWorkingSet.hasProjectLevelFilters()) {
            names.remove(DEFAULT_WORKING_SET_LABEL);
            workingSets.deleteWorkingSet(DEFAULT_WORKING_SET_LABEL);
        }
        if (!names.isEmpty()) {
            Set<URL> projectUrls = null;
            for (String name : names) {
                WorkingSet set = workingSets.getWorkingSet(name);
                if (!set.preMigrateFromExcludeList()) continue;
                if (projectUrls == null && (projectUrls = WorkingSets.projectUrls(workspace)).isEmpty()) {
                    return;
                }
                set.migrateFromExcludeListToIncludeList(projectUrls);
            }
        }
    }

    public static Set<URL> projectUrls(Workspace workspace) {
        HashSet<URL> projectUrls = new HashSet<URL>();
        Iterator<Element> projectIterator = workspace.getChildren();
        while (projectIterator.hasNext()) {
            Element element = projectIterator.next();
            if (!(element instanceof Project)) continue;
            Project project = (Project)element;
            projectUrls.add(project.getURL());
        }
        return projectUrls;
    }

    public String getCurrentWorkingSetName() {
        return this._hash.getString(CURRENT_WORKING_SET_NAME);
    }

    public void setCurrentWorkingSetName(String name) {
        if (name == null) {
            throw new NullPointerException("The working set name is null.");
        }
        this._hash.putString(CURRENT_WORKING_SET_NAME, name, true);
    }

    public WorkingSet getCurrentWorkingSet() {
        String name = this.getCurrentWorkingSetName();
        if (name != null) {
            return this.getWorkingSet(name);
        }
        return null;
    }

    public List getWorkingSetNames() {
        ArrayList list = new ArrayList();
        list.addAll(this._hash.keySet());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (this._hash.getObject(key) instanceof HashStructure) continue;
            iter.remove();
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    public void deleteWorkingSet(String workingSetName) {
        if (!CURRENT_WORKING_SET_NAME.equals(workingSetName) && !ALL_FILES_WORKING_SET_LABEL.equals(workingSetName)) {
            this._hash.remove(workingSetName);
        }
    }

    static synchronized void init() {
    }

    static {
        try {
            ADD_TO_WORKING_SET_CMD_ID = Ide.findOrCreateCmdID(ADD_TO_WORKING_SET_CMD);
        }
        catch (Exception e) {
            ADD_TO_WORKING_SET_CMD_ID = -1;
        }
        DEFAULT_WORKING_SET_LABEL = ModelArb.getString(58);
        ALL_FILES_WORKING_SET_LABEL = ModelArb.getString(59);
    }
}

