/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;

public class ResourcePathsMigrator
extends NodeMigratorHelper {
    private static final String ORIGINAL_RESOURCES_DATA_KEY = "oracle.jdeveloper.resources.ResourcePaths";
    private static String ORIGINAL_CONTENT_SET_KEY = "oracle.jdeveloper.resources.ResourcePaths/resourcesContentSet";

    @Override
    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        int length = infos.length;
        for (int i = 0; i < length; ++i) {
            Node node = infos[i].getNode();
            if (!(node instanceof Project)) continue;
            Project project = (Project)node;
            HashStructure properties = project.getProperties();
            HashStructure resProperties = properties.getHashStructure(ORIGINAL_CONTENT_SET_KEY);
            if (resProperties != null) {
                HashStructure resources = properties.getOrCreateHashStructure("oracle.ide.model.ResourcePaths/resourcesContentSet");
                resProperties.copyTo(resources);
            }
            properties.remove(ORIGINAL_RESOURCES_DATA_KEY);
            ProjectContent.getInstance(project).getContentSetList().remove((Object)ORIGINAL_CONTENT_SET_KEY);
        }
    }
}

