/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Locatable;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryElement;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;

public abstract class RelativeDirectoryContextFolder
implements RelativeDirectoryElement {
    @Override
    public abstract String getRelativePath();

    @Override
    public abstract URLPath getRootDirectories();

    public abstract List<String> getContentSetKeys();

    public final boolean canContainJavaSources() {
        List<String> contentSetKeys = this.getContentSetKeys();
        for (ContentSetProviderReference provider : ProjectContent.getContentSetProviderReferences()) {
            if (!contentSetKeys.contains(provider.key()) || !provider.canContainJavaSources()) continue;
            return true;
        }
        return false;
    }

    RelativeDirectoryContextFolder() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RelativeDirectoryContextFolder) {
            RelativeDirectoryContextFolder rdcf = (RelativeDirectoryContextFolder)obj;
            return rdcf.getRelativePath().equals(this.getRelativePath()) && rdcf.getRootDirectories().equals((Object)this.getRootDirectories());
        }
        if (obj instanceof Locatable) {
            Locatable l = (Locatable)obj;
            Iterator iterator = this.getRootDirectories().iterator();
            if (iterator.hasNext()) {
                URL rootURL = (URL)iterator.next();
                URL newURL = URLFactory.newDirURL((URL)rootURL, (String)this.getRelativePath());
                return l.getURL().equals(newURL);
            }
        }
        return false;
    }
}

