/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.RecognizersHook;
import oracle.ide.model.RootElementRecognizerHookHelper;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;

class NamespaceRecognizerHookHelper {
    private static Logger LOG = Logger.getLogger(RecognizersHook.class.getName());

    static Map<XMLRecognizer.NSElem, MetaClass<Node>> findNamespaceMappings(HashStructure hs) {
        return Collections.unmodifiableMap(NamespaceRecognizerHookHelper.buildNamespaceMappings(hs));
    }

    private static Map<XMLRecognizer.NSElem, MetaClass<Node>> buildNamespaceMappings(HashStructure hs) {
        HashMap<XMLRecognizer.NSElem, MetaClass<Node>> mappings = new HashMap<XMLRecognizer.NSElem, MetaClass<Node>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers == null) {
            return mappings;
        }
        for (Object o : xmlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            NamespaceRecognizerHookHelper.addNamespaceMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addNamespaceMapping(HashStructure hs, Map<XMLRecognizer.NSElem, MetaClass<Node>> mappings) {
        List namespaces = hs.getAsList("namespace");
        if (namespaces == null) {
            return;
        }
        for (Object o : namespaces) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String uri = childHs.getString("uri/#text");
            String elemName = childHs.getString("elem-name/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            RootElementRecognizerHookHelper.registerXMLExtension(childHs);
            if (metaClass == null) {
                LOG.warning("Invalid registration of XML recognizer registration. 'node-type' element was " + metaClass + ", 'uri' was " + uri + ", and 'elem-name' was " + elemName + " . 'namespace' text was " + childHs.getString("#text") + " and it should have been empty.");
                continue;
            }
            mappings.put(new XMLRecognizer.NSElem(uri, elemName), metaClass);
        }
    }

    private NamespaceRecognizerHookHelper() {
    }
}

