/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.AbstractFileContentRecognizerTemplate;
import oracle.ide.model.ContentRecognizerHookHelper;
import oracle.ide.model.Recognizer;
import oracle.javatools.data.HashStructure;

class LowPriorityContentRecognizerHelper {
    static Collection<AbstractFileContentRecognizerTemplate.FileContentRule> findLowPriorityContentMappings(HashStructure hs) {
        return Collections.unmodifiableCollection(LowPriorityContentRecognizerHelper.buildContentMappings(hs));
    }

    private static Collection<AbstractFileContentRecognizerTemplate.FileContentRule> buildContentMappings(HashStructure hs) {
        HashSet<AbstractFileContentRecognizerTemplate.FileContentRule> mappings = new HashSet<AbstractFileContentRecognizerTemplate.FileContentRule>();
        List contentRecognizers = hs.getAsList("low-priority-content-recognizer");
        if (contentRecognizers == null) {
            return mappings;
        }
        for (Object o : contentRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            LowPriorityContentRecognizerHelper.addContentMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addContentMapping(HashStructure hs, Collection<AbstractFileContentRecognizerTemplate.FileContentRule> mappings) {
        List contents = hs.getAsList("content");
        if (contents == null) {
            return;
        }
        for (Object o : contents) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String protocol = childHs.getString("protocol/#text");
            String extension = childHs.getString("extension/#text");
            File fileExtension = null;
            if (extension != null && extension.length() > 0) {
                fileExtension = Recognizer.sanitizeExtension(extension);
            }
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            mappings.add(new AbstractFileContentRecognizerTemplate.FileContentRule(protocol, fileExtension, ContentRecognizerHookHelper.contents(childHs), metaClass));
        }
    }

    private LowPriorityContentRecognizerHelper() {
    }
}

