/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.model.FacadeTextBuffer;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

class FacadeTextBufferListeners
extends CopyOnWriteArrayList<TextBufferListener>
implements TextBufferListener {
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private TextNode node;

    public FacadeTextBufferListeners(TextNode node) {
        this.node = node;
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        if (!this.node.isLoading()) {
            this.node.setTimestampDirectly(System.currentTimeMillis());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.insertUpdate((TextBuffer)facadeBuffer, offset, count, insertedData);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + insertedData.length + " at " + offset, e);
            }
        }
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
        if (!this.node.isLoading()) {
            this.node.setTimestampDirectly(System.currentTimeMillis());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.removeUpdate((TextBuffer)facadeBuffer, offset, count, removedData);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + removedData.length + " from " + offset, e);
            }
        }
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
        if (!this.node.isLoading() && attribute == 5) {
            this.node.markDirty(buffer.isModified());
        }
        FacadeTextBuffer facadeBuffer = this.node.facadeBuffer();
        facadeBuffer.throwIfExpired();
        for (TextBufferListener listener : this) {
            try {
                listener.attributeUpdate((TextBuffer)facadeBuffer, attribute);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute " + attribute, e);
            }
        }
    }
}

