/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import javax.ide.util.MetaResource;
import javax.swing.ImageIcon;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.LazyResourceAdapter;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ImageIconCache;

class DocumentInfoRecognizerHookHelper {
    static Map<String, Recognizer.DeclarativeDocumentInfo> findDocumentInfoMappings(HashStructure hs) {
        return Collections.unmodifiableMap(DocumentInfoRecognizerHookHelper.buildDocumentInfos(hs));
    }

    private static Map<String, Recognizer.DeclarativeDocumentInfo> buildDocumentInfos(HashStructure hs) {
        HashMap<String, Recognizer.DeclarativeDocumentInfo> mappings = new HashMap<String, Recognizer.DeclarativeDocumentInfo>();
        List urlRecognizers = hs.getAsList("document-infos");
        if (urlRecognizers == null) {
            return mappings;
        }
        for (Object o : urlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            DocumentInfoRecognizerHookHelper.addDocumentInfo(childHs, mappings);
        }
        return mappings;
    }

    private static void addDocumentInfo(HashStructure hs, Map<String, Recognizer.DeclarativeDocumentInfo> mappings) {
        List fileExtensions = hs.getAsList("document-info");
        if (fileExtensions == null) {
            return;
        }
        for (Object o : fileExtensions) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String label = childHs.getString("label/#text");
            boolean hidden = childHs.getBoolean("hidden/#text", false);
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass type = adapter.getMetaClass("node-type/#text");
            DocumentInfo info = new DocumentInfo(label, hidden);
            Object icon = childHs.getObject("icon/#text");
            URL iconUrl = null;
            if (icon instanceof URL) {
                iconUrl = (URL)icon;
            } else {
                LazyResourceAdapter lra = LazyResourceAdapter.getInstance(childHs);
                MetaResource mr = lra.getMetaResource("icon/#text");
                URL uRL = iconUrl = mr != null ? mr.toURL() : null;
            }
            if (iconUrl != null) {
                ImageIcon imageIcon = ImageIconCache.get((URL)iconUrl);
                ImageIcon result = null;
                if (imageIcon.getImageLoadStatus() == 8) {
                    result = imageIcon;
                }
                if (result != null) {
                    info.setIcon(result);
                }
            }
            mappings.put(type.getClassName(), new Recognizer.DeclarativeDocumentInfo(info, type));
        }
    }

    private DocumentInfoRecognizerHookHelper() {
    }
}

