/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.DependableRecognizer;
import oracle.javatools.data.HashStructure;

class DependableFactoryReference {
    private static final Logger LOGGER = Logger.getLogger(DependableFactoryReference.class.getName());
    private final String extension;
    private final MetaClass<DependableRecognizer> recognizer;
    private final List<String> dependables;
    private final String id;
    private boolean errorneous;
    private DependableRecognizer instance;

    private DependableFactoryReference(String extension, MetaClass<DependableRecognizer> recognizer, List<String> dependables, String id) {
        this.extension = extension;
        this.recognizer = recognizer;
        this.dependables = dependables;
        this.id = id;
    }

    public MetaClass<DependableRecognizer> getType() {
        return this.recognizer;
    }

    public String getExtensionId() {
        return this.extension;
    }

    public Iterable<String> getDependables() {
        return this.dependables;
    }

    public String getId() {
        return this.id;
    }

    public synchronized DependableRecognizer getInstance() {
        if (this.instance == null) {
            if (this.errorneous) {
                return null;
            }
            try {
                this.instance = (DependableRecognizer)this.getType().newInstance();
            }
            catch (ClassCastException ex) {
                this.errorneous = true;
                LOGGER.log(Level.WARNING, "Erroneous dependable-factory-hook in " + this.getExtensionId(), ex);
            }
            catch (InstantiationException ex) {
                this.errorneous = true;
                LOGGER.log(Level.WARNING, "Erroneous dependable-factory-hook in " + this.getExtensionId(), ex);
            }
            catch (IllegalAccessException ex) {
                this.errorneous = true;
                LOGGER.log(Level.WARNING, "Erroneous dependable-factory-hook in " + this.getExtensionId(), ex);
            }
            catch (ClassNotFoundException ex) {
                this.errorneous = true;
                LOGGER.log(Level.WARNING, "Erroneous dependable-factory-hook in " + this.getExtensionId(), ex);
            }
        }
        return this.instance;
    }

    static DependableFactoryReference create(HashStructure hs) {
        DependableFactoryReference dfr = new DependableFactoryReference(DependableFactoryReference.readExtension(hs), DependableFactoryReference.readRecognizer(hs), DependableFactoryReference.readDependables(hs), DependableFactoryReference.readId(hs));
        if (dfr.id == null) {
            LOGGER.log(Level.WARNING, "Erroneous dependable-factory-hook in " + dfr.extension + " no id.");
            return null;
        }
        return dfr;
    }

    private static String readId(HashStructure hs) {
        return hs.getString("id/#text");
    }

    private static String readExtension(HashStructure hs) {
        return HashStructureHook.getExtensionId(hs);
    }

    private static MetaClass<DependableRecognizer> readRecognizer(HashStructure hs) {
        return LazyClassAdapter.getInstance(hs).getMetaClass("class/#text");
    }

    private static List<String> readDependables(HashStructure hs) {
        List l;
        ArrayList<String> deps = new ArrayList<String>();
        HashStructure dhs = hs.getHashStructure("dependables");
        if (dhs != null && (l = dhs.getAsList("class")) != null) {
            for (Object dc : l) {
                String dcn;
                if (!(l instanceof HashStructure) || (dcn = ((HashStructure)l).getString("#text")) == null) continue;
                deps.add(dcn);
            }
        }
        return deps;
    }
}

