/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableFactoryHook;
import oracle.ide.model.DependableFactoryReference;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.DiscoveredDependable;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;

public final class DependableFactory {
    private static final String PROP_CLASS = "class";
    private static final String PROP_RID = "recognizerId";
    private static final String PROP_DEPENDABLE = "dependable";
    private static final DependableFactory INSTANCE = new DependableFactory();

    private DependableFactory() {
    }

    public static DependableFactory getInstance() {
        return INSTANCE;
    }

    public Dependable createDependable(Context context) {
        Context createContext = new Context(context);
        Params params = new Params(createContext);
        this.ensureOrigin(params);
        this.ensureParent(params);
        for (DependableFactoryReference dfr : this.getAllDependableFactoryHooks()) {
            Dependable d;
            DependableRecognizer dr = dfr.getInstance();
            if (dr == null || (d = dr.create(createContext)) == null) continue;
            return d;
        }
        return null;
    }

    private Iterable<DependableFactoryReference> getAllDependableFactoryHooks() {
        return DependableFactoryHook.getHook().getAllFactories();
    }

    HashStructure toHashStructure(Dependable dependable, Element source) {
        DependableFactoryReference dfr = null;
        HashStructure hs = null;
        for (DependableFactoryReference dfrLoop : this.getAllDependableFactoryHooks()) {
            DependableRecognizer dr = dfrLoop.getInstance();
            if (dr == null) continue;
            dfr = dfrLoop;
            hs = dr.toHashStructure(dependable, source);
            if (hs == null) continue;
            break;
        }
        if (dfr == null) {
            throw new IllegalStateException("No Recognizer registered for Dependable: " + dependable.getClass().getName());
        }
        if (hs == null) {
            throw new IllegalStateException("Recognizer " + dfr.getInstance() + " returned null for " + dependable.getClass().getName() + " when converting to hash structure");
        }
        HashStructure wrapper = HashStructure.newInstance();
        wrapper.putString(PROP_RID, dfr.getId());
        wrapper.putHashStructure(PROP_DEPENDABLE, hs);
        return wrapper;
    }

    Dependable toDependable(HashStructure hash, Element source) {
        DependableRecognizer r;
        String oldRid = this.getOldRecognizerId(hash);
        String id = oldRid == null ? hash.getString(PROP_RID) : oldRid;
        DependableFactoryReference dfr = DependableFactoryHook.getHook().getFactoryById(id);
        DependableRecognizer dependableRecognizer = r = dfr == null ? null : dfr.getInstance();
        if (r != null) {
            HashStructure h = oldRid == null ? hash.getHashStructure(PROP_DEPENDABLE) : hash;
            Dependable d = r.toDependable(h, source);
            return d;
        }
        throw new IllegalArgumentException("No recognizer for hash structure found");
    }

    public Iterable<DiscoveredDependable> discover(Context context) {
        Context discoverContext = new Context(context);
        Params params = new Params(discoverContext);
        this.ensureOrigin(params);
        ArrayList<DiscoveredDependable> list = new ArrayList<DiscoveredDependable>();
        for (DependableFactoryReference dfr : DependableFactoryHook.getHook().getAllFactories()) {
            Iterable<DiscoveredDependable> els;
            DependableRecognizer dr = dfr == null ? null : dfr.getInstance();
            if (dr == null || (els = dr.discover(discoverContext)) == null) continue;
            for (DiscoveredDependable dd : els) {
                list.add(dd);
            }
        }
        return list;
    }

    private String getOldRecognizerId(HashStructure hash) {
        String id = hash.getString(PROP_RID);
        if (id != null) {
            return null;
        }
        String rn = hash.getString(PROP_CLASS);
        if ("oracle.jdeveloper.library.ProjectLibrary".equals(rn)) {
            return "oracle.jdeveloper.library";
        }
        return "oracle.jdeveloper.deploy.common";
    }

    private void ensureOrigin(Params params) {
        if (params.getOrigin() == null) {
            Assert.println((String)"Element from where dependency is originating should be specified. Set property dependablefactory.debug=true for stack trace.");
            Assert.printStackTrace((boolean)Boolean.getBoolean("dependablefactory.debug"), (String)"Element from where dependency is originating should be specified");
        }
    }

    private void ensureParent(Params params) {
        if (params.getContext().getElement() instanceof Workspace) {
            return;
        }
        if (params.getParent() == null) {
            throw new IllegalArgumentException("Missing parameter. Parent element for object being depended on, must be specified");
        }
    }

    public static class Params {
        private static final String CONTEXT_DEPENDABLE_ORIGIN = Params.class + ".origin";
        private static final String CONTEXT_DEPENDABLE_PARENT = Params.class + ".parent";
        private final Context context;

        public Params(Context context) {
            this.context = context;
        }

        public Element getParent() {
            return (Element)this.context.getProperty(CONTEXT_DEPENDABLE_PARENT);
        }

        public void setParent(Element parent) {
            this.context.setProperty(CONTEXT_DEPENDABLE_PARENT, parent);
        }

        public void setOrigin(Element element) {
            this.context.setProperty(CONTEXT_DEPENDABLE_ORIGIN, element);
        }

        public Element getOrigin() {
            return (Element)this.context.getProperty(CONTEXT_DEPENDABLE_ORIGIN);
        }

        public final Context getContext() {
            return this.context;
        }

        public final Element getElement() {
            return this.context.getElement();
        }

        public final void setElement(Element target) {
            this.context.setElement(target);
        }
    }
}

